/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.Config;
import com.evergage.android.internal.Constants;
import com.evergage.android.internal.DependencyManager;
import com.evergage.android.internal.Sender;
import com.evergage.android.internal.util.DeviceUtil;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.NetworkingUtil;
import com.evergage.android.internal.util.Persistence;
import com.evergage.android.internal.util.SafetyUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

class QueuedEventSender {
    private static final String TAG = "Events";
    private static final String EVENTS_FILENAME = "Evergage-events";
    private static final int MAX_ESTIMATED_BYTES_IN_HTTP_REQUEST = 102400;
    private static final int MAX_ESTIMATED_BYTES_IN_QUEUE = 0x100000;
    private static final int MAX_EVENTS_IN_BATCH = 50;
    private Config config;
    private Sender sender;
    private ArrayList<JSONObject> eventQueue = new ArrayList();
    volatile WeakReference<Sender.SuccessJsonArrayCallback> weakSuccessCallback;
    volatile WeakReference<Sender.FailureCallback> weakFailureCallback;
    private final Sender.SuccessJsonArrayCallback sendSuccessCallback;
    private final Sender.FailureCallback sendFailureCallback;
    private final SafetyUtil.Timer nextQueueSendTimer = new SafetyUtil.Timer(SafetyUtil.sMainHandler, new SafetyUtil.SafeRunnable(){

        @Override
        public void runImpl() {
            if (QueuedEventSender.this.nextQueueSendTimer.isCancelledOrNotStarted()) {
                return;
            }
            QueuedEventSender.this.nextQueueSendTimer.cancel();
            QueuedEventSender.this.sendQueuedEvents();
        }
    });
    private long delayOnResumeMs;
    private long throttleIntervalMs;
    private int throttleLimit;
    private int maxEventsInQueue;
    private long countAddedIntervalStartMs;
    private int countAddedThisInterval;
    private JSONArray eventsInFlight;
    private boolean started;
    private int estimatedBytesInEventQueue;
    private long queueSendDelayMs;
    private long minDelayOnFailureMs;
    private long maxDelayOnFailureMs;
    private UUID uuid;

    QueuedEventSender() {
        this.sendSuccessCallback = new Sender.SuccessJsonArrayCallback(){

            @Override
            @MainThread
            public void onSendSuccessJsonArray(@NonNull Object sender, @NonNull UUID requestUUID, @NonNull Sender.Response response, @NonNull JSONArray jsonArray) {
                SafetyUtil.assertOnMain();
                if (sender != QueuedEventSender.this.sender || !requestUUID.equals(QueuedEventSender.this.uuid)) {
                    return;
                }
                Logger.log(3000, QueuedEventSender.TAG, null, "Successfully sent ", Integer.toString(QueuedEventSender.this.eventsInFlight.length()), " events.");
                QueuedEventSender.this.handleSuccessCallback(requestUUID, response, jsonArray);
                QueuedEventSender.this.nextQueueSendTimer.cancel();
                QueuedEventSender.this.queueSendDelayMs = 0L;
                QueuedEventSender.this.eventsInFlight = null;
                QueuedEventSender.this.uuid = null;
                QueuedEventSender.this.sendQueuedEventsUnlessAlreadyDelayed();
            }
        };
        this.sendFailureCallback = new Sender.FailureCallback(){

            @Override
            @MainThread
            public void onSendFailure(@NonNull Object sender, @NonNull UUID requestUUID, @Nullable Sender.Response response, @NonNull Exception exception) {
                SafetyUtil.assertOnMain();
                if (sender != QueuedEventSender.this.sender || !requestUUID.equals(QueuedEventSender.this.uuid)) {
                    return;
                }
                QueuedEventSender.this.handleFailureCallback(requestUUID, response, exception);
                if (NetworkingUtil.connectivityProblemForError(exception) != 0) {
                    Logger.log(3000, QueuedEventSender.TAG, null, "Re-enqueuing ", Integer.toString(QueuedEventSender.this.eventsInFlight.length()), " events to send later: ", exception.toString());
                    QueuedEventSender.this.addEventsToQueue(QueuedEventSender.this.eventsInFlight, 0);
                    if (QueuedEventSender.this.queueSendDelayMs < QueuedEventSender.this.minDelayOnFailureMs) {
                        QueuedEventSender.this.queueSendDelayMs = QueuedEventSender.this.minDelayOnFailureMs;
                    } else {
                        QueuedEventSender.this.queueSendDelayMs = Math.min(QueuedEventSender.this.queueSendDelayMs * 2L, QueuedEventSender.this.maxDelayOnFailureMs);
                    }
                    QueuedEventSender.this.eventsInFlight = null;
                    QueuedEventSender.this.uuid = null;
                    QueuedEventSender.this.nextQueueSendTimer.cancel();
                    QueuedEventSender.this.sendQueuedEventsAfterDelay();
                } else {
                    Logger.log(1000, QueuedEventSender.TAG, null, "Dropping ", Integer.toString(QueuedEventSender.this.eventsInFlight.length()), " events that failed to send: ", exception.toString());
                    QueuedEventSender.this.queueSendDelayMs = 0L;
                    QueuedEventSender.this.eventsInFlight = null;
                    QueuedEventSender.this.uuid = null;
                    QueuedEventSender.this.nextQueueSendTimer.cancel();
                    QueuedEventSender.this.sendQueuedEventsUnlessAlreadyDelayed();
                }
            }
        };
        JSONArray loadedEvents = Persistence.loadJSONArrayFromFile(EVENTS_FILENAME);
        this.reset();
        if (loadedEvents != null) {
            this.addEventsToQueue(loadedEvents, 0);
        }
    }

    void reset() {
        this.queueSendDelayMs = 0L;
        this.delayOnResumeMs = 0L;
        this.throttleIntervalMs = 10000L;
        this.throttleLimit = 50;
        this.maxEventsInQueue = 1000;
        this.minDelayOnFailureMs = 1000L;
        this.maxDelayOnFailureMs = 600000L;
        this.started = false;
        this.nextQueueSendTimer.cancel();
        this.clear();
        this.weakSuccessCallback = null;
        this.weakFailureCallback = null;
        this.config = DependencyManager.getConfig();
        this.sender = DependencyManager.getSender();
        this.updateConfig();
    }

    void clear() {
        this.uuid = null;
        this.eventsInFlight = null;
        this.eventQueue.clear();
        this.estimatedBytesInEventQueue = 0;
        this.countAddedIntervalStartMs = 0L;
        this.countAddedThisInterval = 0;
        this.deleteFile();
    }

    void updateConfig() {
        if (this.config == null) {
            return;
        }
        Number number = (Number)this.config.objectForKey(Number.class, "delayOnResume", false);
        if (number != null) {
            this.delayOnResumeMs = (long)(number.doubleValue() * 1000.0);
        }
        if ((number = (Number)this.config.objectForKey(Number.class, "eventThrottleLimit", false)) != null) {
            this.throttleLimit = number.intValue();
        }
        if ((number = (Number)this.config.objectForKey(Number.class, "eventThrottleInterval", false)) != null) {
            this.throttleIntervalMs = (long)(number.doubleValue() * 1000.0);
        }
        if ((number = (Number)this.config.objectForKey(Nullable.class, "maxEventsInQueue", false)) != null) {
            this.maxEventsInQueue = number.intValue();
        }
    }

    @MainThread
    void addEvent(@NonNull JSONObject event) {
        SafetyUtil.assertOnMain();
        if (event == null) {
            SafetyUtil.assertFail(0, "No event to send.", null, false);
            this.handleFailureCallback(null, null, new RuntimeException("No event to send."));
            return;
        }
        Long eventTimeMs = JSONUtil.getLong(event, "timestamp");
        if (eventTimeMs == null) {
            Logger.log(4000, TAG, null, "Timestamp missing from event");
            eventTimeMs = System.currentTimeMillis();
        }
        if (this.countAddedIntervalStartMs == 0L || eventTimeMs - this.countAddedIntervalStartMs > this.throttleIntervalMs) {
            this.countAddedIntervalStartMs = eventTimeMs;
            this.countAddedThisInterval = 1;
        } else if (++this.countAddedThisInterval > this.throttleLimit) {
            Logger.log(1000, TAG, null, "Dropping event, exceeded ", Integer.toString(this.throttleLimit), " events / ", Long.toString(this.throttleIntervalMs), " ms");
            return;
        }
        JSONArray events = new JSONArray();
        events.put((Object)event);
        this.enqueueEventsWithoutTriggeringSend(events);
        this.sendQueuedEventsUnlessAlreadyDelayed();
    }

    @MainThread
    void startSendingQueuedEvents() {
        SafetyUtil.assertOnMain();
        if (!this.started) {
            Logger.log(4000, TAG, null, "Allowing sending/attempting");
            this.queueSendDelayMs = this.delayOnResumeMs;
            this.started = true;
        }
        this.sendQueuedEventsAfterDelay();
    }

    @MainThread
    void stopSendingQueuedEvents() {
        SafetyUtil.assertOnMain();
        this.nextQueueSendTimer.cancel();
        if (this.started) {
            Logger.log(4000, TAG, null, "Disallowing sending/attempting");
        }
        this.started = false;
    }

    void deleteFile() {
        Persistence.deleteFilename(EVENTS_FILENAME);
    }

    @MainThread
    void saveToFile() {
        SafetyUtil.assertOnMain();
        String jsonString = this.eventQueue.toString();
        Persistence.saveRawJSONToFile(EVENTS_FILENAME, jsonString);
    }

    private void enqueueEventsWithoutTriggeringSend(@NonNull JSONArray events) {
        this.addEventsToQueue(events, this.eventQueue.size());
    }

    private void sendQueuedEventsAfterDelay() {
        if (this.eventsInFlight != null || !this.started) {
            return;
        }
        this.nextQueueSendTimer.restartWithDelay(this.queueSendDelayMs);
    }

    private void sendQueuedEventsUnlessAlreadyDelayed() {
        if (this.eventsInFlight == null && this.nextQueueSendTimer.isCancelledOrNotStarted() && this.started) {
            this.sendQueuedEvents();
        }
    }

    @MainThread
    private void sendQueuedEvents() {
        SafetyUtil.assertOnMain();
        if (this.eventsInFlight != null) {
            return;
        }
        if (this.eventQueue.size() == 0) {
            this.queueSendDelayMs = 0L;
            return;
        }
        if (this.sender.uriEvents == null) {
            this.queueSendDelayMs = 0L;
            return;
        }
        JSONArray events = this.takeEvents();
        if (events.length() > 0) {
            Logger.log(4000, TAG, null, "Attempting to send ", Integer.toString(events.length()), " events");
            this.eventsInFlight = events;
            this.uuid = this.sender.sendEvents(events, DeviceUtil.timeZoneString(), new WeakReference<Sender.SuccessJsonArrayCallback>(this.sendSuccessCallback), new WeakReference<Sender.FailureCallback>(this.sendFailureCallback));
        }
    }

    @NonNull
    private JSONArray takeEvents() {
        JSONObject event;
        int currentEventIndex;
        int eventsEstimatedSize = 0;
        JSONArray eventsToTake = new JSONArray();
        for (currentEventIndex = 0; currentEventIndex < this.eventQueue.size() && (eventsEstimatedSize += this.estimateSizeOfEvent(event = this.eventQueue.get(currentEventIndex))) <= 102400 && currentEventIndex < 50; ++currentEventIndex) {
            eventsToTake.put((Object)event);
        }
        this.eventQueue.subList(0, currentEventIndex).clear();
        return eventsToTake;
    }

    private void addEventsToQueue(@NonNull JSONArray events, int startIndex) {
        ArrayList<JSONObject> eventsAfterPruning = new ArrayList<JSONObject>();
        int totalSize = 0;
        for (int index = 0; index < events.length(); ++index) {
            JSONObject event = JSONUtil.arrayGetJSONObject(events, index);
            if (event == null) {
                Object obj = JSONUtil.arrayGet(events, index);
                Logger.log(1000, TAG, null, "Dropping non-JSONObject event: ", obj != null ? obj.toString() : null);
                continue;
            }
            int sizeOfThisEvent = this.estimateSizeOfEvent(event);
            if (sizeOfThisEvent > 102400) {
                Logger.log(1000, TAG, null, "Dropping an event that is too large to fit in a single request");
                continue;
            }
            totalSize += sizeOfThisEvent;
            eventsAfterPruning.add(event);
        }
        this.estimatedBytesInEventQueue += totalSize;
        if (eventsAfterPruning.size() > 0) {
            Logger.log(3000, TAG, null, "Enqueuing ", Integer.toString(eventsAfterPruning.size()), " events.");
            this.eventQueue.addAll(startIndex, eventsAfterPruning);
            this.trimExcessEvents();
        }
    }

    private int estimateSizeOfEvent(@NonNull JSONObject event) {
        return event.toString().getBytes(Constants.CHARSET_UTF_8).length;
    }

    private void trimExcessEvents() {
        boolean trimByCount;
        boolean bl = trimByCount = this.eventQueue.size() > this.maxEventsInQueue;
        if (trimByCount) {
            Logger.log(1000, TAG, null, "The number of queued events ", Integer.toString(this.eventQueue.size()), " exceeded the limit ", Integer.toString(this.maxEventsInQueue), ", dropping the excess.");
            this.eventQueue.subList(0, this.eventQueue.size() - this.maxEventsInQueue).clear();
        }
        if (trimByCount || this.estimatedBytesInEventQueue > 0x100000) {
            int retainedEventsSize = this.estimatedBytesInEventQueue;
            int eventsToRemove = 0;
            for (JSONObject event : this.eventQueue) {
                if (retainedEventsSize <= 0x100000) break;
                ++eventsToRemove;
                retainedEventsSize -= this.estimateSizeOfEvent(event);
            }
            if (eventsToRemove > 0) {
                Logger.log(1000, TAG, null, "The number of estimated bytes in the queue exceeded the limit of ", Integer.toString(0x100000), ", dropping ", Integer.toString(eventsToRemove), " events.");
                this.eventQueue.subList(0, eventsToRemove).clear();
            }
            this.estimatedBytesInEventQueue = retainedEventsSize;
        }
    }

    @MainThread
    private void handleSuccessCallback(@NonNull UUID requestUUID, @NonNull Sender.Response response, @NonNull JSONArray eventResponses) {
        SafetyUtil.assertOnMain();
        if (this.weakSuccessCallback == null) {
            return;
        }
        Sender.SuccessJsonArrayCallback strongCallback = (Sender.SuccessJsonArrayCallback)this.weakSuccessCallback.get();
        if (strongCallback == null) {
            return;
        }
        strongCallback.onSendSuccessJsonArray(this, requestUUID, response, eventResponses);
    }

    @MainThread
    private void handleFailureCallback(@NonNull UUID requestUUID, @Nullable Sender.Response response, @NonNull Exception exception) {
        SafetyUtil.assertOnMain();
        if (this.weakFailureCallback == null) {
            return;
        }
        Sender.FailureCallback strongCallback = (Sender.FailureCallback)this.weakFailureCallback.get();
        if (strongCallback == null) {
            return;
        }
        strongCallback.onSendFailure(this, requestUUID, response, exception);
    }
}

