/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal;

import android.annotation.SuppressLint;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.ClientConfiguration;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.Persistence;
import com.evergage.android.internal.util.SafetyUtil;
import com.evergage.android.internal.util.StringUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

class Config {
    private static final String TAG = "Config";
    private static final String FILE_NAME = "Evergage-config";
    private static final String FILE_KEY_CLIENT = "client";
    private static final String FILE_KEY_SDK = "sdk";
    private static final String FILE_KEY_SERVER = "server";
    private static final String KEY_UPDATED = "__updated";
    static final String KEY_LAST_MODIFIED = "__lastModified";
    static final String KEY_LAST_APP_VERSION_CODE = "__lastAppVersionCode";
    static final String KEY_VISITOR_AFFINITY_ID = "__visitorAffinityId";
    static final String KEY_ANON_ID = "__anonId";
    static final String KEY_ACCOUNT = "account";
    static final String KEY_DATASET = "dataset";
    static final String KEY_USE_PUSH_NOTIFICATIONS = "usePushNotifications";
    static final String KEY_DISABLE = "disable";
    static final String KEY_TRACK_FOREGROUND = "trackForeground";
    static final String KEY_TRACK_BACKGROUND = "trackBackground";
    static final String KEY_TRACK_LAUNCH = "trackLaunch";
    static final String KEY_TRACK_INSTALL_UPGRADE = "trackInstallUpgrade";
    static final String KEY_TRACK_ORIENTATION = "trackOrientation";
    static final String KEY_IGNORABLE_CLASSES = "ignorableClasses";
    static final String KEY_CALL_HANDLERS_SAFELY = "callHandlersSafely";
    static final String KEY_PORT = "port";
    static final String KEY_PROTOCOL = "protocol";
    static final String KEY_DOMAIN = "domain";
    static final String KEY_URI_CONFIG = "urlConfig";
    static final String KEY_URI_EVENTS = "urlEvents";
    static final String KEY_CONFIG_MAX_AGE = "configMaxAge";
    static final String KEY_LOG_LEVEL = "logLevel";
    static final String KEY_TEST_EXPERIENCE_TIMEOUT = "testExperienceTimeout";
    static final String KEY_DELAY_ON_RESUME = "delayOnResume";
    static final String KEY_USE_CDN = "useCDN";
    static final String KEY_TIME_ON_PAGE_TIMEOUT = "timeOnPageTimeout";
    static final String KEY_MAX_SCREENS = "maxScreens";
    static final String KEY_MAX_EVENTS_IN_QUEUE = "maxEventsInQueue";
    static final String KEY_CAMPAIGN_DISPATCH_TIMEOUT = "campaignDispatchTimeout";
    static final String KEY_CAMPAIGN_TTL = "campaignTTL";
    static final String KEY_EVENT_THROTTLE_LIMIT = "eventThrottleLimit";
    static final String KEY_EVENT_THROTTLE_INTERVAL = "eventThrottleInterval";
    static final String KEY_CONTEXT_CHECKS_APP_STATE = "contextChecksAppState";
    static final String KEY_APP_STATE_THRESHOLD = "appStateThreshold";
    static final String KEY_APP_STATE_USE_TRIM = "appStateUseTrim";
    static final String KEY_ENABLE_MANIFEST_COMPONENTS = "enableManifestComponents";
    static final String KEY_TAP_THRESHOLD = "tapThreshold";
    static final String KEY_UI_ANIM_ACROSS_ACTIVITIES = "uiAnimAcrossActivities";
    static final String KEY_UI_USE_RAW_COORDS = "uiUseRawCoords";
    static final String KEY_UI_USE_DISPLAY_FRAME = "uiUseDisplayFrame";
    static final String KEY_UI_USE_DISPLAY_SIZE = "uiUseDisplaySize";
    static final String KEY_VELOCITY_MAX_SAMPLES = "velMaxSamples";
    static final String KEY_VELOCITY_LOOKBACK_INTERVAL = "velLookbackInterval";
    static final String KEY_CONNECT_TIMEOUT = "connectTimeout";
    static final String KEY_READ_TIMEOUT = "readTimeout";
    static final String KEY_ALLOW_PUSH_TOKEN_FETCH = "allowPushTokenFetch";
    static final String KEY_DESIGNER_ALERT_TIME = "designerAlertTime";
    private final JSONObject[] configLayers = new JSONObject[5];
    @NonNull
    private final String uniqueId;

    private JSONObject defaults() {
        JSONObject defaults = new JSONObject();
        JSONUtil.put(defaults, KEY_UPDATED, 0L);
        JSONUtil.put(defaults, KEY_USE_PUSH_NOTIFICATIONS, false);
        JSONUtil.put(defaults, KEY_DISABLE, false);
        JSONUtil.put(defaults, KEY_TRACK_FOREGROUND, true);
        JSONUtil.put(defaults, KEY_TRACK_BACKGROUND, true);
        JSONUtil.put(defaults, KEY_TRACK_LAUNCH, true);
        JSONUtil.put(defaults, KEY_TRACK_INSTALL_UPGRADE, true);
        JSONUtil.put(defaults, KEY_TRACK_ORIENTATION, false);
        JSONUtil.put(defaults, KEY_CALL_HANDLERS_SAFELY, false);
        JSONUtil.put(defaults, KEY_PORT, 443);
        JSONUtil.put(defaults, KEY_PROTOCOL, "https");
        JSONUtil.put(defaults, KEY_CONFIG_MAX_AGE, 120);
        JSONUtil.put(defaults, KEY_TEST_EXPERIENCE_TIMEOUT, 1800);
        JSONUtil.put(defaults, KEY_DELAY_ON_RESUME, 0);
        JSONUtil.put(defaults, KEY_USE_CDN, true);
        JSONUtil.put(defaults, KEY_TIME_ON_PAGE_TIMEOUT, 120);
        JSONUtil.put(defaults, KEY_MAX_SCREENS, 50);
        JSONUtil.put(defaults, KEY_MAX_EVENTS_IN_QUEUE, 1000);
        JSONUtil.put(defaults, KEY_CAMPAIGN_DISPATCH_TIMEOUT, 5);
        JSONUtil.put(defaults, KEY_CAMPAIGN_TTL, 300);
        JSONUtil.put(defaults, KEY_EVENT_THROTTLE_LIMIT, 50);
        JSONUtil.put(defaults, KEY_EVENT_THROTTLE_INTERVAL, 10);
        JSONUtil.put(defaults, KEY_CONTEXT_CHECKS_APP_STATE, true);
        JSONUtil.put(defaults, KEY_APP_STATE_THRESHOLD, 0.3);
        JSONUtil.put(defaults, KEY_APP_STATE_USE_TRIM, true);
        JSONUtil.put(defaults, KEY_UI_ANIM_ACROSS_ACTIVITIES, true);
        JSONUtil.put(defaults, KEY_UI_USE_RAW_COORDS, true);
        JSONUtil.put(defaults, KEY_UI_USE_DISPLAY_FRAME, true);
        JSONUtil.put(defaults, KEY_UI_USE_DISPLAY_SIZE, true);
        JSONUtil.put(defaults, KEY_VELOCITY_MAX_SAMPLES, 20);
        JSONUtil.put(defaults, KEY_VELOCITY_LOOKBACK_INTERVAL, 0.1);
        JSONUtil.put(defaults, KEY_CONNECT_TIMEOUT, 15.0);
        JSONUtil.put(defaults, KEY_READ_TIMEOUT, 30.0);
        JSONUtil.put(defaults, KEY_ALLOW_PUSH_TOKEN_FETCH, true);
        JSONUtil.put(defaults, KEY_DESIGNER_ALERT_TIME, 3.0);
        return defaults;
    }

    Config() {
        this.loadFromFile();
        String id2 = (String)this.objectForKeyInLayer(String.class, KEY_ANON_ID, 2, false);
        if (id2 != null) {
            this.uniqueId = id2;
        } else {
            this.uniqueId = id2 = UUID.randomUUID().toString();
            JSONUtil.put(this.configLayers[2], KEY_ANON_ID, id2);
            Logger.log(3000, TAG, null, "Generated anon id: ", id2);
            SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

                @Override
                public void runImpl() {
                    Config.this.saveToFile();
                }
            });
        }
    }

    private void loadFromFile() {
        this.configLayers[0] = this.defaults();
        this.configLayers[1] = new JSONObject();
        this.configLayers[2] = new JSONObject();
        this.configLayers[3] = new JSONObject();
        this.configLayers[4] = new JSONObject();
        JSONObject json = Persistence.loadJSONFromFile(FILE_NAME);
        if (json == null) {
            return;
        }
        JSONObject configLayer = JSONUtil.getJSONObject(json, FILE_KEY_CLIENT);
        if (configLayer != null) {
            this.configLayers[1] = configLayer;
        }
        if ((configLayer = JSONUtil.getJSONObject(json, FILE_KEY_SDK)) != null) {
            this.configLayers[2] = configLayer;
        }
        if ((configLayer = JSONUtil.getJSONObject(json, FILE_KEY_SERVER)) != null) {
            this.configLayers[3] = configLayer;
        }
    }

    @MainThread
    void reset() {
        SafetyUtil.assertOnMain();
        this.configLayers[4] = new JSONObject();
        this.configLayers[3] = new JSONObject();
        this.configLayers[2] = new JSONObject();
        this.configLayers[1] = new JSONObject();
        this.deleteFile();
        JSONUtil.put(this.configLayers[2], KEY_ANON_ID, this.uniqueId);
        this.saveToFile();
    }

    @MainThread
    boolean isExpired() {
        Integer maxAgeSeconds = this.intForKey(KEY_CONFIG_MAX_AGE);
        if (maxAgeSeconds == null || maxAgeSeconds <= 0) {
            maxAgeSeconds = 120;
        }
        long now = System.currentTimeMillis();
        Long updated = this.lastUpdatedForLayer(3);
        if (updated == null) {
            updated = 0L;
        }
        return now >= updated + (long)maxAgeSeconds.intValue() * 1000L;
    }

    @MainThread
    void setExpired() {
        SafetyUtil.assertOnMain();
        if (this.lastUpdatedForLayer(3) != null) {
            JSONUtil.put(this.configLayers[3], KEY_UPDATED, 0L);
        }
        if (this.configLayers[3] != null) {
            JSONUtil.put(this.configLayers[3], KEY_LAST_MODIFIED, null);
        }
    }

    @MainThread
    @Nullable
    Long lastModified() {
        return (Long)this.objectForKeyInLayer(Long.class, KEY_LAST_MODIFIED, 3, true);
    }

    boolean hasEmptyLayer(int layer) {
        if (layer < 0 || layer >= this.configLayers.length) {
            return true;
        }
        JSONObject retrievedLayer = this.configLayers[layer];
        return retrievedLayer.length() == 0;
    }

    @MainThread
    private void saveToFile() {
        SafetyUtil.assertOnMain();
        JSONObject json = new JSONObject();
        JSONUtil.put(json, FILE_KEY_CLIENT, this.configLayers[1]);
        JSONUtil.put(json, FILE_KEY_SDK, this.configLayers[2]);
        JSONUtil.put(json, FILE_KEY_SERVER, this.configLayers[3]);
        String jsonString = json.toString();
        Logger.log(4000, TAG, null, "Saving: ", jsonString);
        Persistence.saveRawJSONToFile(FILE_NAME, jsonString);
    }

    @MainThread
    void deleteFile() {
        SafetyUtil.assertOnMain();
        Persistence.deleteFilename(FILE_NAME);
    }

    static JSONObject clientConfigurationToJson(ClientConfiguration clientConfiguration) {
        JSONObject json = new JSONObject();
        if (clientConfiguration == null) {
            return json;
        }
        JSONUtil.put(json, KEY_ACCOUNT, clientConfiguration.getAccount());
        JSONUtil.put(json, KEY_DATASET, clientConfiguration.getDataset());
        if (clientConfiguration.usePushNotifications() != null) {
            JSONUtil.put(json, KEY_USE_PUSH_NOTIFICATIONS, clientConfiguration.usePushNotifications());
        }
        return json;
    }

    boolean clientConfigValid(@NonNull JSONObject clientConfig) {
        ArrayList<String> invalidKeys = new ArrayList<String>();
        String string = (String)JSONUtil.objectOfType(String.class, KEY_ACCOUNT, clientConfig);
        if (!StringUtil.isValid(string)) {
            invalidKeys.add(KEY_ACCOUNT);
        }
        if (!StringUtil.isValid(string = (String)JSONUtil.objectOfType(String.class, KEY_DATASET, clientConfig))) {
            invalidKeys.add(KEY_DATASET);
        }
        string = (String)JSONUtil.objectOfType(String.class, KEY_PROTOCOL, clientConfig);
        if (JSONUtil.get(clientConfig, KEY_PROTOCOL) != null && !"https".equals(string) && !"http".equals(string)) {
            invalidKeys.add(KEY_PROTOCOL);
        }
        string = (String)JSONUtil.objectOfType(String.class, KEY_DOMAIN, clientConfig);
        if (JSONUtil.get(clientConfig, KEY_DOMAIN) != null && !StringUtil.isValid(string)) {
            invalidKeys.add(KEY_DOMAIN);
        }
        Integer number = (Integer)JSONUtil.objectOfType(Integer.class, KEY_PORT, clientConfig);
        if (JSONUtil.get(clientConfig, KEY_PORT) != null && number == null) {
            invalidKeys.add(KEY_PORT);
        }
        Boolean bool = (Boolean)JSONUtil.objectOfType(Boolean.class, KEY_USE_CDN, clientConfig);
        if (JSONUtil.get(clientConfig, KEY_USE_CDN) != null && bool == null) {
            invalidKeys.add(KEY_USE_CDN);
        }
        bool = (Boolean)JSONUtil.objectOfType(Boolean.class, KEY_USE_PUSH_NOTIFICATIONS, clientConfig);
        if (JSONUtil.get(clientConfig, KEY_USE_PUSH_NOTIFICATIONS) != null && bool == null) {
            invalidKeys.add(KEY_USE_PUSH_NOTIFICATIONS);
        }
        if (!invalidKeys.isEmpty()) {
            Logger.log(1000, TAG, null, "Invalid keys: ", ((Object)invalidKeys).toString());
            return false;
        }
        return true;
    }

    boolean clientConfigRequiresReset(@NonNull JSONObject clientConfig) {
        JSONObject currentClientConfig = this.configLayers[1];
        String newDataset = (String)JSONUtil.objectOfType(String.class, KEY_DATASET, clientConfig);
        String newAccount = (String)JSONUtil.objectOfType(String.class, KEY_ACCOUNT, clientConfig);
        String currentDataset = (String)JSONUtil.objectOfType(String.class, KEY_DATASET, currentClientConfig);
        String currentAccount = (String)JSONUtil.objectOfType(String.class, KEY_ACCOUNT, currentClientConfig);
        if (currentDataset != null && !currentDataset.equals(newDataset) || currentAccount != null && !currentAccount.equals(newAccount)) {
            Logger.log(2000, TAG, null, "Will require reset to update from old client configuration: ", currentClientConfig.toString());
            return true;
        }
        return false;
    }

    @SuppressLint(value={"SwitchIntDef"})
    @MainThread
    void setConfiguration(@NonNull JSONObject config, int layer) {
        SafetyUtil.assertOnMain();
        switch (layer) {
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                Logger.log(2000, TAG, null, "Ignoring attempt to set layer ", Integer.toString(layer));
                return;
            }
        }
        JSONObject filteredConfig = this.filteredConfiguration(config, layer);
        if (filteredConfig != null) {
            JSONUtil.put(filteredConfig, KEY_UPDATED, System.currentTimeMillis());
            JSONObject configLayer = this.configLayers[layer];
            JSONUtil.putAll(configLayer, filteredConfig);
            this.saveToFile();
        }
    }

    @SuppressLint(value={"SwitchIntDef"})
    @MainThread
    void replaceConfiguration(@NonNull JSONObject config, int layer) {
        SafetyUtil.assertOnMain();
        switch (layer) {
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                Logger.log(2000, TAG, null, "Ignoring attempt to replace layer ", Integer.toString(layer));
                return;
            }
        }
        JSONObject filteredConfig = this.filteredConfiguration(config, layer);
        if (filteredConfig != null) {
            JSONUtil.put(filteredConfig, KEY_UPDATED, System.currentTimeMillis());
            this.configLayers[layer] = filteredConfig;
            this.saveToFile();
        }
    }

    @Nullable
    private JSONObject filteredConfiguration(@NonNull JSONObject config, int layer) {
        JSONObject newConfig = JSONUtil.shallowCopy(config);
        if (newConfig == null) {
            return null;
        }
        Iterator keys = config.keys();
        while (keys.hasNext()) {
            Class<?> valueClass;
            String key = (String)keys.next();
            Object value = JSONUtil.get(newConfig, key);
            if (StringUtil.isValid(key) && value != null && (value == JSONObject.NULL || (valueClass = value.getClass()).equals(String.class) || valueClass.equals(Long.class) || valueClass.equals(Double.class) || valueClass.equals(Integer.class) || valueClass.equals(Boolean.class) || valueClass.equals(JSONObject.class) || valueClass.equals(JSONArray.class))) continue;
            Logger.log(2000, TAG, null, "Filter rejecting entry: layer ", Integer.toString(layer), " key ", key, " value ", value == null ? null : value.toString());
            newConfig.remove(key);
        }
        return newConfig;
    }

    @MainThread
    Long lastUpdatedForLayer(int layer) {
        SafetyUtil.assertOnMain();
        if (layer < 0 || layer >= this.configLayers.length) {
            return null;
        }
        Long updated = (Long)JSONUtil.objectOfType(Long.class, KEY_UPDATED, this.configLayers[layer]);
        if (updated == null) {
            return null;
        }
        return updated;
    }

    @MainThread
    @Nullable
    String stringForKey(@NonNull String key) {
        return (String)this.objectForKey(String.class, key, true);
    }

    @MainThread
    @Nullable
    Integer intForKey(@NonNull String key) {
        Number num = (Number)this.objectForKey(Number.class, key, true);
        return num == null ? null : Integer.valueOf(num.intValue());
    }

    @MainThread
    @Nullable
    Long longForKey(@NonNull String key) {
        Number num = (Number)this.objectForKey(Number.class, key, true);
        return num == null ? null : Long.valueOf(num.longValue());
    }

    @MainThread
    @Nullable
    public Double doubleForKey(@NonNull String key) {
        Number num = (Number)this.objectForKey(Number.class, key, true);
        return num == null ? null : Double.valueOf(num.doubleValue());
    }

    @MainThread
    @Nullable
    public Boolean boolForKey(@NonNull String key) {
        return (Boolean)this.objectForKey(Boolean.class, key, true);
    }

    @MainThread
    @Nullable
    JSONObject jsonObjectForKey(@NonNull String key) {
        return (JSONObject)this.objectForKey(JSONObject.class, key, true);
    }

    @MainThread
    @Nullable
    JSONArray jsonArrayForKey(@NonNull String key) {
        return (JSONArray)this.objectForKey(JSONArray.class, key, true);
    }

    @NonNull
    String uniqueIdentifier() {
        return this.uniqueId;
    }

    @Nullable
    Object objectForKey(Class clazz, String key, boolean checkThread) {
        if (checkThread) {
            SafetyUtil.assertOnMain();
        }
        if (!StringUtil.isValid(key)) {
            return null;
        }
        for (int layer = this.configLayers.length - 1; layer >= 0; --layer) {
            Object value = this.objectForKeyInLayer(clazz, key, layer, checkThread);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Nullable
    Object objectForKeyInLayer(Class clazz, String key, int layer, boolean checkThread) {
        if (checkThread) {
            SafetyUtil.assertOnMain();
        }
        if (!StringUtil.isValid(key) || layer < 0 || layer >= this.configLayers.length) {
            return null;
        }
        JSONObject configLayer = this.configLayers[layer];
        return JSONUtil.objectOfType(clazz, key, configLayer);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConfigurationLayer {
        public static final int DEFAULTS = 0;
        public static final int CLIENT = 1;
        public static final int SDKSTATE = 2;
        public static final int SERVER = 3;
        public static final int USERSTATE = 4;
    }
}

