/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.Campaign;
import com.evergage.android.internal.Constants;
import com.evergage.android.internal.DependencyManager;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.SafetyUtil;
import com.evergage.android.internal.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONObject;

abstract class CampaignImpl
implements Campaign {
    private static final String TAG = "Campaign";
    @NonNull
    final JSONObject json;
    @NonNull
    final String contextId;
    final boolean test;
    @Nullable
    final String messageContentHash;
    @Nullable
    final Date expirationTime;
    @NonNull
    private final String target;
    @NonNull
    private final String campaignId;
    @NonNull
    private final String campaignName;
    @NonNull
    private final String experienceId;
    @NonNull
    private final String experienceName;
    @NonNull
    private final String messageId;
    @Nullable
    private final JSONArray promotedItemKeys;
    @NonNull
    private final JSONObject data;
    private final boolean isControlGroup;

    @Override
    @NonNull
    public String getTarget() {
        return this.target;
    }

    @Override
    @NonNull
    public String getCampaignId() {
        return this.campaignId;
    }

    @Override
    @NonNull
    public String getCampaignName() {
        return this.campaignName;
    }

    @Override
    @NonNull
    public String getExperienceId() {
        return this.experienceId;
    }

    @Override
    @NonNull
    public String getExperienceName() {
        return this.experienceName;
    }

    @Override
    @NonNull
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    @Nullable
    public JSONArray getPromotedItemKeys() {
        return this.promotedItemKeys;
    }

    @Override
    @NonNull
    public JSONObject getData() {
        return this.data;
    }

    @Override
    public boolean isControlGroup() {
        return this.isControlGroup;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CampaignImpl)) {
            return false;
        }
        return JSONUtil.jsonObjectsEqual(this.json, ((CampaignImpl)o).json);
    }

    @Override
    public int hashCode() {
        Object[] fieldsToHash = new Object[]{this.contextId, this.campaignId, this.campaignName, this.experienceId, this.experienceName, this.isControlGroup, this.messageContentHash, this.messageId, this.target};
        return Arrays.hashCode(fieldsToHash);
    }

    private CampaignImpl(@NonNull JSONObject campaignJSON, @NonNull JSONObject messageJSON, @NonNull JSONObject dataJSON) throws SafetyUtil.ConstructionException {
        Long ttl;
        String userGroup;
        if (campaignJSON == null) {
            throw new SafetyUtil.ConstructionException(1000, TAG, null, "JSON null");
        }
        this.json = campaignJSON;
        ArrayList<String> missing = new ArrayList<String>();
        String string = JSONUtil.getString(campaignJSON, "campaignName");
        String string2 = this.campaignName = string == null ? "" : string;
        if (!StringUtil.isValid(this.campaignName)) {
            missing.add("campaignName");
        }
        String string3 = this.campaignId = (string = JSONUtil.getString(campaignJSON, "campaignId")) == null ? "" : string;
        if (!StringUtil.isValid(this.campaignId)) {
            missing.add("campaignId");
        }
        Logger.log(3000, TAG, null, "Received [", this.campaignName, ":", this.campaignId, "]");
        string = JSONUtil.getString(campaignJSON, "routingId");
        String string4 = this.contextId = string == null ? "" : string;
        if (!StringUtil.isValid(this.contextId)) {
            missing.add("routingId");
        }
        String string5 = this.experienceId = (string = JSONUtil.getString(campaignJSON, "experienceId")) == null ? "" : string;
        if (!StringUtil.isValid(this.experienceId)) {
            missing.add("experienceId");
        }
        String string6 = this.experienceName = (string = JSONUtil.getString(campaignJSON, "experienceName")) == null ? "" : string;
        if (!StringUtil.isValid(this.experienceName)) {
            missing.add("experienceName");
        }
        if ("Control".equals(userGroup = JSONUtil.getString(campaignJSON, "userGroup"))) {
            this.isControlGroup = true;
        } else {
            if (!"Default".equals(userGroup)) {
                Logger.log(2000, TAG, null, "Ignoring invalid userGroup: ", userGroup);
            }
            this.isControlGroup = false;
        }
        this.test = campaignJSON.has("test");
        string = JSONUtil.getString(messageJSON, "id");
        String string7 = this.messageId = string == null ? "" : string;
        if (!StringUtil.isValid(this.messageId)) {
            missing.add("id");
        }
        this.messageContentHash = JSONUtil.getString(messageJSON, "contentHash");
        string = JSONUtil.getString(messageJSON, "targetName");
        String string8 = this.target = string == null ? "" : string;
        if (!StringUtil.isValid(this.target)) {
            missing.add("targetName");
        }
        if ((ttl = JSONUtil.getLong(messageJSON, "ttl")) == null) {
            ttl = DependencyManager.getConfig().longForKey("campaignTTL");
        }
        this.expirationTime = ttl != null && ttl > 0L ? new Date(System.currentTimeMillis() + ttl * 1000L) : null;
        JSONArray validatedItemKeys = new JSONArray();
        JSONArray promotedItemKeys = JSONUtil.getJSONArray(messageJSON, "promotedItemKeys");
        if (promotedItemKeys != null) {
            for (int i = 0; i < promotedItemKeys.length(); ++i) {
                JSONObject itemKey = JSONUtil.arrayGetJSONObject(promotedItemKeys, i);
                if (itemKey == null) {
                    Logger.log(2000, TAG, null, "Ignoring invalid promoted item, null or not a JSONObject");
                    continue;
                }
                JSONUtil.arrayPut(validatedItemKeys, itemKey, true);
            }
        }
        Object object = this.promotedItemKeys = validatedItemKeys.length() > 0 ? validatedItemKeys : null;
        if (dataJSON == null) {
            missing.add("dataMap");
            this.data = new JSONObject();
        } else {
            this.data = dataJSON;
        }
        if (missing.size() > 0) {
            throw new SafetyUtil.ConstructionException(1000, TAG, null, "JSON missing required elements: " + missing.toString());
        }
    }

    @Nullable
    static CampaignImpl campaignWithJSON(@NonNull JSONObject json) {
        if (json == null || json.length() < 1) {
            Logger.log(1000, TAG, null, "JSON null/empty");
            return null;
        }
        Logger.log(4000, TAG, null, "JSON: ", json.toString());
        JSONArray messages = JSONUtil.getJSONArray(json, "mobileDataMessages");
        if (messages != null && messages.length() > 0) {
            if (messages.length() != 1) {
                Logger.log(1000, TAG, null, String.valueOf(messages.length()), " Data Messages instead of 1");
                return null;
            }
            JSONObject message = JSONUtil.arrayGetJSONObject(messages, 0);
            if (message == null) {
                Logger.log(1000, TAG, null, "Data Message invalid, null or not a JSONObject");
                return null;
            }
            String messageType = JSONUtil.getString(message, "type");
            if (!"evg_md".equals(messageType)) {
                Logger.log(1000, TAG, null, "Data Message unexpected type: ", messageType);
                return null;
            }
            JSONObject data = JSONUtil.getJSONObject(message, "dataMap");
            if (data == null) {
                data = new JSONObject();
            }
            try {
                return new DataCampaign(json, message, data);
            }
            catch (SafetyUtil.ConstructionException e) {
                return null;
            }
        }
        messages = JSONUtil.getJSONArray(json, "mobileUiMessages");
        if (messages != null && messages.length() > 0) {
            if (messages.length() != 1) {
                Logger.log(1000, TAG, null, String.valueOf(messages.length()), " In-App Messages instead of 1");
                return null;
            }
            JSONObject message = JSONUtil.arrayGetJSONObject(messages, 0);
            if (message == null) {
                Logger.log(1000, TAG, null, "In-App Message invalid, null or not a JSONObject");
                return null;
            }
            String messageType = JSONUtil.getString(message, "type");
            if (!"evg_mn".equals(messageType)) {
                Logger.log(1000, TAG, null, "In-App Message unexpected type: ", messageType);
                return null;
            }
            try {
                return new InAppMessageCampaign(json, message);
            }
            catch (SafetyUtil.ConstructionException e) {
                return null;
            }
        }
        Logger.log(2000, TAG, null, "Ignoring, no supported messages found");
        return null;
    }

    @NonNull
    static JSONArray statsForCampaign(@NonNull Campaign campaign, @NonNull String type) {
        JSONArray stats = new JSONArray();
        JSONUtil.arrayPut(stats, CampaignImpl.statForCampaign(campaign, type, true), true);
        JSONUtil.arrayPut(stats, CampaignImpl.statForCampaign(campaign, type, false), true);
        return stats;
    }

    @NonNull
    private static JSONObject statForCampaign(@NonNull Campaign campaign, @NonNull String statType, boolean isExperience) {
        JSONObject statPayload = new JSONObject();
        if (isExperience) {
            JSONUtil.put(statPayload, "id", campaign.getExperienceId());
            JSONUtil.put(statPayload, "type", "e");
        } else {
            JSONUtil.put(statPayload, "id", campaign.getMessageId());
            JSONUtil.put(statPayload, "eid", campaign.getExperienceId());
            JSONUtil.put(statPayload, "type", "m");
        }
        if (campaign.getPromotedItemKeys() != null && campaign.getPromotedItemKeys().length() > 0) {
            JSONUtil.put(statPayload, "piks", campaign.getPromotedItemKeys());
        }
        JSONUtil.put(statPayload, "stat", statType);
        if (campaign.isControlGroup()) {
            JSONUtil.put(statPayload, "ug", "Control");
        }
        return statPayload;
    }

    @NonNull
    public static JSONObject statsFromDeconstructedCampaign(String statType, String experienceId, String promotedItemKeys, boolean isControlGroup) {
        JSONArray piksArray;
        JSONObject statPayload = new JSONObject();
        JSONUtil.put(statPayload, "id", experienceId);
        JSONUtil.put(statPayload, "type", "e");
        if (StringUtil.isValid(promotedItemKeys) && (piksArray = JSONUtil.jsonArrayFromString(promotedItemKeys)) != null && piksArray.length() > 0) {
            JSONUtil.put(statPayload, "piks", piksArray);
        }
        if (isControlGroup) {
            JSONUtil.put(statPayload, "ug", "Control");
        }
        JSONUtil.put(statPayload, "stat", statType);
        return statPayload;
    }

    static class DataCampaign
    extends CampaignImpl {
        DataCampaign(@NonNull JSONObject campaignJSON, @NonNull JSONObject messageJSON, @NonNull JSONObject dataJSON) throws SafetyUtil.ConstructionException {
            super(campaignJSON, messageJSON, dataJSON);
            if (this.getTarget().toLowerCase(Constants.LOCALE_POSIX).startsWith("evg")) {
                throw new SafetyUtil.ConstructionException(2000, CampaignImpl.TAG, null, "Dropping Data Campaign intended for internal target: " + this.getTarget());
            }
        }
    }

    static class InAppMessageCampaign
    extends CampaignImpl {
        InAppMessageCampaign(@NonNull JSONObject campaignJSON, @NonNull JSONObject messageJSON) throws SafetyUtil.ConstructionException {
            super(campaignJSON, messageJSON, messageJSON);
            if (!this.getTarget().toLowerCase(Constants.LOCALE_POSIX).startsWith("evg")) {
                throw new SafetyUtil.ConstructionException(2000, CampaignImpl.TAG, null, "Dropping In-App Message for external target: " + this.getTarget());
            }
            if (!"Global".equals(this.contextId)) {
                throw new SafetyUtil.ConstructionException(2000, CampaignImpl.TAG, null, "Dropping In-App Message for non-global contextId: " + this.contextId);
            }
        }
    }
}

