/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.Campaign;
import com.evergage.android.CampaignHandler;
import com.evergage.android.internal.CampaignImpl;
import com.evergage.android.internal.Config;
import com.evergage.android.internal.DependencyManager;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.SafetyUtil;
import com.evergage.android.internal.util.StringUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

class CampaignDispatcher {
    private static final String TAG = "CampaignDispatcher";
    @NonNull
    private HashMap<String, CampaignDispatchContextIdEntry> dispatchContextIdEntries = new HashMap();
    private Config config;

    CampaignDispatcher() {
        this.updateDependencies();
    }

    void reset() {
        this.updateDependencies();
    }

    private void updateDependencies() {
        this.config = DependencyManager.getConfig();
    }

    @MainThread
    void handleCampaign(@NonNull CampaignImpl campaign) {
        SafetyUtil.assertOnMain();
        if (campaign == null) {
            Logger.log(1000, TAG, null, "Dispatch fail, campaign null");
            return;
        }
        if (!StringUtil.isValid(campaign.contextId) || !StringUtil.isValid(campaign.getTarget())) {
            Logger.log(1000, TAG, null, "Dispatch fail, incomplete, contextId ", campaign.contextId, ", target ", campaign.getTarget(), ", campaign:[", campaign.getCampaignName(), ":", campaign.getCampaignId(), "]");
            return;
        }
        CampaignDispatchContextIdEntry contextIdEntry = this.dispatchContextIdEntries.get(campaign.contextId);
        if (contextIdEntry == null) {
            Logger.log(2000, TAG, null, "Dispatch fail, contextId ", campaign.contextId, " not found (may be late response), campaign: [", campaign.getCampaignName(), ":", campaign.getCampaignId(), "]");
            return;
        }
        CampaignDispatchTargetEntry targetEntry = (CampaignDispatchTargetEntry)contextIdEntry.dispatchTargetEntries.get(campaign.getTarget());
        if (targetEntry == null) {
            targetEntry = new CampaignDispatchTargetEntry();
            contextIdEntry.dispatchTargetEntries.put(campaign.getTarget(), targetEntry);
        }
        if (targetEntry.handler == null || !contextIdEntry.dispatchingAllowed) {
            if (targetEntry.campaignHeld != null) {
                Logger.log(3000, TAG, null, "Replacing existing held campaign: [", campaign.getCampaignName(), ":", campaign.getCampaignId(), "]");
            }
            Logger.log(3000, TAG, null, "Hold for delivery,", targetEntry.handler == null ? " no handler," : "", !contextIdEntry.dispatchingAllowed ? " not yet allowed," : "", " contextId: ", campaign.contextId, ", target: ", campaign.getTarget(), ", campaign: [", campaign.getCampaignName(), ":", campaign.getCampaignId(), "]");
            targetEntry.campaignHeld = campaign;
        } else {
            if (targetEntry.campaignHeld != null) {
                Logger.log(2000, TAG, null, "Unexpectedly found & discarding existing held campaign: [", targetEntry.campaignHeld.getCampaignName(), ":", targetEntry.campaignHeld.getCampaignId(), "]");
                targetEntry.campaignHeld = null;
            }
            this.dispatchCampaignToHandler(campaign, targetEntry.handler);
        }
    }

    @MainThread
    void setHandler(@Nullable CampaignHandler handler, @NonNull String contextId, @NonNull String target) {
        SafetyUtil.assertOnMain();
        if (!StringUtil.isValid(contextId) || !StringUtil.isValid(target)) {
            Logger.log(1000, TAG, null, "Set handler fail, incomplete: target ", target, " contextId ", contextId);
            return;
        }
        CampaignDispatchContextIdEntry contextIdEntry = this.dispatchContextIdEntries.get(contextId);
        if (contextIdEntry == null) {
            Logger.log(1000, TAG, null, "Set handler fail, target ", target, ", contextId ", contextId, " not found");
            return;
        }
        CampaignDispatchTargetEntry targetEntry = (CampaignDispatchTargetEntry)contextIdEntry.dispatchTargetEntries.get(target);
        if (targetEntry == null) {
            targetEntry = new CampaignDispatchTargetEntry();
            contextIdEntry.dispatchTargetEntries.put(target, targetEntry);
        }
        boolean hadExistingHandler = targetEntry.handler != null;
        targetEntry.handler = handler;
        if (handler == null) {
            if (hadExistingHandler) {
                Logger.log(3000, TAG, null, "Cleared handler for target ", target, ", contextId ", contextId);
            }
            return;
        }
        Logger.log(3000, TAG, null, hadExistingHandler ? "Replaced" : "Set", " handler for target ", target, ", contextId ", contextId);
        CampaignImpl campaignHeld = targetEntry.campaignHeld;
        if (campaignHeld == null) {
            return;
        }
        if (!contextIdEntry.dispatchingAllowed) {
            Logger.log(3000, TAG, null, "Ignoring campaign held for handler, dispatching not yet allowed for contextId ", contextId, ", campaign: [", campaignHeld.getCampaignName(), ":", campaignHeld.getCampaignId(), "]");
        } else {
            Logger.log(3000, TAG, null, "Dispatch campaign held for handler");
            targetEntry.campaignHeld = null;
            this.dispatchCampaignToHandler(campaignHeld, handler);
        }
    }

    @MainThread
    void registerContextIdIfNecessary(@NonNull String contextId) {
        SafetyUtil.assertOnMain();
        if (contextId == null) {
            Logger.log(1000, TAG, null, "Register contextId fail, null");
            return;
        }
        CampaignDispatchContextIdEntry contextIdEntry = this.dispatchContextIdEntries.get(contextId);
        if (contextIdEntry == null) {
            Logger.log(4000, TAG, null, "Register contextId ", contextId);
            contextIdEntry = new CampaignDispatchContextIdEntry();
            this.dispatchContextIdEntries.put(contextId, contextIdEntry);
        }
    }

    @MainThread
    void unregisterContextId(@NonNull String contextId) {
        SafetyUtil.assertOnMain();
        if (contextId == null) {
            Logger.log(1000, TAG, null, "Unregister contextId fail, null");
            return;
        }
        CampaignDispatchContextIdEntry contextIdEntry = this.dispatchContextIdEntries.get(contextId);
        if (contextIdEntry == null) {
            return;
        }
        Logger.log(4000, TAG, null, "Unregister contextId ", contextId);
        this.clearContextId(contextId);
        this.dispatchContextIdEntries.remove(contextId);
    }

    private void clearContextId(@NonNull String contextId) {
        if (contextId == null) {
            Logger.log(1000, TAG, null, "Clear contextId fail, null");
            return;
        }
        CampaignDispatchContextIdEntry contextIdEntry = this.dispatchContextIdEntries.get(contextId);
        if (contextIdEntry == null) {
            Logger.log(2000, TAG, null, "Clear contextId ", contextId, " fail, not found");
            return;
        }
        int targetCount = contextIdEntry.dispatchTargetEntries.size();
        int handlerCount = 0;
        int campaignsHeldCount = 0;
        for (CampaignDispatchTargetEntry targetEntry : contextIdEntry.dispatchTargetEntries.values()) {
            if (targetEntry.handler != null) {
                ++handlerCount;
            }
            if (targetEntry.campaignHeld == null) continue;
            ++campaignsHeldCount;
        }
        Logger.log(4000, TAG, null, "Clear contextId ", contextId, ", ", String.valueOf(targetCount), " targets ", String.valueOf(handlerCount), " handlers ", String.valueOf(campaignsHeldCount), " campaigns held");
        contextIdEntry.dispatchTargetEntries.clear();
    }

    @MainThread
    void clearAllCampaignsHeld() {
        SafetyUtil.assertOnMain();
        for (String contextId : this.dispatchContextIdEntries.keySet()) {
            this.clearAllCampaignsHeldForContextId(contextId);
        }
    }

    private void clearAllCampaignsHeldForContextId(@NonNull String contextId) {
        CampaignDispatchContextIdEntry contextIdEntry = this.dispatchContextIdEntries.get(contextId);
        if (contextIdEntry == null) {
            return;
        }
        int campaignsHeldCount = 0;
        for (CampaignDispatchTargetEntry targetEntry : contextIdEntry.dispatchTargetEntries.values()) {
            if (targetEntry.campaignHeld == null) continue;
            ++campaignsHeldCount;
            targetEntry.campaignHeld = null;
        }
        if (campaignsHeldCount > 0) {
            Logger.log(4000, TAG, null, "Clear ", String.valueOf(campaignsHeldCount), " campaigns held, contextId ", contextId);
        }
    }

    @MainThread
    void setDispatchingAllowed(boolean dispatchingAllowed, @NonNull String contextId) {
        String allowOrDisallow;
        SafetyUtil.assertOnMain();
        String string = allowOrDisallow = dispatchingAllowed ? "Allow" : "Disallow";
        if (contextId == null) {
            Logger.log(1000, TAG, null, allowOrDisallow, " dispatching fail, contextId null");
            return;
        }
        CampaignDispatchContextIdEntry contextIdEntry = this.dispatchContextIdEntries.get(contextId);
        if (contextIdEntry == null) {
            Logger.log(4000, TAG, null, allowOrDisallow, " dispatching fail, did not find contextId ", contextId);
            return;
        }
        if (!dispatchingAllowed) {
            if (contextIdEntry.dispatchingAllowed) {
                Logger.log(4000, TAG, null, "Disallow dispatching, contextId ", contextId);
                contextIdEntry.dispatchingAllowed = false;
            }
        } else if (!contextIdEntry.dispatchingAllowed) {
            Logger.log(4000, TAG, null, "Allow dispatching, contextId ", contextId);
            contextIdEntry.dispatchingAllowed = true;
            for (CampaignDispatchTargetEntry targetEntry : contextIdEntry.dispatchTargetEntries.values()) {
                CampaignImpl campaignHeld = targetEntry.campaignHeld;
                if (campaignHeld == null) continue;
                if (targetEntry.handler == null) {
                    Logger.log(3000, TAG, null, "Campaign still held for handler, target ", campaignHeld.getTarget(), ", campaign: [", campaignHeld.getCampaignName(), ":", campaignHeld.getCampaignId(), "]");
                    continue;
                }
                targetEntry.campaignHeld = null;
                this.dispatchCampaignToHandler(campaignHeld, targetEntry.handler);
            }
        }
    }

    @MainThread
    void unregisterAll() {
        SafetyUtil.assertOnMain();
        if (this.dispatchContextIdEntries.size() > 0) {
            Logger.log(4000, TAG, null, "Unregister all");
        }
        this.dispatchContextIdEntries.clear();
    }

    private void dispatchCampaignToHandler(final @NonNull CampaignImpl campaign, final @NonNull CampaignHandler handler) {
        if (campaign == null) {
            Logger.log(1000, TAG, null, "Dispatch fail, campaign null");
        } else if (handler == null) {
            Logger.log(1000, TAG, null, "Dispatch fail, no handler, contextId ", campaign.contextId, ", target ", campaign.getTarget(), ", campaign: [", campaign.getCampaignName(), ":", campaign.getCampaignId(), "]");
        } else if (campaign.expirationTime != null && campaign.expirationTime.before(new Date())) {
            Logger.log(3000, TAG, null, "Dispatch fail, campaign expired ", String.valueOf(System.currentTimeMillis() - campaign.expirationTime.getTime()), " ms ago, campaign: [", campaign.getCampaignName(), ":", campaign.getCampaignId(), "]");
        } else {
            Logger.log(3000, TAG, null, "Dispatching to handler, contextId ", campaign.contextId, ", target ", campaign.getTarget(), ", campaign: [", campaign.getCampaignName(), ":", campaign.getCampaignId(), "]");
            Boolean callSafely = this.config.boolForKey("callHandlersSafely");
            if (callSafely != null && callSafely.booleanValue()) {
                SafetyUtil.runOnMain(new SafetyUtil.SafeRunnable(){

                    @Override
                    public void runImpl() {
                        this.exceptionLogMessage = "Exception in campaign handler for target [" + campaign.getTarget() + "] campaignId [" + campaign.getCampaignId() + "] experienceId [" + campaign.getExperienceId() + "] messageId [" + campaign.getMessageId() + "] data: " + campaign.getData();
                        handler.handleCampaign(campaign);
                    }
                });
            } else {
                SafetyUtil.runOnMainUNSAFE(new Runnable(){

                    @Override
                    public void run() {
                        handler.handleCampaign(campaign);
                    }
                });
            }
        }
    }

    @MainThread
    private boolean dispatchAllowedForContextId(@NonNull String contextId) {
        SafetyUtil.assertOnMain();
        CampaignDispatchContextIdEntry contextIdEntry = this.dispatchContextIdEntries.get(contextId);
        return contextIdEntry != null && contextIdEntry.dispatchingAllowed;
    }

    @MainThread
    @Nullable
    private CampaignHandler handlerForContextId(@NonNull String contextId, @NonNull String target) {
        SafetyUtil.assertOnMain();
        CampaignDispatchContextIdEntry contextIdEntry = this.dispatchContextIdEntries.get(contextId);
        if (contextIdEntry == null) {
            return null;
        }
        CampaignDispatchTargetEntry targetEntry = (CampaignDispatchTargetEntry)contextIdEntry.dispatchTargetEntries.get(target);
        if (targetEntry == null) {
            return null;
        }
        return targetEntry.handler;
    }

    @MainThread
    @Nullable
    private Campaign campaignHeldForContextId(@NonNull String contextId, @NonNull String target) {
        SafetyUtil.assertOnMain();
        CampaignDispatchContextIdEntry contextIdEntry = this.dispatchContextIdEntries.get(contextId);
        if (contextIdEntry == null) {
            return null;
        }
        CampaignDispatchTargetEntry targetEntry = (CampaignDispatchTargetEntry)contextIdEntry.dispatchTargetEntries.get(target);
        if (targetEntry == null) {
            return null;
        }
        return targetEntry.campaignHeld;
    }

    private class CampaignDispatchContextIdEntry {
        private boolean dispatchingAllowed = false;
        @NonNull
        private Map<String, CampaignDispatchTargetEntry> dispatchTargetEntries = new HashMap<String, CampaignDispatchTargetEntry>();

        CampaignDispatchContextIdEntry() {
        }
    }

    private class CampaignDispatchTargetEntry {
        @Nullable
        private CampaignImpl campaignHeld;
        @Nullable
        private CampaignHandler handler;

        private CampaignDispatchTargetEntry() {
        }
    }
}

