/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import com.evergage.android.internal.Config;
import com.evergage.android.internal.DependencyManager;
import com.evergage.android.internal.ScreenImpl;
import com.evergage.android.internal.UIManager;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.SafetyUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;

class AppLifecycleManager
implements Application.ActivityLifecycleCallbacks,
ComponentCallbacks2 {
    private static final String TAG = "AppLifecycleManager";
    private long bgThresholdMillis;
    private boolean useTrim;
    private Application application;
    private Config config;
    private DependencyManager.LazyNonNull<UIManager> lazyUIManager;
    volatile WeakReference<Callback> weakCallback;
    private volatile WeakReference<Runnable> postCallbackHook;
    @NonNull
    private volatile String state = "background";
    private int activityAliveCount;
    private int activityVisibleCount;
    private int activityActiveCount;
    private boolean confirmedBg;
    private boolean trimmed;
    private boolean changingConfig;
    private SafetyUtil.WeakSafeRunnable bgRunWeak;
    private final SafetyUtil.SafeRunnable bgRunStrong = new SafetyUtil.SafeRunnable(){

        @Override
        public void runImpl() {
            AppLifecycleManager.this.confirmBg("timer");
        }
    };

    AppLifecycleManager() {
        this.reset();
    }

    void reset() {
        this.weakCallback = null;
        Application oldApplication = this.application;
        this.application = DependencyManager.getApplication();
        this.config = DependencyManager.getConfig();
        this.lazyUIManager = new DependencyManager.LazyNonNull<UIManager>(){

            @Override
            @NonNull
            protected UIManager provideOnce() {
                return DependencyManager.getUiManager();
            }
        };
        this.updateConfig();
        if (oldApplication != this.application) {
            if (oldApplication != null) {
                SafetyUtil.assertFail(Integer.MAX_VALUE, "Application changed", null, false);
                oldApplication.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            }
            if (this.application != null) {
                this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
                this.application.registerComponentCallbacks((ComponentCallbacks)this);
            }
        }
    }

    void updateConfig() {
        if (this.config == null) {
            return;
        }
        Object value = this.config.objectForKey(Number.class, "appStateThreshold", false);
        this.bgThresholdMillis = value == null ? 300L : (long)(((Number)value).doubleValue() * 1000.0);
        value = this.config.objectForKey(Boolean.class, "appStateUseTrim", false);
        this.useTrim = value == null ? true : (Boolean)value;
    }

    @NonNull
    String getAppState() {
        return this.state;
    }

    @MainThread
    private void recalculateState() {
        SafetyUtil.assertOnMain();
        String newState = this.activityActiveCount > 0 ? "active" : (this.activityVisibleCount > 0 ? "inactive" : (this.confirmedBg ? "background" : "inactive"));
        if (!newState.equals(this.state)) {
            Runnable hook;
            Callback strongCallback;
            String oldState = this.state;
            this.state = newState;
            Logger.log(4000, TAG, null, "App state ", newState);
            if (this.weakCallback != null && (strongCallback = (Callback)this.weakCallback.get()) != null) {
                strongCallback.onAppStateChange(newState, oldState);
            }
            if (this.postCallbackHook != null && (hook = (Runnable)this.postCallbackHook.get()) != null) {
                hook.run();
            }
        }
    }

    private void confirmBg(@NonNull String source) {
        this.bgTimerCancel();
        if (this.confirmedBg) {
            return;
        }
        if (this.activityVisibleCount != 0) {
            Logger.log(2000, TAG, null, "Could not confirm bg, count != 0, source: ", source);
            return;
        }
        this.confirmedBg = true;
        Logger.log(4000, TAG, null, "Confirm bg, source: ", source);
        this.recalculateState();
    }

    private void bgTimerCancel() {
        SafetyUtil.sMainHandler.removeCallbacks((Runnable)this.bgRunWeak);
        this.bgRunWeak = null;
    }

    private void bgTimerRestart() {
        SafetyUtil.sMainHandler.removeCallbacks((Runnable)this.bgRunWeak);
        if (this.bgThresholdMillis <= 0L) {
            this.bgRunStrong.run();
        } else {
            this.bgRunWeak = new SafetyUtil.WeakSafeRunnable(this.bgRunStrong);
            SafetyUtil.runAfterDelay(this.bgThresholdMillis, SafetyUtil.sMainHandler, this.bgRunWeak);
        }
    }

    private void logCounters() {
        Logger.log(4000, TAG, null, "Activities: ", Integer.toString(this.activityAliveCount), "/", Integer.toString(this.activityVisibleCount), "/", Integer.toString(this.activityActiveCount));
    }

    private void trackNotificationIfApplicable(Intent intent) {
        DependencyManager.getGlobalContext().trackClickthrough(intent);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        ++this.activityAliveCount;
        this.logCounters();
        ScreenImpl.onCreateActivity(activity);
    }

    public void onActivityStarted(Activity activity) {
        this.trimmed = false;
        this.bgTimerCancel();
        this.confirmedBg = false;
        this.changingConfig = false;
        ++this.activityVisibleCount;
        this.logCounters();
        ScreenImpl.onStartActivity(activity);
        this.recalculateState();
    }

    public void onActivityResumed(Activity activity) {
        ++this.activityActiveCount;
        this.logCounters();
        ScreenImpl.onResumeActivity(activity);
        this.recalculateState();
        this.trackNotificationIfApplicable(activity.getIntent());
    }

    public void onActivityPaused(Activity activity) {
        --this.activityActiveCount;
        this.logCounters();
        ScreenImpl.onPauseActivity(activity);
        this.recalculateState();
    }

    public void onActivityStopped(Activity activity) {
        if (activity.isChangingConfigurations()) {
            this.changingConfig = true;
            Logger.log(4000, TAG, null, "Activity changing config");
        }
        --this.activityVisibleCount;
        this.logCounters();
        ScreenImpl.onStopActivity(activity);
        if (this.activityVisibleCount == 0) {
            if (this.trimmed && !this.changingConfig) {
                this.confirmBg("stop-after-trim");
            } else {
                this.bgTimerRestart();
            }
        }
        this.recalculateState();
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        --this.activityAliveCount;
        this.logCounters();
        ScreenImpl.onDestroyActivity(activity);
        this.lazyUIManager.get().onDestroyActivity(activity);
    }

    public void onTrimMemory(int level) {
        if (!this.useTrim) {
            return;
        }
        if (level >= 20) {
            this.trimmed = true;
            Logger.log(4000, TAG, null, "Trim UI");
            if (this.activityVisibleCount == 0 && !this.changingConfig) {
                this.confirmBg("trim-after-stop");
            }
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onLowMemory() {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AppState {
        public static final String ACTIVE = "active";
        public static final String INACTIVE = "inactive";
        public static final String BACKGROUND = "background";
    }

    static interface Callback {
        @MainThread
        public void onAppStateChange(@NonNull String var1, @NonNull String var2);
    }
}

