/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.DependencyManager;
import com.evergage.android.internal.util.Logger;

class Alert {
    private static final String TAG = "Alert";
    @Nullable
    private Toast toast;

    @SuppressLint(value={"ShowToast"})
    Alert(@NonNull String title, @NonNull String message) {
        Context appContext = DependencyManager.getAppContext();
        if (appContext == null) {
            this.toast = null;
            return;
        }
        String text = title + "\n" + message;
        this.toast = Toast.makeText((Context)appContext, (CharSequence)text, (int)1);
        this.toast.setGravity(17, 0, 0);
        if (this.toast.getView() == null) {
            return;
        }
        TextView textView = (TextView)this.toast.getView().findViewById(16908299);
        if (textView == null) {
            return;
        }
        textView.setGravity(17);
    }

    void showView() {
        if (this.toast == null) {
            return;
        }
        Logger.log(3000, TAG, null, "Showing view");
        this.toast.show();
    }

    void removeView() {
        if (this.toast == null) {
            return;
        }
        Logger.log(3000, TAG, null, "Removing view");
        this.toast.cancel();
        this.toast = null;
    }
}

