/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.ClientConfiguration;
import com.evergage.android.Context;
import com.evergage.android.Screen;
import com.evergage.android.internal.DependencyManager;
import com.evergage.android.internal.util.Logger;

public abstract class Evergage {
    protected static final String TAG = Evergage.class.getSimpleName();

    @MainThread
    public static void initialize(@NonNull Application application) {
        DependencyManager.initialize(application);
    }

    @NonNull
    public static Evergage getInstance() {
        return DependencyManager.getEvergage();
    }

    public abstract void start(@NonNull ClientConfiguration var1);

    public abstract void start(@NonNull String var1, @NonNull String var2);

    public abstract void reset();

    @Nullable
    public abstract String getUserId();

    public abstract void setUserId(@Nullable String var1);

    @Nullable
    public abstract String getAnonymousId();

    public abstract void setUserAttribute(@NonNull String var1, @Nullable String var2);

    @Nullable
    public abstract String getAccountId();

    public abstract void setAccountId(@Nullable String var1);

    public abstract void setAccountAttribute(@NonNull String var1, @Nullable String var2);

    public abstract void setFirebaseToken(String var1);

    @MainThread
    @Nullable
    public abstract Screen getScreenForActivity(@NonNull Activity var1);

    @Nullable
    public abstract Context getGlobalContext();

    public abstract boolean processIntent(@NonNull Intent var1);

    public static void setLogLevel(int logLevel) {
        Logger.setLogThreshold(logLevel);
    }
}

