/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.StridedIndexTypeCollection;
import java.util.ArrayList;

class QuadTreeImpl {
    private int m_root;
    private Envelope2D m_extent;
    private int m_height;
    private StridedIndexTypeCollection m_quad_tree_nodes = new StridedIndexTypeCollection(11);
    private StridedIndexTypeCollection m_element_nodes = new StridedIndexTypeCollection(5);
    private ArrayList<Envelope2D> m_boxes = new ArrayList(0);
    private AttributeStreamOfInt32 m_free_boxes = new AttributeStreamOfInt32(0);

    QuadTreeImpl(Envelope2D extent, int height) {
        this.m_extent = new Envelope2D();
        this.reset_(extent, height);
    }

    void reset(Envelope2D extent, int height) {
        this.m_quad_tree_nodes.deleteAll(false);
        this.m_element_nodes.deleteAll(false);
        this.m_boxes.clear();
        this.m_free_boxes.clear(false);
        this.reset_(extent, height);
    }

    int insert(int element, Envelope2D bounding_box) {
        return this.insert_(element, bounding_box, 0, this.m_extent, this.m_root, false, -1);
    }

    int insert(int element, Envelope2D bounding_box, int hint_index) {
        int quad_handle = hint_index == -1 ? this.m_root : this.getQuad_(hint_index);
        int quad_height = this.getHeight(quad_handle);
        Envelope2D quad_extent = this.getExtent(quad_handle);
        return this.insert_(element, bounding_box, quad_height, quad_extent, quad_handle, false, -1);
    }

    void removeElement(int element_handle) {
        int quad_handle = this.getQuad_(element_handle);
        int nextElementHandle = this.disconnectElementHandle_(element_handle);
        this.freeElementAndBoxNode_(element_handle);
        int q = quad_handle;
        while (q != -1) {
            this.setSubTreeElementCount_(q, this.getSubTreeElementCount_(q) - 1);
            assert (this.getSubTreeElementCount_(q) >= 0);
            q = this.getParent_(q);
        }
    }

    int getElement(int element_handle) {
        return this.getElement_(element_handle);
    }

    int getHeight(int quad_handle) {
        return this.getHeight_(quad_handle);
    }

    Envelope2D getExtent(int quad_handle) {
        Envelope2D quad_extent = new Envelope2D();
        quad_extent.setCoords(this.m_extent);
        int height = this.getHeight_(quad_handle);
        int morten_number = this.getMortenNumber_(quad_handle);
        int mask = 3;
        for (int i = 0; i < 2 * height; i += 2) {
            int child = mask & morten_number >> i;
            if (child == 0) {
                quad_extent.xmin = 0.5 * (quad_extent.xmin + quad_extent.xmax);
                quad_extent.ymin = 0.5 * (quad_extent.ymin + quad_extent.ymax);
                continue;
            }
            if (child == 1) {
                quad_extent.xmax = 0.5 * (quad_extent.xmin + quad_extent.xmax);
                quad_extent.ymin = 0.5 * (quad_extent.ymin + quad_extent.ymax);
                continue;
            }
            if (child == 2) {
                quad_extent.xmax = 0.5 * (quad_extent.xmin + quad_extent.xmax);
                quad_extent.ymax = 0.5 * (quad_extent.ymin + quad_extent.ymax);
                continue;
            }
            quad_extent.xmin = 0.5 * (quad_extent.xmin + quad_extent.xmax);
            quad_extent.ymax = 0.5 * (quad_extent.ymin + quad_extent.ymax);
        }
        return quad_extent;
    }

    int getQuad(int element_handle) {
        return this.getQuad_(element_handle);
    }

    int getElementCount() {
        return this.getSubTreeElementCount_(this.m_root);
    }

    int getSubTreeElementCount(int quad_handle) {
        return this.getSubTreeElementCount_(quad_handle);
    }

    QuadTreeIteratorImpl getIterator(Geometry query, double tolerance) {
        return new QuadTreeIteratorImpl(this, query, tolerance);
    }

    QuadTreeIteratorImpl getIterator(Envelope2D query, double tolerance) {
        return new QuadTreeIteratorImpl(this, query, tolerance);
    }

    QuadTreeIteratorImpl getIterator() {
        return new QuadTreeIteratorImpl(this);
    }

    private void reset_(Envelope2D extent, int height) {
        if (height < 0 || 2 * height > 32) {
            throw new IllegalArgumentException("invalid height");
        }
        this.m_height = height;
        this.m_extent.setCoords(extent);
        this.m_root = this.m_quad_tree_nodes.newElement();
        this.setSubTreeElementCount_(this.m_root, 0);
        this.setLocalElementCount_(this.m_root, 0);
        this.setMortenNumber_(this.m_root, 0);
        this.setHeight_(this.m_root, 0);
    }

    private int insert_(int element, Envelope2D bounding_box, int height, Envelope2D quad_extent, int quad_handle, boolean b_flushing, int flushed_element_handle) {
        int current_height;
        if (!quad_extent.contains(bounding_box)) {
            assert (!b_flushing);
            if (height == 0) {
                return -1;
            }
            return this.insert_(element, bounding_box, 0, this.m_extent, this.m_root, b_flushing, flushed_element_handle);
        }
        if (!b_flushing) {
            int q = quad_handle;
            while (q != -1) {
                this.setSubTreeElementCount_(q, this.getSubTreeElementCount_(q) + 1);
                q = this.getParent_(q);
            }
        }
        Envelope2D current_extent = new Envelope2D();
        current_extent.setCoords(quad_extent);
        int current_quad_handle = quad_handle;
        Envelope2D[] child_extents = new Envelope2D[]{new Envelope2D(), new Envelope2D(), new Envelope2D(), new Envelope2D()};
        for (current_height = height; current_height < this.m_height && this.canPushDown_(current_quad_handle); ++current_height) {
            QuadTreeImpl.setChildExtents_(current_extent, child_extents);
            boolean b_contains = false;
            for (int i = 0; i < 4; ++i) {
                if (!child_extents[i].contains(bounding_box)) continue;
                b_contains = true;
                int child_handle = this.getChild_(current_quad_handle, i);
                if (child_handle == -1) {
                    child_handle = this.createChild_(current_quad_handle, i);
                }
                this.setSubTreeElementCount_(child_handle, this.getSubTreeElementCount_(child_handle) + 1);
                current_quad_handle = child_handle;
                current_extent.setCoords(child_extents[i]);
                break;
            }
            if (!b_contains) break;
        }
        return this.insertAtQuad_(element, bounding_box, current_height, current_extent, current_quad_handle, b_flushing, quad_handle, flushed_element_handle);
    }

    private int insertAtQuad_(int element, Envelope2D bounding_box, int current_height, Envelope2D current_extent, int current_quad_handle, boolean b_flushing, int quad_handle, int flushed_element_handle) {
        int head_element_handle = this.getFirstElement_(current_quad_handle);
        int tail_element_handle = this.getLastElement_(current_quad_handle);
        int element_handle = -1;
        if (b_flushing) {
            assert (flushed_element_handle != -1);
            if (current_quad_handle == quad_handle) {
                return flushed_element_handle;
            }
            this.disconnectElementHandle_(flushed_element_handle);
            element_handle = flushed_element_handle;
        } else {
            element_handle = this.createElementAndBoxNode_();
            this.setElement_(element_handle, element);
            this.setBoundingBox_(this.getBoxHandle_(element_handle), bounding_box);
        }
        assert (!b_flushing || element_handle == flushed_element_handle);
        this.setQuad_(element_handle, current_quad_handle);
        if (tail_element_handle != -1) {
            this.setPrevElement_(element_handle, tail_element_handle);
            this.setNextElement_(tail_element_handle, element_handle);
        } else {
            assert (head_element_handle == -1);
            this.setFirstElement_(current_quad_handle, element_handle);
        }
        this.setLastElement_(current_quad_handle, element_handle);
        this.setLocalElementCount_(current_quad_handle, this.getLocalElementCount_(current_quad_handle) + 1);
        if (this.canFlush_(current_quad_handle)) {
            this.flush_(current_height, current_extent, current_quad_handle);
        }
        return element_handle;
    }

    private int disconnectElementHandle_(int element_handle) {
        assert (element_handle != -1);
        int quad_handle = this.getQuad_(element_handle);
        int head_element_handle = this.getFirstElement_(quad_handle);
        int tail_element_handle = this.getLastElement_(quad_handle);
        int prev_element_handle = this.getPrevElement_(element_handle);
        int next_element_handle = this.getNextElement_(element_handle);
        assert (head_element_handle != -1 && tail_element_handle != -1);
        if (head_element_handle == element_handle) {
            if (next_element_handle != -1) {
                this.setPrevElement_(next_element_handle, -1);
            } else {
                assert (head_element_handle == tail_element_handle);
                assert (this.getLocalElementCount_(quad_handle) == 1);
                this.setLastElement_(quad_handle, -1);
            }
            this.setFirstElement_(quad_handle, next_element_handle);
        } else if (tail_element_handle == element_handle) {
            assert (prev_element_handle != -1);
            assert (this.getLocalElementCount_(quad_handle) >= 2);
            this.setNextElement_(prev_element_handle, -1);
            this.setLastElement_(quad_handle, prev_element_handle);
        } else {
            assert (next_element_handle != -1 && prev_element_handle != -1);
            assert (this.getLocalElementCount_(quad_handle) >= 3);
            this.setPrevElement_(next_element_handle, prev_element_handle);
            this.setNextElement_(prev_element_handle, next_element_handle);
        }
        this.setPrevElement_(element_handle, -1);
        this.setNextElement_(element_handle, -1);
        this.setLocalElementCount_(quad_handle, this.getLocalElementCount_(quad_handle) - 1);
        assert (this.getLocalElementCount_(quad_handle) >= 0);
        return next_element_handle;
    }

    private static void setChildExtents_(Envelope2D current_extent, Envelope2D[] child_extents) {
        double x_mid = 0.5 * (current_extent.xmin + current_extent.xmax);
        double y_mid = 0.5 * (current_extent.ymin + current_extent.ymax);
        child_extents[0].setCoords(x_mid, y_mid, current_extent.xmax, current_extent.ymax);
        child_extents[1].setCoords(current_extent.xmin, y_mid, x_mid, current_extent.ymax);
        child_extents[2].setCoords(current_extent.xmin, current_extent.ymin, x_mid, y_mid);
        child_extents[3].setCoords(x_mid, current_extent.ymin, current_extent.xmax, y_mid);
    }

    private boolean canFlush_(int quad_handle) {
        return this.getLocalElementCount_(quad_handle) == 8 && !this.hasChildren_(quad_handle);
    }

    private void flush_(int height, Envelope2D extent, int quad_handle) {
        int next_handle;
        assert (quad_handle != -1);
        int element_handle = this.getFirstElement_(quad_handle);
        assert (element_handle != -1);
        do {
            int box_handle = this.getBoxHandle_(element_handle);
            int element = this.m_element_nodes.getField(element_handle, 0);
            Envelope2D bounding_box = this.getBoundingBox_(box_handle);
            this.insert_(element, bounding_box, height, extent, quad_handle, true, element_handle);
        } while ((element_handle = (next_handle = this.getNextElement_(element_handle))) != -1);
    }

    boolean canPushDown_(int quad_handle) {
        return this.getLocalElementCount_(quad_handle) >= 8 || this.hasChildren_(quad_handle);
    }

    boolean hasChildren_(int parent) {
        return this.getChild_(parent, 0) != -1 || this.getChild_(parent, 1) != -1 || this.getChild_(parent, 2) != -1 || this.getChild_(parent, 3) != -1;
    }

    private int createChild_(int parent, int quadrant) {
        int child = this.m_quad_tree_nodes.newElement();
        this.setChild_(parent, quadrant, child);
        this.setSubTreeElementCount_(child, 0);
        this.setLocalElementCount_(child, 0);
        this.setParent_(child, parent);
        this.setHeight_(child, this.getHeight_(parent) + 1);
        this.setMortenNumber_(child, quadrant << 2 * this.getHeight_(parent) | this.getMortenNumber_(parent));
        return child;
    }

    private int createElementAndBoxNode_() {
        int box_handle;
        int element_handle = this.m_element_nodes.newElement();
        if (this.m_free_boxes.size() > 0) {
            box_handle = this.m_free_boxes.getLast();
            this.m_free_boxes.removeLast();
        } else {
            box_handle = this.m_boxes.size();
            this.m_boxes.add(new Envelope2D());
        }
        this.setBoxHandle_(element_handle, box_handle);
        return element_handle;
    }

    private void freeElementAndBoxNode_(int element_handle) {
        this.m_free_boxes.add(this.getBoxHandle_(element_handle));
        this.m_element_nodes.deleteElement(element_handle);
    }

    private int getChild_(int quad_handle, int quadrant) {
        return this.m_quad_tree_nodes.getField(quad_handle, quadrant);
    }

    private void setChild_(int parent, int quadrant, int child) {
        this.m_quad_tree_nodes.setField(parent, quadrant, child);
    }

    private int getFirstElement_(int quad_handle) {
        return this.m_quad_tree_nodes.getField(quad_handle, 4);
    }

    private void setFirstElement_(int quad_handle, int head) {
        this.m_quad_tree_nodes.setField(quad_handle, 4, head);
    }

    private int getLastElement_(int quad_handle) {
        return this.m_quad_tree_nodes.getField(quad_handle, 5);
    }

    private void setLastElement_(int quad_handle, int tail) {
        this.m_quad_tree_nodes.setField(quad_handle, 5, tail);
    }

    private int getMortenNumber_(int quad_handle) {
        return this.m_quad_tree_nodes.getField(quad_handle, 6);
    }

    private void setMortenNumber_(int quad_handle, int morten_number) {
        this.m_quad_tree_nodes.setField(quad_handle, 6, morten_number);
    }

    private int getLocalElementCount_(int quad_handle) {
        return this.m_quad_tree_nodes.getField(quad_handle, 7);
    }

    private int getSubTreeElementCount_(int quad_handle) {
        return this.m_quad_tree_nodes.getField(quad_handle, 8);
    }

    private void setLocalElementCount_(int quad_handle, int count) {
        this.m_quad_tree_nodes.setField(quad_handle, 7, count);
    }

    private void setSubTreeElementCount_(int quad_handle, int count) {
        this.m_quad_tree_nodes.setField(quad_handle, 8, count);
    }

    private int getParent_(int child) {
        return this.m_quad_tree_nodes.getField(child, 9);
    }

    private void setParent_(int child, int parent) {
        this.m_quad_tree_nodes.setField(child, 9, parent);
    }

    private int getHeight_(int quad_handle) {
        return this.m_quad_tree_nodes.getField(quad_handle, 10);
    }

    private void setHeight_(int quad_handle, int height) {
        this.m_quad_tree_nodes.setField(quad_handle, 10, height);
    }

    private int getElement_(int element_handle) {
        return this.m_element_nodes.getField(element_handle, 0);
    }

    private void setElement_(int element_handle, int element) {
        this.m_element_nodes.setField(element_handle, 0, element);
    }

    private int getPrevElement_(int element_handle) {
        return this.m_element_nodes.getField(element_handle, 1);
    }

    private int getNextElement_(int element_handle) {
        return this.m_element_nodes.getField(element_handle, 2);
    }

    private void setPrevElement_(int element_handle, int prev_handle) {
        this.m_element_nodes.setField(element_handle, 1, prev_handle);
    }

    private void setNextElement_(int element_handle, int next_handle) {
        this.m_element_nodes.setField(element_handle, 2, next_handle);
    }

    private int getQuad_(int element_handle) {
        return this.m_element_nodes.getField(element_handle, 3);
    }

    private void setQuad_(int element_handle, int parent) {
        this.m_element_nodes.setField(element_handle, 3, parent);
    }

    private int getBoxHandle_(int element_handle) {
        return this.m_element_nodes.getField(element_handle, 4);
    }

    private void setBoxHandle_(int element_handle, int box_handle) {
        this.m_element_nodes.setField(element_handle, 4, box_handle);
    }

    private Envelope2D getBoundingBox_(int box_handle) {
        return this.m_boxes.get(box_handle);
    }

    private void setBoundingBox_(int box_handle, Envelope2D bounding_box) {
        this.m_boxes.get(box_handle).setCoords(bounding_box);
    }

    static final class QuadTreeIteratorImpl {
        private boolean m_b_linear;
        private Point2D m_query_start;
        private Point2D m_query_end;
        private Envelope2D m_query_box;
        private double m_tolerance;
        private int m_current_element_handle;
        private int m_next_element_handle;
        private QuadTreeImpl m_quad_tree;
        private AttributeStreamOfInt32 m_quads_stack;
        private ArrayList<Envelope2D> m_extents_stack;

        void resetIterator(Geometry query, double tolerance) {
            this.m_quads_stack.resize(0);
            this.m_extents_stack.clear();
            this.m_current_element_handle = -1;
            query.queryLooseEnvelope2D(this.m_query_box);
            this.m_query_box.inflate(tolerance, tolerance);
            if (this.m_query_box.isIntersecting(this.m_quad_tree.m_extent)) {
                int type = query.getType().value();
                this.m_b_linear = Geometry.isSegment(type);
                if (this.m_b_linear) {
                    Segment segment = (Segment)query;
                    this.m_query_start = segment.getStartXY();
                    this.m_query_end = segment.getEndXY();
                    this.m_tolerance = tolerance;
                } else {
                    this.m_tolerance = NumberUtils.NaN();
                }
                this.m_quads_stack.add(this.m_quad_tree.m_root);
                this.m_extents_stack.add(this.m_quad_tree.m_extent);
                this.m_next_element_handle = this.m_quad_tree.getFirstElement_(this.m_quad_tree.m_root);
            } else {
                this.m_next_element_handle = -1;
            }
        }

        void resetIterator(Envelope2D query, double tolerance) {
            this.m_quads_stack.resize(0);
            this.m_extents_stack.clear();
            this.m_current_element_handle = -1;
            this.m_query_box.setCoords(query);
            this.m_query_box.inflate(tolerance, tolerance);
            this.m_tolerance = NumberUtils.NaN();
            if (this.m_query_box.isIntersecting(this.m_quad_tree.m_extent)) {
                this.m_quads_stack.add(this.m_quad_tree.m_root);
                this.m_extents_stack.add(this.m_quad_tree.m_extent);
                this.m_next_element_handle = this.m_quad_tree.getFirstElement_(this.m_quad_tree.m_root);
                this.m_b_linear = false;
            } else {
                this.m_next_element_handle = -1;
            }
        }

        int next() {
            if (this.m_quads_stack.size() == 0) {
                return -1;
            }
            this.m_current_element_handle = this.m_next_element_handle;
            Point2D start = null;
            Point2D end = null;
            Envelope2D extent_inf = null;
            Envelope2D[] child_extents = null;
            if (this.m_b_linear) {
                start = new Point2D();
                end = new Point2D();
                extent_inf = new Envelope2D();
            }
            boolean b_found_hit = false;
            while (!b_found_hit) {
                while (this.m_current_element_handle != -1) {
                    int current_box_handle = this.m_quad_tree.getBoxHandle_(this.m_current_element_handle);
                    Envelope2D bounding_box = this.m_quad_tree.getBoundingBox_(current_box_handle);
                    if (bounding_box.isIntersecting(this.m_query_box)) {
                        if (this.m_b_linear) {
                            start.setCoords(this.m_query_start);
                            end.setCoords(this.m_query_end);
                            extent_inf.setCoords(bounding_box);
                            extent_inf.inflate(this.m_tolerance, this.m_tolerance);
                            if (extent_inf.clipLine(start, end) > 0) {
                                b_found_hit = true;
                                break;
                            }
                        } else {
                            b_found_hit = true;
                            break;
                        }
                    }
                    this.m_current_element_handle = this.m_quad_tree.getNextElement_(this.m_current_element_handle);
                }
                if (this.m_current_element_handle != -1) continue;
                int current_quad = this.m_quads_stack.getLast();
                Envelope2D current_extent = this.m_extents_stack.get(this.m_extents_stack.size() - 1);
                double x_mid = 0.5 * (current_extent.xmin + current_extent.xmax);
                double y_mid = 0.5 * (current_extent.ymin + current_extent.ymax);
                if (child_extents == null) {
                    child_extents = new Envelope2D[]{new Envelope2D(), new Envelope2D(), new Envelope2D(), new Envelope2D()};
                }
                QuadTreeImpl.setChildExtents_(current_extent, child_extents);
                this.m_quads_stack.removeLast();
                this.m_extents_stack.remove(this.m_extents_stack.size() - 1);
                for (int quadrant = 0; quadrant < 4; ++quadrant) {
                    Envelope2D child_extent;
                    int child_handle = this.m_quad_tree.getChild_(current_quad, quadrant);
                    if (child_handle == -1 || this.m_quad_tree.getSubTreeElementCount(child_handle) <= 0 || !child_extents[quadrant].isIntersecting(this.m_query_box)) continue;
                    if (this.m_b_linear) {
                        start.setCoords(this.m_query_start);
                        end.setCoords(this.m_query_end);
                        extent_inf.setCoords(child_extents[quadrant]);
                        extent_inf.inflate(this.m_tolerance, this.m_tolerance);
                        if (extent_inf.clipLine(start, end) <= 0) continue;
                        child_extent = new Envelope2D();
                        child_extent.setCoords(child_extents[quadrant]);
                        this.m_quads_stack.add(child_handle);
                        this.m_extents_stack.add(child_extent);
                        continue;
                    }
                    child_extent = new Envelope2D();
                    child_extent.setCoords(child_extents[quadrant]);
                    this.m_quads_stack.add(child_handle);
                    this.m_extents_stack.add(child_extent);
                }
                assert (this.m_quads_stack.size() <= 4 * (this.m_quad_tree.m_height - 1));
                if (this.m_quads_stack.size() == 0) {
                    return -1;
                }
                this.m_current_element_handle = this.m_quad_tree.getFirstElement_(this.m_quads_stack.get(this.m_quads_stack.size() - 1));
            }
            this.m_next_element_handle = this.m_quad_tree.getNextElement_(this.m_current_element_handle);
            return this.m_current_element_handle;
        }

        QuadTreeIteratorImpl(QuadTreeImpl quad_tree_impl, Geometry query, double tolerance) {
            this.m_quad_tree = quad_tree_impl;
            this.m_query_box = new Envelope2D();
            this.m_quads_stack = new AttributeStreamOfInt32(0);
            this.m_extents_stack = new ArrayList(0);
            this.resetIterator(query, tolerance);
        }

        QuadTreeIteratorImpl(QuadTreeImpl quad_tree_impl, Envelope2D query, double tolerance) {
            this.m_quad_tree = quad_tree_impl;
            this.m_query_box = new Envelope2D();
            this.m_quads_stack = new AttributeStreamOfInt32(0);
            this.m_extents_stack = new ArrayList(0);
            this.resetIterator(query, tolerance);
        }

        QuadTreeIteratorImpl(QuadTreeImpl quad_tree_impl) {
            this.m_quad_tree = quad_tree_impl;
            this.m_query_box = new Envelope2D();
            this.m_quads_stack = new AttributeStreamOfInt32(0);
            this.m_extents_stack = new ArrayList(0);
        }
    }
}

