/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.QuadTreeImpl;
import com.esri.core.geometry.RasterizedGeometry2D;
import java.util.ArrayList;

class GeometryAccelerators {
    private RasterizedGeometry2D m_rasterizedGeometry;
    private QuadTreeImpl m_quad_tree;
    private ArrayList<Envelope2D> m_path_envelopes;

    GeometryAccelerators() {
    }

    public RasterizedGeometry2D getRasterizedGeometry() {
        return this.m_rasterizedGeometry;
    }

    public QuadTreeImpl getQuadTree() {
        return this.m_quad_tree;
    }

    public ArrayList<Envelope2D> getPathEnvelopes() {
        return this.m_path_envelopes;
    }

    void _setRasterizedGeometry(RasterizedGeometry2D rg) {
        this.m_rasterizedGeometry = rg;
    }

    void _setQuadTree(QuadTreeImpl quad_tree) {
        this.m_quad_tree = quad_tree;
    }

    void _setPathEnvelopes(ArrayList<Envelope2D> pe) {
        this.m_path_envelopes = pe;
    }

    static boolean canUseRasterizedGeometry(Geometry geom) {
        return !geom.isEmpty() && (geom.getType() == Geometry.Type.Polyline || geom.getType() == Geometry.Type.Polygon);
    }

    static boolean canUseQuadTree(Geometry geom) {
        if (geom.isEmpty() || geom.getType() != Geometry.Type.Polyline && geom.getType() != Geometry.Type.Polygon) {
            return false;
        }
        return ((MultiVertexGeometry)geom).getPointCount() >= 20;
    }

    static boolean canUsePathEnvelopes(Geometry geom) {
        return !geom.isEmpty() && (geom.getType() == Geometry.Type.Polyline || geom.getType() == Geometry.Type.Polygon);
    }
}

