/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.CrackAndCluster;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OperatorCutLocal;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentBuffer;
import java.util.ArrayList;
import java.util.Arrays;

class Cutter {
    Cutter() {
    }

    static EditShape CutPolyline(boolean bConsiderTouch, Polyline cuttee, Polyline cutter, double tolerance, ArrayList<OperatorCutLocal.CutPair> cutPairs, AttributeStreamOfInt32 segmentCounts, ProgressTracker progressTracker) {
        if (cuttee.isEmpty()) {
            OperatorCutLocal.CutPair cutPair = new OperatorCutLocal.CutPair(cuttee, 4, -1, -1, NumberUtils.NaN(), 4, -1, -1, NumberUtils.NaN(), -1, -1, NumberUtils.NaN(), -1, -1, NumberUtils.NaN());
            cutPairs.add(cutPair);
            return null;
        }
        EditShape editShape = new EditShape();
        int cutteeHandle = editShape.addGeometry(cuttee);
        int cutterHandle = editShape.addGeometry(cutter);
        CrackAndCluster.execute(editShape, tolerance, progressTracker);
        int order = 0;
        int orderIndex = editShape.createUserIndex();
        int igeometry = editShape.getFirstGeometry();
        while (igeometry != -1) {
            int ipath = editShape.getFirstPath(igeometry);
            while (ipath != -1) {
                int ivertex = editShape.getFirstVertex(ipath);
                int n = editShape.getPathSize(ipath);
                for (int i = 0; i < n; ++i) {
                    editShape.setUserIndex(ivertex, orderIndex, order++);
                    ivertex = editShape.getNextVertex(ivertex);
                }
                ipath = editShape.getNextPath(ipath);
            }
            igeometry = editShape.getNextGeometry(igeometry);
        }
        ArrayList<CutEvent> cutEvents = Cutter._getCutEvents(orderIndex, editShape);
        Cutter._Cut(bConsiderTouch, false, cutEvents, editShape, cutPairs, segmentCounts);
        return editShape;
    }

    private static ArrayList<CutEvent> _getCutEvents(int orderIndex, EditShape editShape) {
        int pointCount = editShape.getTotalPointCount();
        AttributeStreamOfInt32 vertices = new AttributeStreamOfInt32(0);
        int igeometry = editShape.getFirstGeometry();
        while (igeometry != -1) {
            int ipath = editShape.getFirstPath(igeometry);
            while (ipath != -1) {
                int ivertex = editShape.getFirstVertex(ipath);
                int n = editShape.getPathSize(ipath);
                for (int i = 0; i < n; ++i) {
                    vertices.add(ivertex);
                    ivertex = editShape.getNextVertex(ivertex);
                }
                ipath = editShape.getNextPath(ipath);
            }
            igeometry = editShape.getNextGeometry(igeometry);
        }
        CompareVertices compareVertices = new CompareVertices(orderIndex, editShape);
        vertices.Sort(0, pointCount, new CutterVertexComparer(compareVertices));
        ArrayList<CutEvent> cutEvents = new ArrayList<CutEvent>(0);
        ArrayList<CutEvent> cutEventsTemp = new ArrayList<CutEvent>(0);
        int eventIndex = editShape.createUserIndex();
        int eventIndexTemp = editShape.createUserIndex();
        int cutteeHandle = editShape.getFirstGeometry();
        int cutterHandle = editShape.getNextGeometry(cutteeHandle);
        Point2D pointCuttee = new Point2D();
        Point2D pointCutter = new Point2D();
        int ivertexCuttee = vertices.get(0);
        int ipartCuttee = editShape.getPathFromVertex(ivertexCuttee);
        int igeometryCuttee = editShape.getGeometryFromPath(ipartCuttee);
        editShape.getXY(ivertexCuttee, pointCuttee);
        int istart = 1;
        int ivertex = 0;
        while (istart < pointCount - 1) {
            boolean bCutEvent = false;
            for (int i = istart; i < pointCount; ++i) {
                boolean bCondition;
                if (i == ivertex) continue;
                int ivertexCutter = vertices.get(i);
                int ipartCutter = editShape.getPathFromVertex(ivertexCutter);
                int igeometryCutter = editShape.getGeometryFromPath(ipartCutter);
                editShape.getXY(ivertexCutter, pointCutter);
                if (!pointCuttee.isEqual(pointCutter)) break;
                boolean bl = bCondition = igeometryCuttee == cutteeHandle && igeometryCutter == cutterHandle;
                if (!bCondition) continue;
                bCutEvent = Cutter._cutteeCutterEvents(eventIndex, eventIndexTemp, editShape, cutEvents, cutEventsTemp, ipartCuttee, ivertexCuttee, ipartCutter, ivertexCutter);
            }
            if (bCutEvent || ivertex == istart - 1) {
                if (bCutEvent && ivertex == istart - 1) {
                    --istart;
                }
                if (++ivertex == pointCount) break;
                ivertexCuttee = vertices.get(ivertex);
                ipartCuttee = editShape.getPathFromVertex(ivertexCuttee);
                igeometryCuttee = editShape.getGeometryFromPath(ipartCuttee);
                editShape.getXY(ivertexCuttee, pointCuttee);
            }
            if (bCutEvent) continue;
            istart = ivertex + 1;
        }
        ArrayList<CutEvent> cutEventsSorted = new ArrayList<CutEvent>(0);
        int igeometry2 = editShape.getFirstGeometry();
        while (igeometry2 != -1) {
            int ipath = editShape.getFirstPath(igeometry2);
            while (ipath != -1) {
                int iv = editShape.getFirstVertex(ipath);
                int n = editShape.getPathSize(ipath);
                for (int i = 0; i < n; ++i) {
                    int icutEvent;
                    int icutEventTemp = editShape.getUserIndex(iv, eventIndexTemp);
                    if (icutEventTemp >= 0) {
                        while (icutEventTemp < cutEventsTemp.size() && ((CutEvent)cutEventsTemp.get((int)icutEventTemp)).m_ivertexCuttee == iv) {
                            cutEventsSorted.add(cutEventsTemp.get(icutEventTemp++));
                        }
                    }
                    if ((icutEvent = editShape.getUserIndex(iv, eventIndex)) >= 0) {
                        while (icutEvent < cutEvents.size() && cutEvents.get((int)icutEvent).m_ivertexCuttee == iv) {
                            cutEventsSorted.add(cutEvents.get(icutEvent++));
                        }
                    }
                    iv = editShape.getNextVertex(iv);
                }
                ipath = editShape.getNextPath(ipath);
            }
            igeometry2 = editShape.getNextGeometry(igeometry2);
        }
        editShape.removeUserIndex(eventIndex);
        editShape.removeUserIndex(eventIndexTemp);
        return cutEventsSorted;
    }

    static boolean _cutteeCutterEvents(int eventIndex, int eventIndexTemp, EditShape editShape, ArrayList<CutEvent> cutEvents, ArrayList<CutEvent> cutEventsTemp, int ipartCuttee, int ivertexCuttee, int ipartCutter, int ivertexCutter) {
        int ilastVertexCuttee = editShape.getLastVertex(ipartCuttee);
        int ilastVertexCutter = editShape.getLastVertex(ipartCutter);
        int ifirstVertexCuttee = editShape.getFirstVertex(ipartCuttee);
        int ifirstVertexCutter = editShape.getFirstVertex(ipartCutter);
        int ivertexCutteePrev = editShape.getPrevVertex(ivertexCuttee);
        int ivertexCutterPrev = editShape.getPrevVertex(ivertexCutter);
        boolean bEndEnd = false;
        boolean bEndStart = false;
        boolean bStartEnd = false;
        boolean bStartStart = false;
        if (ivertexCuttee != ifirstVertexCuttee) {
            if (ivertexCutter != ifirstVertexCutter) {
                bEndEnd = Cutter._cutteeEndCutterEndEvent(eventIndex, editShape, cutEvents, ipartCuttee, ivertexCutteePrev, ipartCutter, ivertexCutterPrev);
            }
            if (ivertexCutter != ilastVertexCutter) {
                bEndStart = Cutter._cutteeEndCutterStartEvent(eventIndex, editShape, cutEvents, ipartCuttee, ivertexCutteePrev, ipartCutter, ivertexCutter);
            }
        }
        if (ivertexCuttee != ilastVertexCuttee) {
            if (ivertexCutter != ifirstVertexCutter) {
                bStartEnd = Cutter._cutteeStartCutterEndEvent(eventIndexTemp, editShape, cutEventsTemp, ipartCuttee, ivertexCuttee, ipartCutter, ivertexCutterPrev, ifirstVertexCuttee);
            }
            if (ivertexCutter != ilastVertexCutter) {
                bStartStart = Cutter._cutteeStartCutterStartEvent(eventIndexTemp, editShape, cutEventsTemp, ipartCuttee, ivertexCuttee, ipartCutter, ivertexCutter, ifirstVertexCuttee);
            }
        }
        if (bEndEnd && bEndStart && bStartEnd) {
            int istartend;
            int iendstart = cutEvents.size() - 1;
            int n = istartend = bStartStart ? cutEventsTemp.size() - 2 : cutEventsTemp.size() - 1;
            if (cutEventsTemp.get((int)istartend).m_count == 2) {
                cutEvents.set(iendstart - 1, cutEvents.get(iendstart));
                cutEvents.remove(cutEvents.size() - 1);
            }
        } else if (bEndEnd && bEndStart && bStartStart) {
            int istartstart = cutEventsTemp.size() - 1;
            if (cutEventsTemp.get((int)istartstart).m_count == 2) {
                CutEvent lastEvent = cutEvents.get(cutEvents.size() - 1);
                cutEvents.remove(cutEvents.get(cutEvents.size() - 1));
                int icutEvent = editShape.getUserIndex(lastEvent.m_ivertexCuttee, eventIndex);
                if (icutEvent == cutEvents.size()) {
                    editShape.setUserIndex(lastEvent.m_ivertexCuttee, eventIndex, -1);
                }
            }
        }
        return bEndEnd || bEndStart || bStartEnd || bStartStart;
    }

    private static boolean _cutteeEndCutterEndEvent(int eventIndex, EditShape editShape, ArrayList<CutEvent> cutEvents, int ipartCuttee, int ivertexCuttee, int ipartCutter, int ivertexCutter) {
        int count;
        Segment segmentCutter;
        Line lineCuttee = new Line();
        Line lineCutter = new Line();
        double[] scalarsCuttee = new double[2];
        double[] scalarsCutter = new double[2];
        Segment segmentCuttee = editShape.getSegment(ivertexCuttee);
        if (segmentCuttee == null) {
            editShape.queryLineConnector(ivertexCuttee, lineCuttee);
            segmentCuttee = lineCuttee;
        }
        if ((segmentCutter = editShape.getSegment(ivertexCutter)) == null) {
            editShape.queryLineConnector(ivertexCutter, lineCutter);
            segmentCutter = lineCutter;
        }
        if ((count = segmentCuttee.intersect(segmentCutter, null, scalarsCuttee, scalarsCutter, 0.0)) < 2) {
            CutEvent cutEvent = new CutEvent(ivertexCuttee, ipartCuttee, scalarsCuttee[0], NumberUtils.NaN(), count, ivertexCutter, ipartCutter, scalarsCutter[0], NumberUtils.NaN());
            cutEvents.add(cutEvent);
            int icutEvent = editShape.getUserIndex(ivertexCuttee, eventIndex);
            if (icutEvent < 0) {
                editShape.setUserIndex(ivertexCuttee, eventIndex, cutEvents.size() - 1);
            }
        }
        return true;
    }

    private static boolean _cutteeEndCutterStartEvent(int eventIndex, EditShape editShape, ArrayList<CutEvent> cutEvents, int ipartCuttee, int ivertexCuttee, int ipartCutter, int ivertexCutter) {
        int count;
        Segment segmentCutter;
        Line lineCuttee = new Line();
        Line lineCutter = new Line();
        double[] scalarsCuttee = new double[2];
        double[] scalarsCutter = new double[2];
        Segment segmentCuttee = editShape.getSegment(ivertexCuttee);
        if (segmentCuttee == null) {
            editShape.queryLineConnector(ivertexCuttee, lineCuttee);
            segmentCuttee = lineCuttee;
        }
        if ((segmentCutter = editShape.getSegment(ivertexCutter)) == null) {
            editShape.queryLineConnector(ivertexCutter, lineCutter);
            segmentCutter = lineCutter;
        }
        if ((count = segmentCuttee.intersect(segmentCutter, null, scalarsCuttee, scalarsCutter, 0.0)) < 2) {
            CutEvent cutEvent = new CutEvent(ivertexCuttee, ipartCuttee, scalarsCuttee[0], NumberUtils.NaN(), count, ivertexCutter, ipartCutter, scalarsCutter[0], NumberUtils.NaN());
            cutEvents.add(cutEvent);
            int icutEvent = editShape.getUserIndex(ivertexCuttee, eventIndex);
            if (icutEvent < 0) {
                editShape.setUserIndex(ivertexCuttee, eventIndex, cutEvents.size() - 1);
            }
            return true;
        }
        return false;
    }

    private static boolean _cutteeStartCutterEndEvent(int eventIndex, EditShape editShape, ArrayList<CutEvent> cutEvents, int ipartCuttee, int ivertexCuttee, int ipartCutter, int ivertexCutter, int ifirstVertexCuttee) {
        int count;
        Segment segmentCutter;
        Line lineCuttee = new Line();
        Line lineCutter = new Line();
        double[] scalarsCuttee = new double[2];
        double[] scalarsCutter = new double[2];
        Segment segmentCuttee = editShape.getSegment(ivertexCuttee);
        if (segmentCuttee == null) {
            editShape.queryLineConnector(ivertexCuttee, lineCuttee);
            segmentCuttee = lineCuttee;
        }
        if ((segmentCutter = editShape.getSegment(ivertexCutter)) == null) {
            editShape.queryLineConnector(ivertexCutter, lineCutter);
            segmentCutter = lineCutter;
        }
        if ((count = segmentCuttee.intersect(segmentCutter, null, scalarsCuttee, scalarsCutter, 0.0)) == 2) {
            CutEvent cutEvent = new CutEvent(ivertexCuttee, ipartCuttee, scalarsCuttee[0], scalarsCuttee[1], count, ivertexCutter, ipartCutter, scalarsCutter[0], scalarsCutter[1]);
            cutEvents.add(cutEvent);
            int icutEvent = editShape.getUserIndex(ivertexCuttee, eventIndex);
            if (icutEvent < 0) {
                editShape.setUserIndex(ivertexCuttee, eventIndex, cutEvents.size() - 1);
            }
            return true;
        }
        boolean bCutEvent = false;
        if (ivertexCuttee == ifirstVertexCuttee) {
            CutEvent cutEvent = new CutEvent(ivertexCuttee, ipartCuttee, scalarsCuttee[0], NumberUtils.NaN(), count, ivertexCutter, ipartCutter, scalarsCutter[0], NumberUtils.NaN());
            cutEvents.add(cutEvent);
            int icutEvent = editShape.getUserIndex(ivertexCuttee, eventIndex);
            if (icutEvent < 0) {
                editShape.setUserIndex(ivertexCuttee, eventIndex, cutEvents.size() - 1);
            }
            bCutEvent = true;
        }
        return bCutEvent;
    }

    private static boolean _cutteeStartCutterStartEvent(int eventIndex, EditShape editShape, ArrayList<CutEvent> cutEvents, int ipartCuttee, int ivertexCuttee, int ipartCutter, int ivertexCutter, int ifirstVertexCuttee) {
        int count;
        Segment segmentCutter;
        Line lineCuttee = new Line();
        Line lineCutter = new Line();
        double[] scalarsCuttee = new double[2];
        double[] scalarsCutter = new double[2];
        Segment segmentCuttee = editShape.getSegment(ivertexCuttee);
        if (segmentCuttee == null) {
            editShape.queryLineConnector(ivertexCuttee, lineCuttee);
            segmentCuttee = lineCuttee;
        }
        if ((segmentCutter = editShape.getSegment(ivertexCutter)) == null) {
            editShape.queryLineConnector(ivertexCutter, lineCutter);
            segmentCutter = lineCutter;
        }
        if ((count = segmentCuttee.intersect(segmentCutter, null, scalarsCuttee, scalarsCutter, 0.0)) == 2) {
            CutEvent cutEvent = new CutEvent(ivertexCuttee, ipartCuttee, scalarsCuttee[0], scalarsCuttee[1], count, ivertexCutter, ipartCutter, scalarsCutter[0], scalarsCutter[1]);
            cutEvents.add(cutEvent);
            int icutEvent = editShape.getUserIndex(ivertexCuttee, eventIndex);
            if (icutEvent < 0) {
                editShape.setUserIndex(ivertexCuttee, eventIndex, cutEvents.size() - 1);
            }
            return true;
        }
        boolean bCutEvent = false;
        if (ivertexCuttee == ifirstVertexCuttee) {
            CutEvent cutEvent = new CutEvent(ivertexCuttee, ipartCuttee, scalarsCuttee[0], NumberUtils.NaN(), count, ivertexCutter, ipartCutter, scalarsCutter[0], NumberUtils.NaN());
            cutEvents.add(cutEvent);
            int icutEvent = editShape.getUserIndex(ivertexCuttee, eventIndex);
            if (icutEvent < 0) {
                editShape.setUserIndex(ivertexCuttee, eventIndex, cutEvents.size() - 1);
            }
            bCutEvent = true;
        }
        return bCutEvent;
    }

    static void _Cut(boolean bConsiderTouch, boolean bLocalCutsOnly, ArrayList<CutEvent> cutEvents, EditShape shape, ArrayList<OperatorCutLocal.CutPair> cutPairs, AttributeStreamOfInt32 segmentCounts) {
        Point2D[] tangents = new Point2D[]{new Point2D(), new Point2D(), new Point2D(), new Point2D()};
        Point2D tangent0 = new Point2D();
        Point2D tangent1 = new Point2D();
        Point2D tangent2 = new Point2D();
        Point2D tangent3 = new Point2D();
        SegmentBuffer segmentBufferCuttee = null;
        if (cutPairs != null) {
            segmentBufferCuttee = new SegmentBuffer();
            segmentBufferCuttee.createLine();
        }
        Segment segmentCuttee = null;
        int icutEvent = 0;
        Polyline multipath = null;
        Line lineCuttee = new Line();
        Line lineCutter = new Line();
        int polyline = shape.getFirstGeometry();
        int ipath = shape.getFirstPath(polyline);
        while (ipath != -1) {
            int cut;
            OperatorCutLocal.CutPair cutPair;
            int cutPrev = 4;
            int ipartCuttee = -1;
            int ivertexCuttee = -1;
            double scalarCuttee = NumberUtils.NaN();
            int ipartCutteePrev = -1;
            int ivertexCutteePrev = -1;
            double scalarCutteePrev = NumberUtils.NaN();
            int ipartCutter = -1;
            int ivertexCutter = -1;
            double scalarCutter = NumberUtils.NaN();
            int ipartCutterPrev = -1;
            int ivertexCutterPrev = -1;
            double scalarCutterPrev = NumberUtils.NaN();
            boolean bNoCutYet = true;
            boolean bCoincidentNotAdded = false;
            boolean bCurrentMultiPathNotAdded = true;
            boolean bStartNewPath = true;
            boolean bCreateNewMultiPath = true;
            int segmentCount = 0;
            ipartCutteePrev = ipath;
            scalarCutteePrev = 0.0;
            int ivertex = shape.getFirstVertex(ipath);
            int n = shape.getPathSize(ipath);
            for (int i = 0; i < n; ++i) {
                block110: {
                    block109: {
                        segmentCuttee = shape.getSegment(ivertex);
                        if (segmentCuttee != null) break block109;
                        if (!shape.queryLineConnector(ivertex, lineCuttee)) break block110;
                        segmentCuttee = lineCuttee;
                    }
                    if (ivertexCutteePrev == -1) {
                        ivertexCutteePrev = ivertex;
                    }
                    double lastScalarCuttee = 0.0;
                    while (icutEvent < cutEvents.size() && ivertex == cutEvents.get((int)icutEvent).m_ivertexCuttee) {
                        ipartCuttee = cutEvents.get((int)icutEvent).m_ipartCuttee;
                        ivertexCuttee = cutEvents.get((int)icutEvent).m_ivertexCuttee;
                        scalarCuttee = cutEvents.get((int)icutEvent).m_scalarCuttee0;
                        ipartCutter = cutEvents.get((int)icutEvent).m_ipartCutter;
                        ivertexCutter = cutEvents.get((int)icutEvent).m_ivertexCutter;
                        scalarCutter = cutEvents.get((int)icutEvent).m_scalarCutter0;
                        if (cutEvents.get((int)icutEvent).m_count == 2) {
                            if (!bCoincidentNotAdded) {
                                ipartCutteePrev = ipartCuttee;
                                ivertexCutteePrev = ivertexCuttee;
                                scalarCutteePrev = scalarCuttee;
                                ipartCutterPrev = ipartCutter;
                                ivertexCutterPrev = ivertexCutter;
                                scalarCutterPrev = scalarCutter;
                                cutPrev = 2;
                                if (cutPairs != null) {
                                    multipath = new Polyline();
                                } else {
                                    segmentCount = 0;
                                }
                                bCreateNewMultiPath = false;
                                bStartNewPath = true;
                            }
                            scalarCuttee = cutEvents.get((int)icutEvent).m_scalarCuttee1;
                            scalarCutter = cutEvents.get((int)icutEvent).m_scalarCutter1;
                            if (cutPairs != null) {
                                segmentCuttee.cut(lastScalarCuttee, cutEvents.get((int)icutEvent).m_scalarCuttee1, segmentBufferCuttee);
                                ((MultiPath)multipath).addSegment(segmentBufferCuttee.get(), bStartNewPath);
                            } else {
                                ++segmentCount;
                            }
                            lastScalarCuttee = scalarCuttee;
                            bCoincidentNotAdded = true;
                            bNoCutYet = false;
                            bStartNewPath = false;
                            if (icutEvent + 1 == cutEvents.size() || cutEvents.get((int)(icutEvent + 1)).m_count != 2 || cutEvents.get((int)(icutEvent + 1)).m_ivertexCuttee == ivertexCuttee && cutEvents.get((int)(icutEvent + 1)).m_scalarCuttee0 != lastScalarCuttee) {
                                if (cutPairs != null) {
                                    cutPair = new OperatorCutLocal.CutPair(multipath, 2, ipartCuttee, ivertexCuttee, scalarCuttee, cutPrev, ipartCutteePrev, ivertexCutteePrev, scalarCutteePrev, ipartCutter, ivertexCutter, scalarCutter, ipartCutterPrev, ivertexCutterPrev, scalarCutterPrev);
                                    cutPairs.add(cutPair);
                                } else {
                                    segmentCounts.add(segmentCount);
                                }
                                ipartCutteePrev = ipartCuttee;
                                ivertexCutteePrev = ivertexCuttee;
                                scalarCutteePrev = scalarCuttee;
                                ipartCutterPrev = ipartCutter;
                                ivertexCutterPrev = ivertexCutter;
                                scalarCutterPrev = scalarCutter;
                                cutPrev = 2;
                                bNoCutYet = false;
                                bCoincidentNotAdded = false;
                                bCreateNewMultiPath = true;
                                bStartNewPath = true;
                            }
                            ++icutEvent;
                            continue;
                        }
                        int ivertexCutteePlus = shape.getNextVertex(ivertexCuttee);
                        int ivertexCutterPlus = shape.getNextVertex(ivertexCutter);
                        int ivertexCutterMinus = shape.getPrevVertex(ivertexCutter);
                        if (icutEvent < cutEvents.size() - 1 && cutEvents.get((int)(icutEvent + 1)).m_ivertexCuttee == ivertexCutteePlus && cutEvents.get((int)(icutEvent + 1)).m_ivertexCutter == ivertexCutter && cutEvents.get((int)(icutEvent + 1)).m_count == 2) {
                            if (scalarCuttee != lastScalarCuttee) {
                                if (bCreateNewMultiPath) {
                                    if (cutPairs != null) {
                                        multipath = new Polyline();
                                    } else {
                                        segmentCount = 0;
                                    }
                                }
                                cut = icutEvent > 0 && cutEvents.get((int)(icutEvent - 1)).m_ipartCuttee == ipartCuttee ? (cutPrev == 1 ? 0 : (cutPrev == 0 ? 1 : 3)) : 3;
                                if (cutPairs != null) {
                                    segmentCuttee.cut(lastScalarCuttee, scalarCuttee, segmentBufferCuttee);
                                    ((MultiPath)multipath).addSegment(segmentBufferCuttee.get(), bStartNewPath);
                                    cutPair = new OperatorCutLocal.CutPair(multipath, cut, ipartCuttee, ivertexCuttee, scalarCuttee, cutPrev, ipartCutteePrev, ivertexCutteePrev, scalarCutteePrev, ipartCutter, ivertexCutter, scalarCutter, ipartCutterPrev, ivertexCutterPrev, scalarCutterPrev);
                                    cutPairs.add(cutPair);
                                } else {
                                    segmentCounts.add(++segmentCount);
                                }
                                lastScalarCuttee = scalarCuttee;
                                ipartCutteePrev = ipartCuttee;
                                ivertexCutteePrev = ivertexCuttee;
                                scalarCutteePrev = scalarCuttee;
                                ipartCutterPrev = ipartCutter;
                                ivertexCutterPrev = ivertexCutter;
                                scalarCutterPrev = scalarCutter;
                                cutPrev = cut;
                                bCurrentMultiPathNotAdded = false;
                                bNoCutYet = false;
                                bCreateNewMultiPath = true;
                                bStartNewPath = true;
                            }
                            ++icutEvent;
                            continue;
                        }
                        boolean bContinue = Cutter._cutterTangents(bConsiderTouch, shape, cutEvents, icutEvent, tangent0, tangent1);
                        if (bContinue) {
                            ++icutEvent;
                            continue;
                        }
                        Cutter._cutteeTangents(shape, cutEvents, icutEvent, ipath, ivertex, tangent2, tangent3);
                        boolean bCut = false;
                        boolean bTouch = false;
                        boolean bCutRight = true;
                        if (!(tangent0.isEqual(tangent2) || tangent1.isEqual(tangent2) || tangent0.isEqual(tangent3) || tangent1.isEqual(tangent3))) {
                            tangents[0].setCoords(tangent0);
                            tangents[1].setCoords(tangent1);
                            tangents[2].setCoords(tangent2);
                            tangents[3].setCoords(tangent3);
                            Arrays.sort(tangents, new Point2D.CompareVectors());
                            Point2D value0 = tangents[0];
                            Point2D value1 = tangents[1];
                            Point2D value2 = tangents[2];
                            Point2D value3 = tangents[3];
                            if (value0.isEqual(tangent0)) {
                                if (value1.isEqual(tangent1)) {
                                    if (!bConsiderTouch) {
                                        bCut = false;
                                    } else {
                                        bCut = true;
                                        bTouch = true;
                                        bCutRight = false;
                                    }
                                } else if (value3.isEqual(tangent1)) {
                                    if (!bConsiderTouch) {
                                        bCut = false;
                                    } else {
                                        bCut = true;
                                        bTouch = true;
                                        bCutRight = true;
                                    }
                                } else {
                                    bCut = true;
                                    bCutRight = value1.isEqual(tangent2);
                                }
                            } else if (value1.isEqual(tangent0)) {
                                if (value2.isEqual(tangent1)) {
                                    if (!bConsiderTouch) {
                                        bCut = false;
                                    } else {
                                        bCut = true;
                                        bTouch = true;
                                        bCutRight = false;
                                    }
                                } else if (value0.isEqual(tangent1)) {
                                    if (!bConsiderTouch) {
                                        bCut = false;
                                    } else {
                                        bCut = true;
                                        bTouch = true;
                                        bCutRight = true;
                                    }
                                } else {
                                    bCut = true;
                                    bCutRight = value2.isEqual(tangent2);
                                }
                            } else if (value2.isEqual(tangent0)) {
                                if (value3.isEqual(tangent1)) {
                                    if (!bConsiderTouch) {
                                        bCut = false;
                                    } else {
                                        bCut = true;
                                        bTouch = true;
                                        bCutRight = false;
                                    }
                                } else if (value1.isEqual(tangent1)) {
                                    if (!bConsiderTouch) {
                                        bCut = false;
                                    } else {
                                        bCut = true;
                                        bTouch = true;
                                        bCutRight = true;
                                    }
                                } else {
                                    bCut = true;
                                    bCutRight = value3.isEqual(tangent2);
                                }
                            } else if (value0.isEqual(tangent1)) {
                                if (!bConsiderTouch) {
                                    bCut = false;
                                } else {
                                    bCut = true;
                                    bTouch = true;
                                    bCutRight = false;
                                }
                            } else if (value2.isEqual(tangent1)) {
                                if (!bConsiderTouch) {
                                    bCut = false;
                                } else {
                                    bCut = true;
                                    bTouch = true;
                                    bCutRight = true;
                                }
                            } else {
                                bCut = true;
                                bCutRight = value0.isEqual(tangent2);
                            }
                        }
                        if (bCut) {
                            boolean bIsFirstSegmentInPath;
                            boolean bl = bIsFirstSegmentInPath = ivertex == ivertexCuttee;
                            if (scalarCuttee != lastScalarCuttee || bIsFirstSegmentInPath && lastScalarCuttee == 0.0) {
                                if (bCreateNewMultiPath) {
                                    if (cutPairs != null) {
                                        multipath = new Polyline();
                                    } else {
                                        segmentCount = 0;
                                    }
                                }
                                if (cutPairs != null) {
                                    segmentCuttee.cut(lastScalarCuttee, scalarCuttee, segmentBufferCuttee);
                                    ((MultiPath)multipath).addSegment(segmentBufferCuttee.get(), bStartNewPath);
                                } else {
                                    ++segmentCount;
                                }
                            }
                            if (bCutRight) {
                                if (cutPrev != 1 || bLocalCutsOnly) {
                                    if (scalarCuttee != lastScalarCuttee || bIsFirstSegmentInPath && lastScalarCuttee == 0.0 || bLocalCutsOnly) {
                                        if (cutPairs != null) {
                                            cutPair = new OperatorCutLocal.CutPair(multipath, 1, ipartCuttee, ivertexCuttee, scalarCuttee, cutPrev, ipartCutteePrev, ivertexCutteePrev, scalarCutteePrev, ipartCutter, ivertexCutter, scalarCutter, ipartCutterPrev, ivertexCutterPrev, scalarCutterPrev);
                                            cutPairs.add(cutPair);
                                        } else {
                                            segmentCounts.add(segmentCount);
                                        }
                                    }
                                    if (!bTouch) {
                                        cutPrev = 1;
                                    } else if (icutEvent == cutEvents.size() - 2 || cutEvents.get((int)(icutEvent + 2)).m_ipartCuttee != ipartCuttee) {
                                        cutPrev = 0;
                                    }
                                } else {
                                    if (scalarCuttee != lastScalarCuttee || bIsFirstSegmentInPath && lastScalarCuttee == 0.0 || bLocalCutsOnly) {
                                        if (cutPairs != null) {
                                            cutPair = new OperatorCutLocal.CutPair(multipath, 3, ipartCuttee, ivertexCuttee, scalarCuttee, cutPrev, ipartCutteePrev, ivertexCutteePrev, scalarCutteePrev, ipartCutter, ivertexCutter, scalarCutter, ipartCutterPrev, ivertexCutterPrev, scalarCutterPrev);
                                            cutPairs.add(cutPair);
                                        } else {
                                            segmentCounts.add(segmentCount);
                                        }
                                    }
                                    cutPrev = 1;
                                }
                            } else if (cutPrev != 0 || bLocalCutsOnly) {
                                if (scalarCuttee != lastScalarCuttee || bIsFirstSegmentInPath && lastScalarCuttee == 0.0 || bLocalCutsOnly) {
                                    if (cutPairs != null) {
                                        cutPair = new OperatorCutLocal.CutPair(multipath, 0, ipartCuttee, ivertexCuttee, scalarCuttee, cutPrev, ipartCutteePrev, ivertexCutteePrev, scalarCutteePrev, ipartCutter, ivertexCutter, scalarCutter, ipartCutterPrev, ivertexCutterPrev, scalarCutterPrev);
                                        cutPairs.add(cutPair);
                                    } else {
                                        segmentCounts.add(segmentCount);
                                    }
                                }
                                if (!bTouch) {
                                    cutPrev = 0;
                                } else if (icutEvent == cutEvents.size() - 2 || cutEvents.get((int)(icutEvent + 2)).m_ipartCuttee != ipartCuttee) {
                                    cutPrev = 1;
                                }
                            } else {
                                if (scalarCuttee != lastScalarCuttee || bIsFirstSegmentInPath && lastScalarCuttee == 0.0 || bLocalCutsOnly) {
                                    if (cutPairs != null) {
                                        cutPair = new OperatorCutLocal.CutPair(multipath, 3, ipartCuttee, ivertexCuttee, scalarCuttee, cutPrev, ipartCutteePrev, ivertexCutteePrev, scalarCutteePrev, ipartCutter, ivertexCutter, scalarCutter, ipartCutterPrev, ivertexCutterPrev, scalarCutterPrev);
                                        cutPairs.add(cutPair);
                                    } else {
                                        segmentCounts.add(segmentCount);
                                    }
                                }
                                cutPrev = 0;
                            }
                            if (scalarCuttee != lastScalarCuttee || bIsFirstSegmentInPath && lastScalarCuttee == 0.0 || bLocalCutsOnly) {
                                lastScalarCuttee = scalarCuttee;
                                ipartCutteePrev = ipartCuttee;
                                ivertexCutteePrev = ivertexCuttee;
                                scalarCutteePrev = scalarCuttee;
                                ipartCutterPrev = ipartCutter;
                                ivertexCutterPrev = ivertexCutter;
                                scalarCutterPrev = scalarCutter;
                                bCurrentMultiPathNotAdded = false;
                                bNoCutYet = false;
                                bCreateNewMultiPath = true;
                                bStartNewPath = true;
                            }
                        }
                        ++icutEvent;
                    }
                    if (lastScalarCuttee != 1.0) {
                        if (bCreateNewMultiPath) {
                            if (cutPairs != null) {
                                multipath = new Polyline();
                            } else {
                                segmentCount = 0;
                            }
                        }
                        if (cutPairs != null) {
                            segmentCuttee.cut(lastScalarCuttee, 1.0, segmentBufferCuttee);
                            ((MultiPath)multipath).addSegment(segmentBufferCuttee.get(), bStartNewPath);
                        } else {
                            ++segmentCount;
                        }
                        bCreateNewMultiPath = false;
                        bStartNewPath = false;
                        bCurrentMultiPathNotAdded = true;
                    }
                }
                ivertex = shape.getNextVertex(ivertex);
            }
            if (bCurrentMultiPathNotAdded) {
                scalarCuttee = 1.0;
                ivertexCuttee = shape.getLastVertex(ipath);
                ivertexCuttee = shape.getPrevVertex(ivertexCuttee);
                ipartCutter = -1;
                ivertexCutter = -1;
                scalarCutter = NumberUtils.NaN();
                if (bNoCutYet) {
                    if (cutPairs != null) {
                        cutPair = new OperatorCutLocal.CutPair(multipath, 4, ipartCuttee, ivertexCuttee, scalarCuttee, cutPrev, ipartCutteePrev, ivertexCutteePrev, scalarCutteePrev, ipartCutter, ivertexCutter, scalarCutter, ipartCutterPrev, ivertexCutterPrev, scalarCutterPrev);
                        cutPairs.add(cutPair);
                    } else {
                        segmentCounts.add(segmentCount);
                    }
                } else {
                    cut = cutPrev == 1 ? 0 : (cutPrev == 0 ? 1 : 3);
                    if (cutPairs != null) {
                        cutPair = new OperatorCutLocal.CutPair(multipath, cut, ipartCuttee, ivertexCuttee, scalarCuttee, cutPrev, ipartCutteePrev, ivertexCutteePrev, scalarCutteePrev, ipartCutter, ivertexCutter, scalarCutter, ipartCutterPrev, ivertexCutterPrev, scalarCutterPrev);
                        cutPairs.add(cutPair);
                    } else {
                        segmentCounts.add(segmentCount);
                    }
                }
            }
            ipath = shape.getNextPath(ipath);
        }
    }

    static boolean _cutterTangents(boolean bConsiderTouch, EditShape shape, ArrayList<CutEvent> cutEvents, int icutEvent, Point2D tangent0, Point2D tangent1) {
        double scalarCutter = cutEvents.get((int)icutEvent).m_scalarCutter0;
        if (scalarCutter == 1.0) {
            return Cutter._cutterEndTangents(bConsiderTouch, shape, cutEvents, icutEvent, tangent0, tangent1);
        }
        if (scalarCutter == 0.0) {
            return Cutter._cutterStartTangents(bConsiderTouch, shape, cutEvents, icutEvent, tangent0, tangent1);
        }
        throw GeometryException.GeometryInternalError();
    }

    static boolean _cutterEndTangents(boolean bConsiderTouch, EditShape shape, ArrayList<CutEvent> cutEvents, int icutEvent, Point2D tangent0, Point2D tangent1) {
        Line lineCutter = new Line();
        int ivertexCuttee = cutEvents.get((int)icutEvent).m_ivertexCuttee;
        int ipartCutter = cutEvents.get((int)icutEvent).m_ipartCutter;
        int ivertexCutter = cutEvents.get((int)icutEvent).m_ivertexCutter;
        int ivertexCutteePrev = -1;
        int ipartCutterPrev = -1;
        int ivertexCutterPrev = -1;
        int countPrev = -1;
        if (!bConsiderTouch && icutEvent > 0) {
            CutEvent cutEvent = cutEvents.get(icutEvent - 1);
            ivertexCutteePrev = cutEvent.m_ivertexCuttee;
            ipartCutterPrev = cutEvent.m_ipartCutter;
            ivertexCutterPrev = cutEvent.m_ivertexCutter;
            countPrev = cutEvent.m_count;
        }
        int ivertexCutteeNext = -1;
        int ipartCutterNext = -1;
        int ivertexCutterNext = -1;
        int countNext = -1;
        if (icutEvent < cutEvents.size() - 1) {
            CutEvent cutEvent = cutEvents.get(icutEvent + 1);
            ivertexCutteeNext = cutEvent.m_ivertexCuttee;
            ipartCutterNext = cutEvent.m_ipartCutter;
            ivertexCutterNext = cutEvent.m_ivertexCutter;
            countNext = cutEvent.m_count;
        }
        int ivertexCutteePlus = shape.getNextVertex(ivertexCuttee);
        int ivertexCutterPlus = shape.getNextVertex(ivertexCutter);
        if (!bConsiderTouch) {
            if (icutEvent > 0 && ivertexCutteePrev == ivertexCuttee && ipartCutterPrev == ipartCutter && ivertexCutterPrev == ivertexCutterPlus && countPrev == 2 || icutEvent < cutEvents.size() - 1 && ivertexCutteeNext == ivertexCutteePlus && ipartCutterNext == ipartCutter && ivertexCutterNext == ivertexCutterPlus && countNext == 2) {
                Segment segmentCutter = shape.getSegment(ivertexCutter);
                if (segmentCutter == null) {
                    shape.queryLineConnector(ivertexCutter, lineCutter);
                    segmentCutter = lineCutter;
                }
                tangent1.setCoords(segmentCutter._getTangent(1.0));
                tangent0.negate(tangent1);
                tangent1.normalize();
                tangent0.normalize();
                return false;
            }
            if (icutEvent < cutEvents.size() - 1 && ivertexCutteeNext == ivertexCuttee && ipartCutterNext == ipartCutter && ivertexCutterNext == ivertexCutterPlus) {
                Segment segmentCutter = shape.getSegment(ivertexCutter);
                if (segmentCutter == null) {
                    shape.queryLineConnector(ivertexCutter, lineCutter);
                    segmentCutter = lineCutter;
                }
                tangent0.setCoords(segmentCutter._getTangent(1.0));
                segmentCutter = shape.getSegment(ivertexCutterPlus);
                if (segmentCutter == null) {
                    shape.queryLineConnector(ivertexCutterPlus, lineCutter);
                    segmentCutter = lineCutter;
                }
                tangent1.setCoords(segmentCutter._getTangent(0.0));
                tangent0.negate();
                tangent1.normalize();
                tangent0.normalize();
                return false;
            }
            return true;
        }
        if (icutEvent == cutEvents.size() - 1 || ivertexCutteeNext != ivertexCuttee || ipartCutterNext != ipartCutter || ivertexCutterNext != ivertexCutterPlus || countNext == 2) {
            Segment segmentCutter = shape.getSegment(ivertexCutter);
            if (segmentCutter == null) {
                shape.queryLineConnector(ivertexCutter, lineCutter);
                segmentCutter = lineCutter;
            }
            tangent1.setCoords(segmentCutter._getTangent(1.0));
            tangent0.negate(tangent1);
            tangent1.normalize();
            tangent0.normalize();
            return false;
        }
        Segment segmentCutter = shape.getSegment(ivertexCutter);
        if (segmentCutter == null) {
            shape.queryLineConnector(ivertexCutter, lineCutter);
            segmentCutter = lineCutter;
        }
        tangent0.setCoords(segmentCutter._getTangent(1.0));
        segmentCutter = shape.getSegment(ivertexCutterPlus);
        if (segmentCutter == null) {
            shape.queryLineConnector(ivertexCutterPlus, lineCutter);
            segmentCutter = lineCutter;
        }
        tangent1.setCoords(segmentCutter._getTangent(0.0));
        tangent0.negate();
        tangent1.normalize();
        tangent0.normalize();
        return false;
    }

    static boolean _cutterStartTangents(boolean bConsiderTouch, EditShape shape, ArrayList<CutEvent> cutEvents, int icutEvent, Point2D tangent0, Point2D tangent1) {
        Line lineCutter = new Line();
        int ivertexCuttee = cutEvents.get((int)icutEvent).m_ivertexCuttee;
        int ipartCutter = cutEvents.get((int)icutEvent).m_ipartCutter;
        int ivertexCutter = cutEvents.get((int)icutEvent).m_ivertexCutter;
        int ivertexCutteeNext = -1;
        int ipartCutterNext = -1;
        int ivertexCutterNext = -1;
        int countNext = -1;
        if (!bConsiderTouch && icutEvent < cutEvents.size() - 1) {
            CutEvent cutEvent = cutEvents.get(icutEvent + 1);
            ivertexCutteeNext = cutEvent.m_ivertexCuttee;
            ipartCutterNext = cutEvent.m_ipartCutter;
            ivertexCutterNext = cutEvent.m_ivertexCutter;
            countNext = cutEvent.m_count;
        }
        int ivertexCutteePrev = -1;
        int ipartCutterPrev = -1;
        int ivertexCutterPrev = -1;
        int countPrev = -1;
        if (icutEvent > 0) {
            CutEvent cutEvent = cutEvents.get(icutEvent - 1);
            ivertexCutteePrev = cutEvent.m_ivertexCuttee;
            ipartCutterPrev = cutEvent.m_ipartCutter;
            ivertexCutterPrev = cutEvent.m_ivertexCutter;
            countPrev = cutEvent.m_count;
        }
        int ivertexCutteePlus = shape.getNextVertex(ivertexCuttee);
        int ivertexCutterMinus = shape.getPrevVertex(ivertexCutter);
        if (!bConsiderTouch) {
            if (icutEvent > 0 && ivertexCutteePrev == ivertexCuttee && ipartCutterPrev == ipartCutter && ivertexCutterPrev == ivertexCutterMinus && countPrev == 2 || icutEvent < cutEvents.size() - 1 && ivertexCutteeNext == ivertexCutteePlus && ipartCutterNext == ipartCutter && ivertexCutterNext == ivertexCutterMinus && countNext == 2) {
                Segment segmentCutter = shape.getSegment(ivertexCutter);
                if (segmentCutter == null) {
                    shape.queryLineConnector(ivertexCutter, lineCutter);
                    segmentCutter = lineCutter;
                }
                tangent1.setCoords(segmentCutter._getTangent(0.0));
                tangent0.negate(tangent1);
                tangent1.normalize();
                tangent0.normalize();
                return false;
            }
            return true;
        }
        if (icutEvent == 0 || ivertexCutteePrev != ivertexCuttee || ipartCutterPrev != ipartCutter || ivertexCutterPrev != ivertexCutterMinus || countPrev == 2) {
            Segment segmentCutter = shape.getSegment(ivertexCutter);
            if (segmentCutter == null) {
                shape.queryLineConnector(ivertexCutter, lineCutter);
                segmentCutter = lineCutter;
            }
            tangent1.setCoords(segmentCutter._getTangent(0.0));
            tangent0.negate(tangent1);
            tangent1.normalize();
            tangent0.normalize();
            return false;
        }
        return true;
    }

    static boolean _cutteeTangents(EditShape shape, ArrayList<CutEvent> cutEvents, int icutEvent, int ipath, int ivertex, Point2D tangent2, Point2D tangent3) {
        Line lineCuttee = new Line();
        Segment segmentCuttee = shape.getSegment(ivertex);
        if (segmentCuttee == null) {
            shape.queryLineConnector(ivertex, lineCuttee);
            segmentCuttee = lineCuttee;
        }
        CutEvent cutEvent = cutEvents.get(icutEvent);
        int ivertexCuttee = cutEvent.m_ivertexCuttee;
        double scalarCuttee = cutEvent.m_scalarCuttee0;
        int ivertexCutteePlus = shape.getNextVertex(ivertexCuttee);
        if (scalarCuttee == 1.0) {
            tangent2.setCoords(segmentCuttee._getTangent(1.0));
            if (ivertexCutteePlus != -1 && ivertexCutteePlus != shape.getLastVertex(ipath)) {
                segmentCuttee = shape.getSegment(ivertexCutteePlus);
                if (segmentCuttee == null) {
                    shape.queryLineConnector(ivertexCutteePlus, lineCuttee);
                    segmentCuttee = lineCuttee;
                }
                tangent3.setCoords(segmentCuttee._getTangent(0.0));
                segmentCuttee = shape.getSegment(ivertexCuttee);
                if (segmentCuttee == null) {
                    shape.queryLineConnector(ivertexCuttee, lineCuttee);
                    segmentCuttee = lineCuttee;
                }
            } else {
                tangent3.setCoords(tangent2);
            }
            tangent2.negate();
            tangent3.normalize();
            tangent2.normalize();
            return false;
        }
        if (scalarCuttee == 0.0) {
            tangent3.setCoords(segmentCuttee._getTangent(scalarCuttee));
            tangent2.negate(tangent3);
            tangent3.normalize();
            tangent2.normalize();
            return false;
        }
        throw GeometryException.GeometryInternalError();
    }

    static class CutEvent {
        int m_ivertexCuttee;
        int m_ipartCuttee;
        double m_scalarCuttee0;
        double m_scalarCuttee1;
        int m_count;
        int m_ivertexCutter;
        int m_ipartCutter;
        double m_scalarCutter0;
        double m_scalarCutter1;

        CutEvent(int ivertexCuttee, int ipartCuttee, double scalarCuttee0, double scalarCuttee1, int count, int ivertexCutter, int ipartCutter, double scalarCutter0, double scalarCutter1) {
            this.m_ivertexCuttee = ivertexCuttee;
            this.m_ipartCuttee = ipartCuttee;
            this.m_scalarCuttee0 = scalarCuttee0;
            this.m_scalarCuttee1 = scalarCuttee1;
            this.m_count = count;
            this.m_ivertexCutter = ivertexCutter;
            this.m_ipartCutter = ipartCutter;
            this.m_scalarCutter0 = scalarCutter0;
            this.m_scalarCutter1 = scalarCutter1;
        }
    }

    static class CutterVertexComparer
    extends AttributeStreamOfInt32.IntComparator {
        CompareVertices m_compareVertices;

        CutterVertexComparer(CompareVertices _compareVertices) {
            this.m_compareVertices = _compareVertices;
        }

        @Override
        public int compare(int v1, int v2) {
            return this.m_compareVertices._compareVertices(v1, v2);
        }
    }

    static class CompareVertices {
        int m_orderIndex;
        EditShape m_editShape;

        CompareVertices(int orderIndex, EditShape editShape) {
            this.m_orderIndex = orderIndex;
            this.m_editShape = editShape;
        }

        int _compareVertices(int v1, int v2) {
            int z2;
            Point2D pt1 = new Point2D();
            this.m_editShape.getXY(v1, pt1);
            Point2D pt2 = new Point2D();
            this.m_editShape.getXY(v2, pt2);
            int res = pt1.compare(pt2);
            if (res != 0) {
                return res;
            }
            int z1 = this.m_editShape.getUserIndex(v1, this.m_orderIndex);
            if (z1 < (z2 = this.m_editShape.getUserIndex(v2, this.m_orderIndex))) {
                return -1;
            }
            if (z1 == z2) {
                return 0;
            }
            return 1;
        }
    }
}

