/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.RasterizedGeometry2DImpl;

abstract class RasterizedGeometry2D {
    RasterizedGeometry2D() {
    }

    public abstract HitType queryPointInGeometry(double var1, double var3);

    public abstract HitType queryEnvelopeInGeometry(Envelope2D var1);

    public static RasterizedGeometry2D create(Geometry geom, double toleranceXY, int rasterSizeBytes) {
        if (!RasterizedGeometry2D.canUseAccelerator(geom)) {
            throw new IllegalArgumentException();
        }
        RasterizedGeometry2DImpl gc = RasterizedGeometry2DImpl.createImpl(geom, toleranceXY, rasterSizeBytes);
        return gc;
    }

    public static RasterizedGeometry2D create(MultiVertexGeometryImpl geom, double toleranceXY, int rasterSizeBytes) {
        if (!RasterizedGeometry2D.canUseAccelerator(geom)) {
            throw new IllegalArgumentException();
        }
        RasterizedGeometry2DImpl gc = RasterizedGeometry2DImpl.createImpl(geom, toleranceXY, rasterSizeBytes);
        return gc;
    }

    public static int rasterSizeFromAccelerationDegree(Geometry.GeometryAccelerationDegree accelDegree) {
        int value = 0;
        switch (accelDegree) {
            case enumMild: {
                value = 1024;
                break;
            }
            case enumMedium: {
                value = 16384;
                break;
            }
            case enumHot: {
                value = 262144;
                break;
            }
            default: {
                throw new GeometryException("internal error");
            }
        }
        return value;
    }

    static boolean canUseAccelerator(Geometry geom) {
        return !geom.isEmpty() && (geom.getType() == Geometry.Type.Polyline || geom.getType() == Geometry.Type.Polygon);
    }

    abstract double getToleranceXY();

    abstract int getRasterSize();

    abstract boolean dbgSaveToBitmap(String var1);

    public static enum HitType {
        Outside(0),
        Inside(1),
        Border(2);

        private int enumVal;

        private HitType(int val) {
            this.enumVal = val;
        }
    }
}

