/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.JsonCursor;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SpatialReference;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;

class OperatorExportToGeoJsonCursor
extends JsonCursor {
    GeometryCursor m_inputGeometryCursor;
    int m_index = -1;
    int m_wkid = -1;
    int m_latest_wkid = -1;
    String m_wkt = null;
    private static JsonFactory factory = new JsonFactory();

    public OperatorExportToGeoJsonCursor(SpatialReference spatialReference, GeometryCursor geometryCursor) {
        if (geometryCursor == null) {
            throw new IllegalArgumentException();
        }
        if (spatialReference != null && !spatialReference.isLocal()) {
            this.m_wkid = spatialReference.getOldID();
            this.m_wkt = spatialReference.getText();
            this.m_latest_wkid = spatialReference.getLatestID();
        }
        this.m_inputGeometryCursor = geometryCursor;
    }

    public OperatorExportToGeoJsonCursor(GeometryCursor geometryCursor) {
        if (geometryCursor == null) {
            throw new IllegalArgumentException();
        }
        this.m_inputGeometryCursor = geometryCursor;
    }

    @Override
    public int getID() {
        return this.m_index;
    }

    @Override
    public String next() {
        Geometry geometry = this.m_inputGeometryCursor.next();
        if (geometry != null) {
            this.m_index = this.m_inputGeometryCursor.getGeometryID();
            return this.exportToGeoJson(geometry);
        }
        return null;
    }

    private String exportToGeoJson(Geometry geometry) {
        StringWriter sw = new StringWriter();
        try {
            JsonGenerator g = factory.createJsonGenerator((Writer)sw);
            int type = geometry.getType().value();
            switch (type) {
                case 33: {
                    this.exportPointToGeoJson(g, (Point)geometry);
                    break;
                }
                case 550: {
                    this.exportMultiPointToGeoJson(g, (MultiPoint)geometry);
                    break;
                }
                case 1607: {
                    this.exportPolylineToGeoJson(g, (Polyline)geometry);
                    break;
                }
                case 1736: {
                    this.exportPolygonToGeoJson(g, (Polygon)geometry);
                    break;
                }
                case 197: {
                    this.exportEnvelopeToGeoJson(g, (Envelope)geometry);
                    break;
                }
                default: {
                    throw new RuntimeException("not implemented for this geometry type");
                }
            }
            return sw.getBuffer().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void exportPointToGeoJson(JsonGenerator g, Point p) throws JsonGenerationException, IOException {
        g.writeStartObject();
        g.writeFieldName("type");
        g.writeString("Point");
        g.writeFieldName("coordinates");
        if (p.isEmpty()) {
            g.writeNull();
        } else {
            g.writeStartArray();
            this.writeDouble(p.getX(), g);
            this.writeDouble(p.getY(), g);
            if (p.hasAttribute(1)) {
                this.writeDouble(p.getZ(), g);
            }
            g.writeEndArray();
        }
        g.writeEndObject();
        g.close();
    }

    private void exportMultiPointToGeoJson(JsonGenerator g, MultiPoint mp) throws JsonGenerationException, IOException {
        g.writeStartObject();
        g.writeFieldName("type");
        g.writeString("MultiPoint");
        g.writeFieldName("coordinates");
        if (mp.isEmpty()) {
            g.writeNull();
        } else {
            g.writeStartArray();
            MultiPointImpl mpImpl = (MultiPointImpl)mp._getImpl();
            AttributeStreamOfDbl zs = mp.hasAttribute(1) ? (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(1) : null;
            Point2D p = new Point2D();
            int n = mp.getPointCount();
            for (int i = 0; i < n; ++i) {
                mp.getXY(i, p);
                g.writeStartArray();
                this.writeDouble(p.x, g);
                this.writeDouble(p.y, g);
                if (zs != null) {
                    this.writeDouble(zs.get(i), g);
                }
                g.writeEndArray();
            }
            g.writeEndArray();
        }
        g.writeEndObject();
        g.close();
    }

    private void exportPolylineToGeoJson(JsonGenerator g, Polyline p) throws JsonGenerationException, IOException {
        g.writeStartObject();
        g.writeFieldName("type");
        g.writeString("LineString");
        g.writeFieldName("coordinates");
        if (p.isEmpty()) {
            g.writeNull();
        } else {
            g.writeStartArray();
            this.exportPathToGeoJson(g, p);
            g.writeEndArray();
        }
        g.writeEndObject();
        g.close();
    }

    private void exportPolygonToGeoJson(JsonGenerator g, Polygon p) throws JsonGenerationException, IOException {
        MultiPathImpl pImpl = (MultiPathImpl)p._getImpl();
        int polyCount = pImpl.getOGCPolygonCount();
        g.writeStartObject();
        g.writeFieldName("type");
        if (polyCount >= 2) {
            g.writeString("MultiPolygon");
        } else {
            g.writeString("Polygon");
        }
        g.writeFieldName("coordinates");
        if (p.isEmpty()) {
            g.writeNull();
        } else {
            g.writeStartArray();
            if (polyCount >= 2) {
                g.writeStartArray();
                this.exportMultiPolygonToGeoJson(g, p, pImpl);
                g.writeEndArray();
            } else {
                this.exportPathToGeoJson(g, p);
            }
            g.writeEndArray();
        }
        g.writeEndObject();
        g.close();
    }

    private void exportMultiPolygonToGeoJson(JsonGenerator g, Polygon p, MultiPathImpl pImpl) throws IOException {
        int pathCount = pImpl.getPathCount();
        AttributeStreamOfDbl zs = p.hasAttribute(1) ? (AttributeStreamOfDbl)pImpl.getAttributeStreamRef(1) : null;
        Point2D pt = new Point2D();
        g.writeStartArray();
        int startIndex = p.getPathStart(0);
        int vertices = p.getPathSize(0);
        for (int i = startIndex; i < startIndex + vertices; ++i) {
            p.getXY(i, pt);
            g.writeStartArray();
            this.writeDouble(pt.x, g);
            this.writeDouble(pt.y, g);
            if (zs != null) {
                this.writeDouble(zs.get(i), g);
            }
            g.writeEndArray();
        }
        p.getXY(startIndex, pt);
        g.writeStartArray();
        this.writeDouble(pt.x, g);
        this.writeDouble(pt.y, g);
        if (zs != null) {
            this.writeDouble(zs.get(startIndex), g);
        }
        g.writeEndArray();
        g.writeEndArray();
        for (int path = 1; path < pathCount; ++path) {
            boolean isExtRing = p.isExteriorRing(path);
            startIndex = p.getPathStart(path);
            vertices = p.getPathSize(path);
            this.writePath(p, g, startIndex, vertices, zs, isExtRing);
        }
    }

    private void closePolygon(MultiPath mp, JsonGenerator g, int startIndex, AttributeStreamOfDbl zs) throws IOException {
        Point2D pt = new Point2D();
        mp.getXY(startIndex, pt);
        g.writeStartArray();
        this.writeDouble(pt.x, g);
        this.writeDouble(pt.y, g);
        if (zs != null) {
            this.writeDouble(zs.get(startIndex), g);
        }
        g.writeEndArray();
    }

    private void writePath(MultiPath mp, JsonGenerator g, int startIndex, int vertices, AttributeStreamOfDbl zs, boolean isExtRing) throws IOException {
        Point2D pt = new Point2D();
        boolean isPoly = mp instanceof Polygon;
        if (isPoly && isExtRing) {
            g.writeEndArray();
            g.writeStartArray();
        }
        g.writeStartArray();
        for (int i = startIndex; i < startIndex + vertices; ++i) {
            mp.getXY(i, pt);
            g.writeStartArray();
            this.writeDouble(pt.x, g);
            this.writeDouble(pt.y, g);
            if (zs != null) {
                this.writeDouble(zs.get(i), g);
            }
            g.writeEndArray();
        }
        if (isPoly) {
            this.closePolygon(mp, g, startIndex, zs);
        }
        g.writeEndArray();
    }

    private void exportPathToGeoJson(JsonGenerator g, MultiPath mp) throws JsonGenerationException, IOException {
        boolean isPoly = mp instanceof Polygon;
        MultiPathImpl mpImpl = (MultiPathImpl)mp._getImpl();
        AttributeStreamOfDbl zs = mp.hasAttribute(1) ? (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(1) : null;
        Point2D p = new Point2D();
        int n = mp.getPathCount();
        for (int i = 0; i < n; ++i) {
            if (isPoly) {
                g.writeStartArray();
            }
            int startIndex = mp.getPathStart(i);
            int vertices = mp.getPathSize(i);
            for (int j = startIndex; j < startIndex + vertices; ++j) {
                mp.getXY(j, p);
                g.writeStartArray();
                this.writeDouble(p.x, g);
                this.writeDouble(p.y, g);
                if (zs != null) {
                    this.writeDouble(zs.get(j), g);
                }
                g.writeEndArray();
            }
            if (isPoly) {
                mp.getXY(startIndex, p);
                g.writeStartArray();
                this.writeDouble(p.x, g);
                this.writeDouble(p.y, g);
                if (zs != null) {
                    this.writeDouble(zs.get(startIndex), g);
                }
                g.writeEndArray();
            }
            if (!isPoly) continue;
            g.writeEndArray();
        }
    }

    private void exportEnvelopeToGeoJson(JsonGenerator g, Envelope e) throws JsonGenerationException, IOException {
        boolean empty = e.isEmpty();
        g.writeStartObject();
        g.writeFieldName("bbox");
        if (empty) {
            g.writeNull();
        } else {
            g.writeStartArray();
            this.writeDouble(e.getXMin(), g);
            this.writeDouble(e.getYMin(), g);
            this.writeDouble(e.getXMax(), g);
            this.writeDouble(e.getYMax(), g);
            g.writeEndArray();
        }
        g.writeEndObject();
        g.close();
    }

    private void writeDouble(double d, JsonGenerator g) throws IOException, JsonGenerationException {
        if (NumberUtils.isNaN(d)) {
            g.writeNull();
        } else {
            g.writeNumber(d);
        }
    }
}

