/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Envelope3D;
import com.esri.core.geometry.GeometrySerializer;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Transformation3D;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;
import java.io.ObjectStreamException;
import java.io.Serializable;

public abstract class Geometry
implements Serializable {
    private static final long serialVersionUID = 2L;
    VertexDescription m_description = null;
    volatile int m_touchFlag = 0;

    Geometry() {
    }

    public abstract Type getType();

    public abstract int getDimension();

    public VertexDescription getDescription() {
        return this.m_description;
    }

    void assignVertexDescription(VertexDescription src) {
        this._touch();
        if (src == this.m_description) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            if (!this.m_description.hasAttribute(i) || src.hasAttribute(i)) continue;
            this._beforeDropAttributeImpl(i);
        }
        VertexDescription olddescription = this.m_description;
        this.m_description = src;
        for (int i = 0; i < 10; ++i) {
            if (olddescription.hasAttribute(i) || !src.hasAttribute(i)) continue;
            this._afterAddAttributeImpl(i);
        }
    }

    void mergeVertexDescription(VertexDescription src) {
        this._touch();
        if (src == this.m_description) {
            return;
        }
        boolean bNeedAction = false;
        VertexDescriptionDesignerImpl vdd = null;
        for (int i = 0; i < 10; ++i) {
            if (this.m_description.hasAttribute(i) || !src.hasAttribute(i)) continue;
            if (!bNeedAction) {
                bNeedAction = true;
                vdd = new VertexDescriptionDesignerImpl(this.m_description);
            }
            vdd.addAttribute(i);
        }
        if (!bNeedAction) {
            return;
        }
        VertexDescription olddescription = this.m_description;
        this.m_description = vdd.getDescription();
        for (int i = 0; i < 10; ++i) {
            if (olddescription.hasAttribute(i) || !this.m_description.hasAttribute(i)) continue;
            this._afterAddAttributeImpl(i);
        }
    }

    public boolean hasAttribute(int semantics) {
        return this.getDescription().hasAttribute(semantics);
    }

    public void addAttribute(int semantics) {
        this._touch();
        if (this.m_description.hasAttribute(semantics)) {
            return;
        }
        VertexDescriptionDesignerImpl vdd = new VertexDescriptionDesignerImpl(this.m_description);
        vdd.addAttribute(semantics);
        this.m_description = vdd.getDescription();
        this._afterAddAttributeImpl(semantics);
    }

    public void dropAttribute(int semantics) {
        this._touch();
        if (!this.m_description.hasAttribute(semantics)) {
            return;
        }
        VertexDescriptionDesignerImpl vdd = new VertexDescriptionDesignerImpl(this.m_description);
        vdd.removeAttribute(semantics);
        this._beforeDropAttributeImpl(semantics);
        this.m_description = vdd.getDescription();
    }

    public void dropAllAttributes() {
        this.assignVertexDescription(VertexDescriptionDesignerImpl.getDefaultDescriptor2D());
    }

    public abstract Envelope1D queryInterval(int var1, int var2);

    public abstract void queryEnvelope(Envelope var1);

    public abstract void queryEnvelope2D(Envelope2D var1);

    abstract void queryEnvelope3D(Envelope3D var1);

    public void queryLooseEnvelope2D(Envelope2D env) {
        this.queryEnvelope2D(env);
    }

    void queryLooseEnvelope3D(Envelope3D env) {
        this.queryEnvelope3D(env);
    }

    public abstract boolean isEmpty();

    public abstract void setEmpty();

    public abstract void applyTransformation(Transformation2D var1);

    abstract void applyTransformation(Transformation3D var1);

    public abstract Geometry createInstance();

    public abstract void copyTo(Geometry var1);

    public double calculateArea2D() {
        return 0.0;
    }

    public double calculateLength2D() {
        return 0.0;
    }

    abstract void _beforeDropAttributeImpl(int var1);

    abstract void _afterAddAttributeImpl(int var1);

    protected Object _getImpl() {
        throw new RuntimeException("invalid call");
    }

    void addZ() {
        this.addAttribute(1);
    }

    public boolean hasZ() {
        return this.hasAttribute(1);
    }

    public void addM() {
        this.addAttribute(2);
    }

    public boolean hasM() {
        return this.hasAttribute(2);
    }

    public void addID() {
        this.addAttribute(3);
    }

    public boolean hasID() {
        return this.hasAttribute(3);
    }

    public static int getDimensionFromType(int type) {
        return ((type & 0xC0) >> 6) + 1 >> 1;
    }

    public static boolean isPoint(int type) {
        return (type & 0x20) != 0;
    }

    public static boolean isLinear(int type) {
        return (type & 0x40) != 0;
    }

    public static boolean isArea(int type) {
        return (type & 0x80) != 0;
    }

    public static boolean isSegment(int type) {
        return (type & 0x100) != 0;
    }

    public static boolean isMultiVertex(int type) {
        return (type & 0x200) != 0;
    }

    public static boolean isMultiPath(int type) {
        return (type & 0x400) != 0;
    }

    public Geometry copy() {
        Geometry geom = this.createInstance();
        this.copyTo(geom);
        return geom;
    }

    static Geometry _clone(Geometry src) {
        Geometry geom = src.createInstance();
        src.copyTo(geom);
        return geom;
    }

    public int getStateFlag() {
        this.m_touchFlag &= Integer.MAX_VALUE;
        return this.m_touchFlag;
    }

    synchronized void _touch() {
        if (this.m_touchFlag >= 0) {
            this.m_touchFlag += -2147483647;
        }
    }

    Object writeReplace() throws ObjectStreamException {
        GeometrySerializer geomSerializer = new GeometrySerializer();
        geomSerializer.setGeometryByValue(this);
        return geomSerializer;
    }

    public static enum GeometryAccelerationDegree {
        enumMild,
        enumMedium,
        enumHot;

    }

    public static enum Type {
        Unknown(0),
        Point(33),
        Line(322),
        Envelope(197),
        MultiPoint(550),
        Polyline(1607),
        Polygon(1736);

        private int enumValue;

        public int value() {
            return this.enumValue;
        }

        private Type(int val) {
            this.enumValue = val;
        }
    }

    static interface GeometryType {
        public static final int Unknown = 0;
        public static final int Point = 33;
        public static final int Line = 322;
        public static final int Bezier = 323;
        public static final int EllipticArc = 324;
        public static final int Envelope = 197;
        public static final int MultiPoint = 550;
        public static final int Polyline = 1607;
        public static final int Polygon = 1736;
    }
}

