/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.BucketSort;
import com.esri.core.geometry.ClassicSort;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.Segment;

class Boundary {
    Boundary() {
    }

    static Geometry calculate(Geometry geom, ProgressTracker progress_tracker) {
        int gt = geom.getType().value();
        if (gt == 1736) {
            Polyline dst = new Polyline(geom.getDescription());
            if (!geom.isEmpty()) {
                ((MultiPathImpl)geom._getImpl())._copyToUnsafe((MultiPathImpl)dst._getImpl());
            }
            return dst;
        }
        if (gt == 1607) {
            return Boundary.calculatePolylineBoundary_(geom._getImpl(), progress_tracker);
        }
        if (gt == 197) {
            Polyline dst = new Polyline(geom.getDescription());
            if (!geom.isEmpty()) {
                dst.addEnvelope((Envelope)geom, false);
            }
            return dst;
        }
        if (Geometry.isSegment(gt)) {
            MultiPoint mp = new MultiPoint(geom.getDescription());
            if (!geom.isEmpty() && !((Segment)geom).isClosed()) {
                Point pt = new Point();
                ((Segment)geom).queryStart(pt);
                mp.add(pt);
                ((Segment)geom).queryEnd(pt);
                mp.add(pt);
            }
            return mp;
        }
        if (Geometry.isPoint(gt)) {
            return null;
        }
        throw new IllegalArgumentException();
    }

    static MultiPoint calculatePolylineBoundary_(Object impl, ProgressTracker progress_tracker) {
        MultiPathImpl mpImpl = (MultiPathImpl)impl;
        MultiPoint dst = new MultiPoint(mpImpl.getDescription());
        if (!mpImpl.isEmpty()) {
            AttributeStreamOfInt32 indices = new AttributeStreamOfInt32(0);
            indices.reserve(mpImpl.getPathCount() * 2);
            int nPathCount = mpImpl.getPathCount();
            for (int ipath = 0; ipath < nPathCount; ++ipath) {
                int path_size = mpImpl.getPathSize(ipath);
                if (path_size <= 0 || mpImpl.isClosedPathInXYPlane(ipath)) continue;
                int start = mpImpl.getPathStart(ipath);
                indices.add(start);
                int end = mpImpl.getPathEnd(ipath) - 1;
                indices.add(end);
            }
            if (indices.size() > 0) {
                int i;
                BucketSort sorter = new BucketSort();
                AttributeStreamOfDbl xy = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(0);
                sorter.sort(indices, 0, indices.size(), new MultiPathImplBoundarySorter(xy));
                Point2D ptPrev = new Point2D();
                xy.read(2 * indices.get(0), ptPrev);
                int ind = 0;
                int counter = 1;
                Point point = new Point();
                Point2D pt = new Point2D();
                int n = indices.size();
                for (i = 1; i < n; ++i) {
                    xy.read(2 * indices.get(i), pt);
                    if (pt.isEqual(ptPrev)) {
                        if (indices.get(ind) > indices.get(i)) {
                            indices.set(ind, NumberUtils.intMax());
                            ind = i;
                        } else {
                            indices.set(i, NumberUtils.intMax());
                        }
                        ++counter;
                        continue;
                    }
                    if (!(counter & true)) {
                        indices.set(ind, NumberUtils.intMax());
                    }
                    ptPrev.setCoords(pt);
                    ind = i;
                    counter = 1;
                }
                if (!(counter & true)) {
                    indices.set(ind, NumberUtils.intMax());
                }
                indices.sort(0, indices.size());
                n = indices.size();
                for (i = 0; i < n && indices.get(i) != NumberUtils.intMax(); ++i) {
                    mpImpl.getPointByVal(indices.get(i), point);
                    dst.add(point);
                }
            }
        }
        return dst;
    }

    private static final class MultiPathImplBoundarySorter
    extends ClassicSort {
        AttributeStreamOfDbl m_xy;

        MultiPathImplBoundarySorter(AttributeStreamOfDbl xy) {
            this.m_xy = xy;
        }

        @Override
        public void userSort(int begin, int end, AttributeStreamOfInt32 indices) {
            indices.Sort(begin, end, new CompareIndices(this.m_xy));
        }

        @Override
        public double getValue(int index) {
            return this.m_xy.read(2 * index + 1);
        }

        static final class CompareIndices
        extends AttributeStreamOfInt32.IntComparator {
            AttributeStreamOfDbl m_xy;
            Point2D pt1_helper;
            Point2D pt2_helper;

            CompareIndices(AttributeStreamOfDbl xy) {
                this.m_xy = xy;
                this.pt1_helper = new Point2D();
                this.pt2_helper = new Point2D();
            }

            @Override
            public int compare(int v1, int v2) {
                this.m_xy.read(2 * v1, this.pt1_helper);
                this.m_xy.read(2 * v2, this.pt2_helper);
                return this.pt1_helper.compare(this.pt2_helper);
            }
        }
    }
}

