/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry.ogc;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorExportToWkb;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCLineString;
import com.esri.core.geometry.ogc.OGCLinearRing;
import com.esri.core.geometry.ogc.OGCMultiCurve;
import com.esri.core.geometry.ogc.OGCSurface;
import java.nio.ByteBuffer;

public class OGCPolygon
extends OGCSurface {
    Polygon polygon;

    public OGCPolygon(Polygon src, int exteriorRing, SpatialReference sr) {
        this.polygon = new Polygon();
        int n = src.getPathCount();
        for (int i = exteriorRing; !(i >= n || i > exteriorRing && src.isExteriorRing(i)); ++i) {
            this.polygon.addPath(src, i, true);
        }
        this.esriSR = sr;
    }

    public OGCPolygon(Polygon geom, SpatialReference sr) {
        this.polygon = geom;
        if (geom.getExteriorRingCount() > 1) {
            throw new IllegalArgumentException("Polygon has to have one exterior ring");
        }
        this.esriSR = sr;
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 16);
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(16, this.getEsriGeometry(), null);
    }

    public OGCLineString exterorRing() {
        if (this.polygon.isEmpty()) {
            return new OGCLinearRing((Polygon)this.polygon.createInstance(), 0, this.esriSR, true);
        }
        return new OGCLinearRing(this.polygon, 0, this.esriSR, true);
    }

    public int numInteriorRing() {
        return this.polygon.getPathCount() - 1;
    }

    public OGCLineString interiorRingN(int n) {
        return new OGCLinearRing(this.polygon, n + 1, this.esriSR, true);
    }

    @Override
    public OGCMultiCurve boundary() {
        Polyline polyline = new Polyline();
        polyline.add(this.polygon, true);
        return (OGCMultiCurve)OGCGeometry.createFromEsriGeometry(polyline, this.esriSR, true);
    }

    @Override
    public String geometryType() {
        return "Polygon";
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.polygon;
    }
}

