/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.CrackAndCluster;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.PolygonUtils;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.RelationalOperations;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.Simplificator;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.TopoGraph;

class RelationalOperationsMatrix {
    private TopoGraph m_topo_graph = new TopoGraph();
    private int[] m_matrix = new int[9];
    private boolean[] m_perform_predicates = new boolean[9];
    private String m_scl;
    private int m_predicates;
    private int m_predicate_count = 0;
    private int m_cluster_index_a;
    private int m_cluster_index_b;
    private int m_visited_index;

    static boolean relate(Geometry geometry_a, Geometry geometry_b, SpatialReference sr, String scl, ProgressTracker progress_tracker) {
        int relation = RelationalOperationsMatrix.getPredefinedRelation_(scl, geometry_a.getDimension(), geometry_b.getDimension());
        if (relation != 0) {
            return RelationalOperations.relate(geometry_a, geometry_b, sr, relation, progress_tracker);
        }
        Envelope2D env1 = new Envelope2D();
        geometry_a.queryEnvelope2D(env1);
        Envelope2D env2 = new Envelope2D();
        geometry_b.queryEnvelope2D(env2);
        Envelope2D envMerged = new Envelope2D();
        envMerged.setCoords(env1);
        envMerged.merge(env2);
        double tolerance = InternalUtils.calculateToleranceFromGeometry(sr, envMerged, false);
        Geometry _geometryA = RelationalOperationsMatrix.convertGeometry_(geometry_a, tolerance);
        Geometry _geometryB = RelationalOperationsMatrix.convertGeometry_(geometry_b, tolerance);
        int typeA = _geometryA.getType().value();
        int typeB = _geometryB.getType().value();
        boolean bRelation = false;
        block0 : switch (typeA) {
            case 1736: {
                switch (typeB) {
                    case 1736: {
                        bRelation = RelationalOperationsMatrix.polygonRelatePolygon_((Polygon)_geometryA, (Polygon)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                    case 1607: {
                        bRelation = RelationalOperationsMatrix.polygonRelatePolyline_((Polygon)_geometryA, (Polyline)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                    case 33: {
                        bRelation = RelationalOperationsMatrix.polygonRelatePoint_((Polygon)_geometryA, (Point)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                    case 550: {
                        bRelation = RelationalOperationsMatrix.polygonRelateMultiPoint_((Polygon)_geometryA, (MultiPoint)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                }
                break;
            }
            case 1607: {
                switch (typeB) {
                    case 1736: {
                        bRelation = RelationalOperationsMatrix.polygonRelatePolyline_((Polygon)_geometryB, (Polyline)_geometryA, tolerance, RelationalOperationsMatrix.transposeMatrix_(scl), progress_tracker);
                        break block0;
                    }
                    case 1607: {
                        bRelation = RelationalOperationsMatrix.polylineRelatePolyline_((Polyline)_geometryA, (Polyline)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                    case 33: {
                        bRelation = RelationalOperationsMatrix.polylineRelatePoint_((Polyline)_geometryA, (Point)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                    case 550: {
                        bRelation = RelationalOperationsMatrix.polylineRelateMultiPoint_((Polyline)_geometryA, (MultiPoint)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                }
                break;
            }
            case 33: {
                switch (typeB) {
                    case 1736: {
                        bRelation = RelationalOperationsMatrix.polygonRelatePoint_((Polygon)_geometryB, (Point)_geometryA, tolerance, RelationalOperationsMatrix.transposeMatrix_(scl), progress_tracker);
                        break block0;
                    }
                    case 1607: {
                        bRelation = RelationalOperationsMatrix.polylineRelatePoint_((Polyline)_geometryB, (Point)_geometryA, tolerance, RelationalOperationsMatrix.transposeMatrix_(scl), progress_tracker);
                        break block0;
                    }
                    case 33: {
                        bRelation = RelationalOperationsMatrix.pointRelatePoint_((Point)_geometryA, (Point)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                    case 550: {
                        bRelation = RelationalOperationsMatrix.multiPointRelatePoint_((MultiPoint)_geometryB, (Point)_geometryA, tolerance, RelationalOperationsMatrix.transposeMatrix_(scl), progress_tracker);
                        break block0;
                    }
                }
                break;
            }
            case 550: {
                switch (typeB) {
                    case 1736: {
                        bRelation = RelationalOperationsMatrix.polygonRelateMultiPoint_((Polygon)_geometryB, (MultiPoint)_geometryA, tolerance, RelationalOperationsMatrix.transposeMatrix_(scl), progress_tracker);
                        break block0;
                    }
                    case 1607: {
                        bRelation = RelationalOperationsMatrix.polylineRelateMultiPoint_((Polyline)_geometryB, (MultiPoint)_geometryA, tolerance, RelationalOperationsMatrix.transposeMatrix_(scl), progress_tracker);
                        break block0;
                    }
                    case 550: {
                        bRelation = RelationalOperationsMatrix.multiPointRelateMultiPoint_((MultiPoint)_geometryA, (MultiPoint)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                    case 33: {
                        bRelation = RelationalOperationsMatrix.multiPointRelatePoint_((MultiPoint)_geometryA, (Point)_geometryB, tolerance, scl, progress_tracker);
                        break block0;
                    }
                }
                break;
            }
            default: {
                bRelation = false;
            }
        }
        return bRelation;
    }

    private RelationalOperationsMatrix() {
    }

    static boolean polygonRelatePolygon_(Polygon polygon_a, Polygon polygon_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_(scl);
        relOps.setAreaAreaPredicates_();
        EditShape edit_shape = new EditShape();
        int geom_a = edit_shape.addGeometry(polygon_a);
        int geom_b = edit_shape.addGeometry(polygon_b);
        relOps.setEditShapeCrackAndCluster_(edit_shape, tolerance, progress_tracker);
        relOps.computeMatrixTopoGraphHalfEdges_(geom_a, geom_b);
        relOps.m_topo_graph.removeShape();
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
        return bRelation;
    }

    static boolean polygonRelatePolyline_(Polygon polygon_a, Polyline polyline_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_(scl);
        relOps.setAreaLinePredicates_();
        EditShape edit_shape = new EditShape();
        int geom_a = edit_shape.addGeometry(polygon_a);
        int geom_b = edit_shape.addGeometry(polyline_b);
        relOps.setEditShapeCrackAndCluster_(edit_shape, tolerance, progress_tracker);
        relOps.m_cluster_index_b = relOps.m_topo_graph.createUserIndexForClusters();
        RelationalOperationsMatrix.markClusters_(geom_b, relOps.m_topo_graph, relOps.m_cluster_index_b);
        relOps.computeMatrixTopoGraphHalfEdges_(geom_a, geom_b);
        relOps.m_topo_graph.deleteUserIndexForClusters(relOps.m_cluster_index_b);
        relOps.m_topo_graph.removeShape();
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
        return bRelation;
    }

    static boolean polygonRelateMultiPoint_(Polygon polygon_a, MultiPoint multipoint_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_(scl);
        relOps.setAreaPointPredicates_();
        EditShape edit_shape = new EditShape();
        int geom_a = edit_shape.addGeometry(polygon_a);
        int geom_b = edit_shape.addGeometry(multipoint_b);
        relOps.setEditShapeCrackAndCluster_(edit_shape, tolerance, progress_tracker);
        relOps.computeMatrixTopoGraphClusters_(geom_a, geom_b);
        relOps.m_topo_graph.removeShape();
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
        return bRelation;
    }

    static boolean polylineRelatePolyline_(Polyline polyline_a, Polyline polyline_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_(scl);
        relOps.setLineLinePredicates_();
        EditShape edit_shape = new EditShape();
        int geom_a = edit_shape.addGeometry(polyline_a);
        int geom_b = edit_shape.addGeometry(polyline_b);
        relOps.setEditShapeCrackAndCluster_(edit_shape, tolerance, progress_tracker);
        relOps.m_cluster_index_a = relOps.m_topo_graph.createUserIndexForClusters();
        relOps.m_cluster_index_b = relOps.m_topo_graph.createUserIndexForClusters();
        RelationalOperationsMatrix.markClusters_(geom_a, relOps.m_topo_graph, relOps.m_cluster_index_a);
        RelationalOperationsMatrix.markClusters_(geom_b, relOps.m_topo_graph, relOps.m_cluster_index_b);
        relOps.computeMatrixTopoGraphHalfEdges_(geom_a, geom_b);
        relOps.m_topo_graph.deleteUserIndexForClusters(relOps.m_cluster_index_a);
        relOps.m_topo_graph.deleteUserIndexForClusters(relOps.m_cluster_index_b);
        relOps.m_topo_graph.removeShape();
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
        return bRelation;
    }

    static boolean polylineRelateMultiPoint_(Polyline polyline_a, MultiPoint multipoint_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_(scl);
        relOps.setLinePointPredicates_();
        EditShape edit_shape = new EditShape();
        int geom_a = edit_shape.addGeometry(polyline_a);
        int geom_b = edit_shape.addGeometry(multipoint_b);
        relOps.setEditShapeCrackAndCluster_(edit_shape, tolerance, progress_tracker);
        relOps.m_cluster_index_a = relOps.m_topo_graph.createUserIndexForClusters();
        RelationalOperationsMatrix.markClusters_(geom_a, relOps.m_topo_graph, relOps.m_cluster_index_a);
        relOps.computeMatrixTopoGraphClusters_(geom_a, geom_b);
        relOps.m_topo_graph.deleteUserIndexForClusters(relOps.m_cluster_index_a);
        relOps.m_topo_graph.removeShape();
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
        return bRelation;
    }

    static boolean multiPointRelateMultiPoint_(MultiPoint multipoint_a, MultiPoint multipoint_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_(scl);
        relOps.setPointPointPredicates_();
        EditShape edit_shape = new EditShape();
        int geom_a = edit_shape.addGeometry(multipoint_a);
        int geom_b = edit_shape.addGeometry(multipoint_b);
        relOps.setEditShapeCrackAndCluster_(edit_shape, tolerance, progress_tracker);
        relOps.computeMatrixTopoGraphClusters_(geom_a, geom_b);
        relOps.m_topo_graph.removeShape();
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
        return bRelation;
    }

    static boolean polygonRelatePoint_(Polygon polygon_a, Point point_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        Point2D pt_b = point_b.getXY();
        int[] matrix = new int[9];
        for (int i = 0; i < 8; ++i) {
            matrix[i] = -1;
        }
        PolygonUtils.PiPResult res = PolygonUtils.isPointInPolygon2D(polygon_a, pt_b, tolerance);
        if (res == PolygonUtils.PiPResult.PiPInside) {
            matrix[0] = 0;
        } else if (res == PolygonUtils.PiPResult.PiPBoundary) {
            matrix[3] = 0;
        } else {
            matrix[6] = 0;
        }
        matrix[2] = 2;
        matrix[5] = 1;
        matrix[8] = 2;
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(matrix, scl);
        return bRelation;
    }

    static boolean polylineRelatePoint_(Polyline polyline_a, Point point_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        RelationalOperationsMatrix relOps = new RelationalOperationsMatrix();
        relOps.resetMatrix_();
        relOps.setPredicates_(scl);
        relOps.setLinePointPredicates_();
        MultiPoint multipoint_b = new MultiPoint();
        multipoint_b.add(point_b);
        EditShape edit_shape = new EditShape();
        int geom_a = edit_shape.addGeometry(polyline_a);
        int geom_b = edit_shape.addGeometry(multipoint_b);
        relOps.setEditShapeCrackAndCluster_(edit_shape, tolerance, progress_tracker);
        relOps.m_cluster_index_a = relOps.m_topo_graph.createUserIndexForClusters();
        RelationalOperationsMatrix.markClusters_(geom_a, relOps.m_topo_graph, relOps.m_cluster_index_a);
        relOps.computeMatrixTopoGraphClusters_(geom_a, geom_b);
        relOps.m_topo_graph.deleteUserIndexForClusters(relOps.m_cluster_index_a);
        relOps.m_topo_graph.removeShape();
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(relOps.m_matrix, relOps.m_scl);
        return bRelation;
    }

    static boolean multiPointRelatePoint_(MultiPoint multipoint_a, Point point_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        Point2D pt_b = point_b.getXY();
        int[] matrix = new int[9];
        for (int i = 0; i < 8; ++i) {
            matrix[i] = -1;
        }
        boolean b_intersects = false;
        boolean b_multipoint_contained = true;
        double tolerance_sq = tolerance * tolerance;
        Point2D pt_a = new Point2D();
        for (int i = 0; i < multipoint_a.getPointCount(); ++i) {
            multipoint_a.getXY(i, pt_a);
            if (Point2D.sqrDistance(pt_a, pt_b) <= tolerance_sq) {
                b_intersects = true;
            } else {
                b_multipoint_contained = false;
            }
            if (b_intersects && !b_multipoint_contained) break;
        }
        if (b_intersects) {
            matrix[0] = 0;
            if (!b_multipoint_contained) {
                matrix[2] = 0;
            }
        } else {
            matrix[2] = 0;
            matrix[6] = 0;
        }
        matrix[8] = 2;
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(matrix, scl);
        return bRelation;
    }

    static boolean pointRelatePoint_(Point point_a, Point point_b, double tolerance, String scl, ProgressTracker progress_tracker) {
        Point2D pt_a = point_a.getXY();
        Point2D pt_b = point_b.getXY();
        int[] matrix = new int[9];
        for (int i = 1; i < 8; ++i) {
            matrix[i] = -1;
        }
        if (Point2D.sqrDistance(pt_a, pt_b) <= tolerance * tolerance) {
            matrix[0] = 0;
        } else {
            matrix[2] = 0;
            matrix[6] = 0;
        }
        matrix[8] = 2;
        boolean bRelation = RelationalOperationsMatrix.relationCompare_(matrix, scl);
        return bRelation;
    }

    private static boolean relationCompare_(int[] matrix, String scl) {
        block7: for (int i = 0; i < 9; ++i) {
            switch (scl.charAt(i)) {
                case 'T': {
                    assert (matrix[i] != -2);
                    if (matrix[i] != -1) continue block7;
                    return false;
                }
                case 'F': {
                    assert (matrix[i] != -2);
                    if (matrix[i] == -1) continue block7;
                    return false;
                }
                case '0': {
                    assert (matrix[i] != -2);
                    if (matrix[i] == 0) continue block7;
                    return false;
                }
                case '1': {
                    assert (matrix[i] != -2);
                    if (matrix[i] == 1) continue block7;
                    return false;
                }
                case '2': {
                    assert (matrix[i] != -2);
                    if (matrix[i] == 2) continue block7;
                    return false;
                }
            }
        }
        return true;
    }

    private static int getPredefinedRelation_(String scl, int dim_a, int dim_b) {
        if (RelationalOperationsMatrix.equals_(scl)) {
            return 3;
        }
        if (RelationalOperationsMatrix.disjoint_(scl)) {
            return 4;
        }
        if (RelationalOperationsMatrix.touches_(scl, dim_a, dim_b)) {
            return 8;
        }
        if (RelationalOperationsMatrix.crosses_(scl, dim_a, dim_b)) {
            return 16;
        }
        if (RelationalOperationsMatrix.contains_(scl)) {
            return 1;
        }
        if (RelationalOperationsMatrix.overlaps_(scl, dim_a, dim_b)) {
            return 32;
        }
        return 0;
    }

    private static boolean equals_(String scl) {
        return scl.charAt(0) == 'T' && scl.charAt(1) == '*' && scl.charAt(2) == 'F' && scl.charAt(3) == '*' && scl.charAt(4) == '*' && scl.charAt(5) == 'F' && scl.charAt(6) == 'F' && scl.charAt(7) == 'F' && scl.charAt(8) == '*';
    }

    private static boolean disjoint_(String scl) {
        return scl.charAt(0) == 'F' && scl.charAt(1) == 'F' && scl.charAt(2) == '*' && scl.charAt(3) == 'F' && scl.charAt(4) == 'F' && scl.charAt(5) == '*' && scl.charAt(6) == '*' && scl.charAt(7) == '*' && scl.charAt(8) == '*';
    }

    private static boolean touches_(String scl, int dim_a, int dim_b) {
        if (dim_a == 0 && dim_b == 0) {
            return false;
        }
        if (dim_a != 2 || dim_b != 2) {
            if (scl.charAt(0) == 'F' && scl.charAt(1) == '*' && scl.charAt(2) == '*' && scl.charAt(3) == 'T' && scl.charAt(4) == '*' && scl.charAt(5) == '*' && scl.charAt(6) == '*' && scl.charAt(7) == '*' && scl.charAt(8) == '*') {
                return true;
            }
            if (dim_a == 1 && dim_b == 1 && scl.charAt(0) == 'F' && scl.charAt(1) == 'T' && scl.charAt(2) == '*' && scl.charAt(3) == '*' && scl.charAt(4) == '*' && scl.charAt(5) == '*' && scl.charAt(6) == '*' && scl.charAt(7) == '*' && scl.charAt(8) == '*') {
                return true;
            }
        }
        return dim_b != 0 && scl.charAt(0) == 'F' && scl.charAt(1) == '*' && scl.charAt(2) == '*' && scl.charAt(3) == '*' && scl.charAt(4) == 'T' && scl.charAt(5) == '*' && scl.charAt(6) == '*' && scl.charAt(7) == '*' && scl.charAt(8) == '*';
    }

    private static boolean crosses_(String scl, int dim_a, int dim_b) {
        if (dim_a > dim_b) {
            return scl.charAt(0) == 'T' && scl.charAt(1) == '*' && scl.charAt(2) == '*' && scl.charAt(3) == '*' && scl.charAt(4) == '*' && scl.charAt(5) == '*' && scl.charAt(6) == 'T' && scl.charAt(7) == '*' && scl.charAt(8) == '*';
        }
        return dim_a == 1 && dim_b == 1 && scl.charAt(0) == '0' && scl.charAt(1) == '*' && scl.charAt(2) == '*' && scl.charAt(3) == '*' && scl.charAt(4) == '*' && scl.charAt(5) == '*' && scl.charAt(6) == '*' && scl.charAt(7) == '*' && scl.charAt(8) == '*';
    }

    private static boolean contains_(String scl) {
        return scl.charAt(0) == 'T' && scl.charAt(1) == '*' && scl.charAt(2) == '*' && scl.charAt(3) == '*' && scl.charAt(4) == '*' && scl.charAt(5) == '*' && scl.charAt(6) == 'F' && scl.charAt(7) == 'F' && scl.charAt(8) == '*';
    }

    private static boolean overlaps_(String scl, int dim_a, int dim_b) {
        if (dim_a == dim_b) {
            if (dim_a != 1) {
                return scl.charAt(0) == 'T' && scl.charAt(1) == '*' && scl.charAt(2) == 'T' && scl.charAt(3) == '*' && scl.charAt(4) == '*' && scl.charAt(5) == '*' && scl.charAt(6) == 'T' && scl.charAt(7) == '*' && scl.charAt(8) == '*';
            }
            if (scl.charAt(0) == '1' && scl.charAt(1) == '*' && scl.charAt(2) == 'T' && scl.charAt(3) == '*' && scl.charAt(4) == '*' && scl.charAt(5) == '*' && scl.charAt(6) == 'T' && scl.charAt(7) == '*' && scl.charAt(8) == '*') {
                return true;
            }
        }
        return false;
    }

    private static void markClusters_(int geometry, TopoGraph topoGraph, int clusterIndex) {
        EditShape edit_shape = topoGraph.getShape();
        int path = edit_shape.getFirstPath(geometry);
        while (path != -1) {
            int vertexLast;
            int vertexFirst = edit_shape.getFirstVertex(path);
            boolean b_closed = vertexFirst == (vertexLast = edit_shape.getLastVertex(path));
            int vertex = vertexFirst;
            do {
                int cluster = topoGraph.getClusterFromVertex(vertex);
                int index = topoGraph.getClusterUserIndex(cluster, clusterIndex);
                if (!(b_closed || vertex != vertexFirst && vertex != vertexLast)) {
                    if (index == -1) {
                        topoGraph.setClusterUserIndex(cluster, clusterIndex, 1);
                        continue;
                    }
                    topoGraph.setClusterUserIndex(cluster, clusterIndex, index + 1);
                    continue;
                }
                if (index != -1) continue;
                topoGraph.setClusterUserIndex(cluster, clusterIndex, 0);
            } while ((vertex = edit_shape.getNextVertex(vertex)) != vertexFirst && vertex != -1);
            path = edit_shape.getNextPath(path);
        }
    }

    private static String transposeMatrix_(String scl) {
        String transpose = new String();
        transpose = transpose + scl.charAt(0);
        transpose = transpose + scl.charAt(3);
        transpose = transpose + scl.charAt(6);
        transpose = transpose + scl.charAt(1);
        transpose = transpose + scl.charAt(4);
        transpose = transpose + scl.charAt(7);
        transpose = transpose + scl.charAt(2);
        transpose = transpose + scl.charAt(5);
        transpose = transpose + scl.charAt(8);
        return transpose;
    }

    private void resetMatrix_() {
        for (int i = 0; i < 9; ++i) {
            this.m_matrix[i] = -2;
        }
    }

    private void setPredicates_(String scl) {
        this.m_scl = scl;
        for (int i = 0; i < 9; ++i) {
            if (this.m_scl.charAt(i) != '*') {
                this.m_perform_predicates[i] = true;
                ++this.m_predicate_count;
                continue;
            }
            this.m_perform_predicates[i] = false;
        }
    }

    private void setRemainingPredicatesToFalse_() {
        for (int i = 0; i < 9; ++i) {
            if (!this.m_perform_predicates[i] || this.m_matrix[i] != -2) continue;
            this.m_matrix[i] = -1;
            this.m_perform_predicates[i] = false;
        }
    }

    private boolean isPredicateKnown_(int predicate, int dim) {
        assert (this.m_scl.charAt(predicate) != '*');
        if (this.m_matrix[predicate] == -1) {
            this.m_perform_predicates[predicate] = false;
            --this.m_predicate_count;
            return true;
        }
        if (this.m_scl.charAt(predicate) != 'T' && this.m_scl.charAt(predicate) != 'F') {
            if (this.m_matrix[predicate] < dim) {
                return false;
            }
            this.m_perform_predicates[predicate] = false;
            --this.m_predicate_count;
            return true;
        }
        if (this.m_matrix[predicate] == -2) {
            return false;
        }
        this.m_perform_predicates[predicate] = false;
        --this.m_predicate_count;
        return true;
    }

    private void setAreaAreaPredicates_() {
        this.m_predicates = 0;
        if (this.m_perform_predicates[8]) {
            this.m_matrix[8] = 2;
            this.m_perform_predicates[8] = false;
            --this.m_predicate_count;
        }
    }

    private void setAreaLinePredicates_() {
        this.m_predicates = 1;
        if (this.m_perform_predicates[2]) {
            this.m_matrix[2] = 2;
            this.m_perform_predicates[2] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[8]) {
            this.m_matrix[8] = 2;
            this.m_perform_predicates[8] = false;
            --this.m_predicate_count;
        }
    }

    private void setLineLinePredicates_() {
        this.m_predicates = 2;
        if (this.m_perform_predicates[8]) {
            this.m_matrix[8] = 2;
            this.m_perform_predicates[8] = false;
            --this.m_predicate_count;
        }
    }

    private void setAreaPointPredicates_() {
        this.m_predicates = 3;
        if (this.m_perform_predicates[1]) {
            this.m_matrix[1] = -1;
            this.m_perform_predicates[1] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[2]) {
            this.m_matrix[2] = 2;
            this.m_perform_predicates[2] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[4]) {
            this.m_matrix[4] = -1;
            this.m_perform_predicates[4] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[5]) {
            this.m_matrix[5] = 1;
            this.m_perform_predicates[5] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[7]) {
            this.m_matrix[7] = -1;
            this.m_perform_predicates[7] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[8]) {
            this.m_matrix[8] = 2;
            this.m_perform_predicates[8] = false;
            --this.m_predicate_count;
        }
    }

    private void setLinePointPredicates_() {
        this.m_predicates = 4;
        if (this.m_perform_predicates[1]) {
            this.m_matrix[1] = -1;
            this.m_perform_predicates[1] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[2]) {
            this.m_matrix[2] = 1;
            this.m_perform_predicates[2] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[4]) {
            this.m_matrix[4] = -1;
            this.m_perform_predicates[4] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[7]) {
            this.m_matrix[7] = -1;
            this.m_perform_predicates[7] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[8]) {
            this.m_matrix[8] = 2;
            this.m_perform_predicates[8] = false;
            --this.m_predicate_count;
        }
    }

    private void setPointPointPredicates_() {
        this.m_predicates = 5;
        if (this.m_perform_predicates[1]) {
            this.m_matrix[1] = -1;
            this.m_perform_predicates[1] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[3]) {
            this.m_matrix[3] = -1;
            this.m_perform_predicates[3] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[4]) {
            this.m_matrix[4] = -1;
            this.m_perform_predicates[4] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[5]) {
            this.m_matrix[5] = -1;
            this.m_perform_predicates[5] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[7]) {
            this.m_matrix[7] = -1;
            this.m_perform_predicates[7] = false;
            --this.m_predicate_count;
        }
        if (this.m_perform_predicates[8]) {
            this.m_matrix[8] = 2;
            this.m_perform_predicates[8] = false;
            --this.m_predicate_count;
        }
    }

    private boolean areaAreaPredicates_(int half_edge, int id_a, int id_b) {
        boolean bRelationKnown = true;
        if (this.m_perform_predicates[0]) {
            this.interiorAreaInteriorArea_(half_edge, id_a, id_b);
            bRelationKnown &= this.isPredicateKnown_(0, 2);
        }
        if (this.m_perform_predicates[1]) {
            this.interiorAreaBoundaryArea_(half_edge, id_a, 1);
            bRelationKnown &= this.isPredicateKnown_(1, 1);
        }
        if (this.m_perform_predicates[2]) {
            this.interiorAreaExteriorArea_(half_edge, id_a, id_b, 2);
            bRelationKnown &= this.isPredicateKnown_(2, 2);
        }
        if (this.m_perform_predicates[3]) {
            this.interiorAreaBoundaryArea_(half_edge, id_b, 3);
            bRelationKnown &= this.isPredicateKnown_(3, 1);
        }
        if (this.m_perform_predicates[4]) {
            this.boundaryAreaBoundaryArea_(half_edge, id_a, id_b);
            bRelationKnown &= this.isPredicateKnown_(4, 1);
        }
        if (this.m_perform_predicates[5]) {
            this.boundaryAreaExteriorArea_(half_edge, id_a, id_b, 5);
            bRelationKnown &= this.isPredicateKnown_(5, 1);
        }
        if (this.m_perform_predicates[6]) {
            this.interiorAreaExteriorArea_(half_edge, id_b, id_a, 6);
            bRelationKnown &= this.isPredicateKnown_(6, 2);
        }
        if (this.m_perform_predicates[7]) {
            this.boundaryAreaExteriorArea_(half_edge, id_b, id_a, 7);
            bRelationKnown &= this.isPredicateKnown_(7, 1);
        }
        return bRelationKnown;
    }

    private boolean areaLinePredicates_(int half_edge, int id_a, int id_b) {
        boolean bRelationKnown = true;
        if (this.m_perform_predicates[0]) {
            this.interiorAreaInteriorLine_(half_edge, id_a, id_b);
            bRelationKnown &= this.isPredicateKnown_(0, 1);
        }
        if (this.m_perform_predicates[1]) {
            this.interiorAreaBoundaryLine_(half_edge, id_a, id_b, this.m_cluster_index_b);
            bRelationKnown &= this.isPredicateKnown_(1, 0);
        }
        if (this.m_perform_predicates[3]) {
            this.boundaryAreaInteriorLine_(half_edge, id_a, id_b, this.m_cluster_index_b);
            bRelationKnown &= this.isPredicateKnown_(3, 1);
        }
        if (this.m_perform_predicates[4]) {
            this.boundaryAreaBoundaryLine_(half_edge, id_a, id_b, this.m_cluster_index_b);
            bRelationKnown &= this.isPredicateKnown_(4, 0);
        }
        if (this.m_perform_predicates[5]) {
            this.boundaryAreaExteriorLine_(half_edge, id_a, id_b);
            bRelationKnown &= this.isPredicateKnown_(5, 1);
        }
        if (this.m_perform_predicates[6]) {
            this.exteriorAreaInteriorLine_(half_edge, id_a);
            bRelationKnown &= this.isPredicateKnown_(6, 1);
        }
        if (this.m_perform_predicates[7]) {
            this.exteriorAreaBoundaryLine_(half_edge, id_a, id_b, this.m_cluster_index_b);
            bRelationKnown &= this.isPredicateKnown_(7, 0);
        }
        return bRelationKnown;
    }

    private boolean lineLinePredicates_(int half_edge, int id_a, int id_b) {
        boolean bRelationKnown = true;
        if (this.m_perform_predicates[0]) {
            this.interiorLineInteriorLine_(half_edge, id_a, id_b, this.m_cluster_index_a, this.m_cluster_index_b);
            bRelationKnown &= this.isPredicateKnown_(0, 1);
        }
        if (this.m_perform_predicates[1]) {
            this.interiorLineBoundaryLine_(half_edge, id_a, id_b, this.m_cluster_index_a, this.m_cluster_index_b, 1);
            bRelationKnown &= this.isPredicateKnown_(1, 0);
        }
        if (this.m_perform_predicates[2]) {
            this.interiorLineExteriorLine_(half_edge, id_a, id_b, 2);
            bRelationKnown &= this.isPredicateKnown_(2, 1);
        }
        if (this.m_perform_predicates[3]) {
            this.interiorLineBoundaryLine_(half_edge, id_b, id_a, this.m_cluster_index_b, this.m_cluster_index_a, 3);
            bRelationKnown &= this.isPredicateKnown_(3, 0);
        }
        if (this.m_perform_predicates[4]) {
            this.boundaryLineBoundaryLine_(half_edge, id_a, id_b, this.m_cluster_index_a, this.m_cluster_index_b);
            bRelationKnown &= this.isPredicateKnown_(4, 0);
        }
        if (this.m_perform_predicates[5]) {
            this.boundaryLineExteriorLine_(half_edge, id_a, id_b, this.m_cluster_index_a, 5);
            bRelationKnown &= this.isPredicateKnown_(5, 0);
        }
        if (this.m_perform_predicates[6]) {
            this.interiorLineExteriorLine_(half_edge, id_b, id_a, 6);
            bRelationKnown &= this.isPredicateKnown_(6, 1);
        }
        if (this.m_perform_predicates[7]) {
            this.boundaryLineExteriorLine_(half_edge, id_b, id_a, this.m_cluster_index_b, 7);
            bRelationKnown &= this.isPredicateKnown_(7, 0);
        }
        return bRelationKnown;
    }

    private boolean areaPointPredicates_(int cluster, int id_a, int id_b) {
        boolean bRelationKnown = true;
        if (this.m_perform_predicates[0]) {
            this.interiorAreaInteriorPoint_(cluster, id_a);
            bRelationKnown &= this.isPredicateKnown_(0, 0);
        }
        if (this.m_perform_predicates[3]) {
            this.boundaryAreaInteriorPoint_(cluster, id_a, id_b);
            bRelationKnown &= this.isPredicateKnown_(3, 0);
        }
        if (this.m_perform_predicates[6]) {
            this.exteriorAreaInteriorPoint_(cluster, id_a);
            bRelationKnown &= this.isPredicateKnown_(6, 0);
        }
        return bRelationKnown;
    }

    private boolean linePointPredicates_(int cluster, int id_a, int id_b) {
        boolean bRelationKnown = true;
        if (this.m_perform_predicates[0]) {
            this.interiorLineInteriorPoint_(cluster, id_a, id_b, this.m_cluster_index_a);
            bRelationKnown &= this.isPredicateKnown_(0, 0);
        }
        if (this.m_perform_predicates[3]) {
            this.boundaryLineInteriorPoint_(cluster, id_a, id_b, this.m_cluster_index_a);
            bRelationKnown &= this.isPredicateKnown_(3, 0);
        }
        if (this.m_perform_predicates[5]) {
            this.boundaryLineExteriorPoint_(cluster, id_a, id_b, this.m_cluster_index_a);
            bRelationKnown &= this.isPredicateKnown_(5, 0);
        }
        if (this.m_perform_predicates[6]) {
            this.exteriorLineInteriorPoint_(cluster, id_a, id_b);
            bRelationKnown &= this.isPredicateKnown_(6, 0);
        }
        return bRelationKnown;
    }

    private boolean pointPointPredicates_(int cluster, int id_a, int id_b) {
        boolean bRelationKnown = true;
        if (this.m_perform_predicates[0]) {
            this.interiorPointInteriorPoint_(cluster, id_a, id_b);
            bRelationKnown &= this.isPredicateKnown_(0, 0);
        }
        if (this.m_perform_predicates[2]) {
            this.interiorPointExteriorPoint_(cluster, id_a, id_b, 2);
            bRelationKnown &= this.isPredicateKnown_(2, 0);
        }
        if (this.m_perform_predicates[6]) {
            this.interiorPointExteriorPoint_(cluster, id_b, id_a, 6);
            bRelationKnown &= this.isPredicateKnown_(6, 0);
        }
        return bRelationKnown;
    }

    private void interiorAreaInteriorArea_(int half_edge, int id_a, int id_b) {
        if (this.m_matrix[0] == 2) {
            return;
        }
        int faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge);
        if ((faceParentage & id_a) != 0 && (faceParentage & id_b) != 0) {
            this.m_matrix[0] = 2;
        }
    }

    private void interiorAreaBoundaryArea_(int half_edge, int id_a, int predicate) {
        if (this.m_matrix[predicate] == 1) {
            return;
        }
        int faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge);
        int twinFaceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(this.m_topo_graph.getHalfEdgeTwin(half_edge));
        if ((faceParentage & id_a) != 0 && (twinFaceParentage & id_a) != 0) {
            this.m_matrix[predicate] = 1;
        }
    }

    private void interiorAreaExteriorArea_(int half_edge, int id_a, int id_b, int predicate) {
        if (this.m_matrix[predicate] == 2) {
            return;
        }
        int faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge);
        if ((faceParentage & id_a) != 0 && (faceParentage & id_b) == 0) {
            this.m_matrix[predicate] = 2;
        }
    }

    private void boundaryAreaBoundaryArea_(int half_edge, int id_a, int id_b) {
        int cluster;
        int clusterParentage;
        if (this.m_matrix[4] == 1) {
            return;
        }
        int parentage = this.m_topo_graph.getHalfEdgeParentage(half_edge);
        if ((parentage & id_a) != 0 && (parentage & id_b) != 0) {
            this.m_matrix[4] = 1;
            return;
        }
        if (this.m_matrix[4] != 0 && this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_a) != 0 && (clusterParentage & id_b) != 0) {
            this.m_matrix[4] = 0;
        }
    }

    private void boundaryAreaExteriorArea_(int half_edge, int id_a, int id_b, int predicate) {
        if (this.m_matrix[predicate] == 1) {
            return;
        }
        int faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge);
        int twinFaceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(this.m_topo_graph.getHalfEdgeTwin(half_edge));
        if ((faceParentage & id_b) == 0 && (twinFaceParentage & id_b) == 0) {
            this.m_matrix[predicate] = 1;
        }
    }

    private void interiorAreaInteriorLine_(int half_edge, int id_a, int id_b) {
        if (this.m_matrix[0] == 1) {
            return;
        }
        int faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge);
        int twinFaceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(this.m_topo_graph.getHalfEdgeTwin(half_edge));
        if ((faceParentage & id_a) != 0 && (twinFaceParentage & id_a) != 0) {
            this.m_matrix[0] = 1;
        }
    }

    private void interiorAreaBoundaryLine_(int half_edge, int id_a, int id_b, int cluster_index_b) {
        int faceParentage;
        int cluster;
        int clusterParentage;
        if (this.m_matrix[1] == 0) {
            return;
        }
        if (this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_a) == 0 && ((faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge)) & id_a) != 0) {
            int index = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_b);
            if ((clusterParentage & id_b) != 0 && index % 2 != 0) {
                assert (index != -1);
                this.m_matrix[1] = 0;
            }
        }
    }

    private void boundaryAreaInteriorLine_(int half_edge, int id_a, int id_b, int cluster_index_b) {
        int cluster;
        int clusterParentage;
        if (this.m_matrix[3] == 1) {
            return;
        }
        int parentage = this.m_topo_graph.getHalfEdgeParentage(half_edge);
        if ((parentage & id_a) != 0 && (parentage & id_b) != 0) {
            this.m_matrix[3] = 1;
            return;
        }
        if (this.m_matrix[3] != 0 && this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_a) != 0) {
            int index = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_b);
            if ((clusterParentage & id_b) != 0 && index % 2 == 0) {
                assert (index != -1);
                this.m_matrix[3] = 0;
            }
        }
    }

    private void boundaryAreaBoundaryLine_(int half_edge, int id_a, int id_b, int cluster_index_b) {
        int cluster;
        int clusterParentage;
        if (this.m_matrix[4] == 0) {
            return;
        }
        if (this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_a) != 0) {
            int index = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_b);
            if ((clusterParentage & id_b) != 0 && index % 2 != 0) {
                assert (index != -1);
                this.m_matrix[4] = 0;
            }
        }
    }

    private void boundaryAreaExteriorLine_(int half_edge, int id_a, int id_b) {
        if (this.m_matrix[5] == 1) {
            return;
        }
        int parentage = this.m_topo_graph.getHalfEdgeParentage(half_edge);
        if ((parentage & id_a) != 0 && (parentage & id_b) == 0) {
            this.m_matrix[5] = 1;
        }
    }

    private void exteriorAreaInteriorLine_(int half_edge, int id_a) {
        if (this.m_matrix[6] == 1) {
            return;
        }
        int faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge);
        int twinFaceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(this.m_topo_graph.getHalfEdgeTwin(half_edge));
        if ((faceParentage & id_a) == 0 && (twinFaceParentage & id_a) == 0) {
            this.m_matrix[6] = 1;
        }
    }

    private void exteriorAreaBoundaryLine_(int half_edge, int id_a, int id_b, int cluster_index_b) {
        int faceParentage;
        int cluster;
        int clusterParentage;
        if (this.m_matrix[7] == 0) {
            return;
        }
        if (this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_a) == 0 && ((faceParentage = this.m_topo_graph.getHalfEdgeFaceParentage(half_edge)) & id_a) == 0) {
            assert ((this.m_topo_graph.getHalfEdgeParentage(this.m_topo_graph.getHalfEdgeTwin(half_edge)) & id_a) == 0);
            int index = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_b);
            if ((clusterParentage & id_b) != 0 && index % 2 != 0) {
                assert (index != -1);
                this.m_matrix[7] = 0;
            }
        }
    }

    private void interiorLineInteriorLine_(int half_edge, int id_a, int id_b, int cluster_index_a, int cluster_index_b) {
        int cluster;
        int clusterParentage;
        if (this.m_matrix[0] == 1) {
            return;
        }
        int parentage = this.m_topo_graph.getHalfEdgeParentage(half_edge);
        if ((parentage & id_a) != 0 && (parentage & id_b) != 0) {
            this.m_matrix[0] = 1;
            return;
        }
        if (this.m_matrix[0] != 0 && this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_a) != 0 && (clusterParentage & id_b) != 0) {
            int index_a = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_a);
            int index_b = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_b);
            assert (index_a != -1);
            assert (index_b != -1);
            if (index_a % 2 == 0 && index_b % 2 == 0) {
                assert ((this.m_topo_graph.getClusterParentage(cluster) & id_a) != 0 && (this.m_topo_graph.getClusterParentage(cluster) & id_b) != 0);
                this.m_matrix[0] = 0;
            }
        }
    }

    private void interiorLineBoundaryLine_(int half_edge, int id_a, int id_b, int cluster_index_a, int cluster_index_b, int predicate) {
        int cluster;
        int clusterParentage;
        if (this.m_matrix[predicate] == 0) {
            return;
        }
        if (this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_a) != 0 && (clusterParentage & id_b) != 0) {
            int index_a = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_a);
            int index_b = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_b);
            assert (index_a != -1);
            assert (index_b != -1);
            if (index_a % 2 == 0 && index_b % 2 != 0) {
                assert ((this.m_topo_graph.getClusterParentage(cluster) & id_a) != 0 && (this.m_topo_graph.getClusterParentage(cluster) & id_b) != 0);
                this.m_matrix[predicate] = 0;
            }
        }
    }

    private void interiorLineExteriorLine_(int half_edge, int id_a, int id_b, int predicate) {
        if (this.m_matrix[predicate] == 1) {
            return;
        }
        int parentage = this.m_topo_graph.getHalfEdgeParentage(half_edge);
        if ((parentage & id_a) != 0 && (parentage & id_b) == 0) {
            this.m_matrix[predicate] = 1;
        }
    }

    private void boundaryLineBoundaryLine_(int half_edge, int id_a, int id_b, int cluster_index_a, int cluster_index_b) {
        int cluster;
        int clusterParentage;
        if (this.m_matrix[4] == 0) {
            return;
        }
        if (this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_a) != 0 && (clusterParentage & id_b) != 0) {
            int index_a = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_a);
            int index_b = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_b);
            assert (index_a != -1);
            assert (index_b != -1);
            if (index_a % 2 != 0 && index_b % 2 != 0) {
                assert ((this.m_topo_graph.getClusterParentage(cluster) & id_a) != 0 && (this.m_topo_graph.getClusterParentage(cluster) & id_b) != 0);
                this.m_matrix[4] = 0;
            }
        }
    }

    private void boundaryLineExteriorLine_(int half_edge, int id_a, int id_b, int cluster_index_a, int predicate) {
        int cluster;
        int clusterParentage;
        if (this.m_matrix[predicate] == 0) {
            return;
        }
        if (this.m_topo_graph.getHalfEdgeUserIndex(this.m_topo_graph.getHalfEdgePrev(this.m_topo_graph.getHalfEdgeTwin(half_edge)), this.m_visited_index) != 1 && ((clusterParentage = this.m_topo_graph.getClusterParentage(cluster = this.m_topo_graph.getHalfEdgeTo(half_edge))) & id_b) == 0) {
            int index = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_a);
            assert (index != -1);
            if (index % 2 != 0) {
                assert ((this.m_topo_graph.getClusterParentage(cluster) & id_a) != 0);
                this.m_matrix[predicate] = 0;
            }
        }
    }

    private void interiorAreaInteriorPoint_(int cluster, int id_a) {
        int chain;
        int chainParentage;
        if (this.m_matrix[0] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) == 0 && ((chainParentage = this.m_topo_graph.getChainParentage(chain = this.m_topo_graph.getClusterChain(cluster))) & id_a) != 0) {
            this.m_matrix[0] = 0;
        }
    }

    private void boundaryAreaInteriorPoint_(int cluster, int id_a, int id_b) {
        if (this.m_matrix[3] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) != 0 && (clusterParentage & id_b) != 0) {
            this.m_matrix[3] = 0;
        }
    }

    private void exteriorAreaInteriorPoint_(int cluster, int id_a) {
        int chain;
        int chainParentage;
        if (this.m_matrix[6] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) == 0 && ((chainParentage = this.m_topo_graph.getChainParentage(chain = this.m_topo_graph.getClusterChain(cluster))) & id_a) == 0) {
            this.m_matrix[6] = 0;
        }
    }

    private void interiorLineInteriorPoint_(int cluster, int id_a, int id_b, int cluster_index_a) {
        int index;
        if (this.m_matrix[0] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) != 0 && (clusterParentage & id_b) != 0 && (index = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_a)) % 2 == 0) {
            this.m_matrix[0] = 0;
        }
    }

    private void boundaryLineInteriorPoint_(int cluster, int id_a, int id_b, int cluster_index_a) {
        int index;
        if (this.m_matrix[3] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) != 0 && (clusterParentage & id_b) != 0 && (index = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_a)) % 2 != 0) {
            this.m_matrix[3] = 0;
        }
    }

    private void boundaryLineExteriorPoint_(int cluster, int id_a, int id_b, int cluster_index_a) {
        int index;
        if (this.m_matrix[5] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) != 0 && (clusterParentage & id_b) == 0 && (index = this.m_topo_graph.getClusterUserIndex(cluster, cluster_index_a)) % 2 != 0) {
            this.m_matrix[5] = 0;
        }
    }

    private void exteriorLineInteriorPoint_(int cluster, int id_a, int id_b) {
        if (this.m_matrix[6] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) == 0 && (clusterParentage & id_b) != 0) {
            this.m_matrix[6] = 0;
        }
    }

    private void interiorPointInteriorPoint_(int cluster, int id_a, int id_b) {
        if (this.m_matrix[0] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) != 0 && (clusterParentage & id_b) != 0) {
            this.m_matrix[0] = 0;
        }
    }

    private void interiorPointExteriorPoint_(int cluster, int id_a, int id_b, int predicate) {
        if (this.m_matrix[predicate] == 0) {
            return;
        }
        int clusterParentage = this.m_topo_graph.getClusterParentage(cluster);
        if ((clusterParentage & id_a) != 0 && (clusterParentage & id_b) == 0) {
            this.m_matrix[predicate] = 0;
        }
    }

    private void computeMatrixTopoGraphHalfEdges_(int geometry_a, int geometry_b) {
        boolean bRelationKnown = false;
        int id_a = this.m_topo_graph.getGeometryID(geometry_a);
        int id_b = this.m_topo_graph.getGeometryID(geometry_b);
        this.m_visited_index = this.m_topo_graph.createUserIndexForHalfEdges();
        int cluster = this.m_topo_graph.getFirstCluster();
        while (cluster != -1) {
            int half_edge;
            int first_half_edge;
            int next_half_edge = first_half_edge = this.m_topo_graph.getClusterHalfEdge(cluster);
            block6: do {
                int visited;
                if ((visited = this.m_topo_graph.getHalfEdgeUserIndex(half_edge = next_half_edge, this.m_visited_index)) == 1) continue;
                do {
                    switch (this.m_predicates) {
                        case 0: {
                            bRelationKnown = this.areaAreaPredicates_(half_edge, id_a, id_b);
                            break;
                        }
                        case 1: {
                            bRelationKnown = this.areaLinePredicates_(half_edge, id_a, id_b);
                            break;
                        }
                        case 2: {
                            bRelationKnown = this.lineLinePredicates_(half_edge, id_a, id_b);
                            break;
                        }
                        default: {
                            throw new GeometryException("internal error");
                        }
                    }
                    if (bRelationKnown) continue block6;
                    this.m_topo_graph.setHalfEdgeUserIndex(half_edge, this.m_visited_index, 1);
                } while ((half_edge = this.m_topo_graph.getHalfEdgeNext(half_edge)) != next_half_edge && !bRelationKnown);
            } while (!bRelationKnown && (next_half_edge = this.m_topo_graph.getHalfEdgeNext(this.m_topo_graph.getHalfEdgeTwin(half_edge))) != first_half_edge);
            if (bRelationKnown) break;
            cluster = this.m_topo_graph.getNextCluster(cluster);
        }
        if (!bRelationKnown) {
            this.setRemainingPredicatesToFalse_();
        }
        this.m_topo_graph.deleteUserIndexForHalfEdges(this.m_visited_index);
    }

    private void computeMatrixTopoGraphClusters_(int geometry_a, int geometry_b) {
        boolean bRelationKnown = false;
        int id_a = this.m_topo_graph.getGeometryID(geometry_a);
        int id_b = this.m_topo_graph.getGeometryID(geometry_b);
        int cluster = this.m_topo_graph.getFirstCluster();
        while (cluster != -1) {
            switch (this.m_predicates) {
                case 3: {
                    bRelationKnown = this.areaPointPredicates_(cluster, id_a, id_b);
                    break;
                }
                case 4: {
                    bRelationKnown = this.linePointPredicates_(cluster, id_a, id_b);
                    break;
                }
                case 5: {
                    bRelationKnown = this.pointPointPredicates_(cluster, id_a, id_b);
                    break;
                }
                default: {
                    throw new GeometryException("internal error");
                }
            }
            if (bRelationKnown) break;
            cluster = this.m_topo_graph.getNextCluster(cluster);
        }
        if (!bRelationKnown) {
            this.setRemainingPredicatesToFalse_();
        }
    }

    private void setEditShape_(EditShape shape) {
        this.m_topo_graph.setEditShape(shape, null);
    }

    private void setEditShapeCrackAndCluster_(EditShape shape, double tolerance, ProgressTracker progress_tracker) {
        CrackAndCluster.execute(shape, tolerance, progress_tracker);
        int geometry = shape.getFirstGeometry();
        while (geometry != -1) {
            if (shape.getGeometryType(geometry) == 1736) {
                Simplificator.execute(shape, geometry, -1);
            }
            geometry = shape.getNextGeometry(geometry);
        }
        this.setEditShape_(shape);
    }

    private static Geometry convertGeometry_(Geometry geometry, double tolerance) {
        int gt = geometry.getType().value();
        if (Geometry.isSegment(gt)) {
            Polyline polyline = new Polyline(geometry.getDescription());
            polyline.addSegment((Segment)geometry, true);
            return polyline;
        }
        if (gt == 197) {
            Envelope envelope = (Envelope)geometry;
            Envelope2D env = new Envelope2D();
            geometry.queryEnvelope2D(env);
            if (env.getHeight() <= tolerance && env.getWidth() <= tolerance) {
                Point point = new Point(geometry.getDescription());
                envelope.getCenter(point);
                return point;
            }
            if (env.getHeight() <= tolerance || env.getWidth() <= tolerance) {
                Polyline polyline = new Polyline(geometry.getDescription());
                Point p = new Point();
                envelope.queryCornerByVal(0, p);
                polyline.startPath(p);
                envelope.queryCornerByVal(2, p);
                polyline.lineTo(p);
                return polyline;
            }
            Polygon polygon = new Polygon(geometry.getDescription());
            polygon.addEnvelope(envelope, false);
            return polygon;
        }
        return geometry;
    }

    private static interface Predicates {
        public static final int AreaAreaPredicates = 0;
        public static final int AreaLinePredicates = 1;
        public static final int LineLinePredicates = 2;
        public static final int AreaPointPredicates = 3;
        public static final int LinePointPredicates = 4;
        public static final int PointPointPredicates = 5;
    }

    private static interface MatrixPredicate {
        public static final int InteriorInterior = 0;
        public static final int InteriorBoundary = 1;
        public static final int InteriorExterior = 2;
        public static final int BoundaryInterior = 3;
        public static final int BoundaryBoundary = 4;
        public static final int BoundaryExterior = 5;
        public static final int ExteriorInterior = 6;
        public static final int ExteriorBoundary = 7;
        public static final int ExteriorExterior = 8;
    }
}

