/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.TopologicalOperations;
import java.util.ArrayList;

class OperatorUnionCursor
extends GeometryCursor {
    private GeometryCursor m_inputGeoms;
    private ProgressTracker m_progress_tracker;
    private SpatialReferenceImpl m_spatial_reference;
    private int m_index = -1;
    private boolean m_b_done = false;

    OperatorUnionCursor(GeometryCursor inputGeoms1, SpatialReference sr, ProgressTracker progress_tracker) {
        this.m_inputGeoms = inputGeoms1;
        this.m_spatial_reference = (SpatialReferenceImpl)sr;
        this.m_progress_tracker = progress_tracker;
    }

    @Override
    public Geometry next() {
        return this.dissolve_();
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    private Geometry dissolve_() {
        if (this.m_b_done) {
            return null;
        }
        this.m_b_done = true;
        this.m_index = this.m_inputGeoms.getGeometryID();
        ArrayList unionBins = new ArrayList(0);
        AttributeStreamOfInt32 binSizes = new AttributeStreamOfInt32(0);
        unionBins.ensureCapacity(128);
        binSizes.reserve(128);
        for (int i = 0; i < 16; ++i) {
            unionBins.add(null);
        }
        int dimension = -1;
        boolean bFinished = false;
        int totalToUnion = 0;
        int totalVertexCount = 0;
        int binVertexThreshold = 10000;
        boolean dissolved_something = false;
        ArrayList batchToUnion = new ArrayList(0);
        batchToUnion.ensureCapacity(32);
        boolean bLocalDone = false;
        while (!bLocalDone) {
            boolean bCanGo;
            if (!bFinished) {
                Geometry geom = this.m_inputGeoms.next();
                if (this.m_progress_tracker != null && !this.m_progress_tracker.progress(-1, -1)) {
                    throw new RuntimeException("user_canceled");
                }
                if (geom != null) {
                    int resize;
                    int level;
                    int sz;
                    if (geom.getDimension() > dimension) {
                        GeomPair pair = new GeomPair();
                        pair.init();
                        pair.geom = geom;
                        pair.dim = geom.getDimension();
                        pair.vertex_count = sz = OperatorUnionCursor.getVertexCount_(geom);
                        level = OperatorUnionCursor.getLevel_(sz);
                        unionBins.clear();
                        resize = Math.max(16, level + 1);
                        for (int i = 0; i < resize; ++i) {
                            unionBins.add(null);
                        }
                        binSizes.resize(resize, 0.0);
                        unionBins.set(level, new ArrayList(0));
                        ((ArrayList)unionBins.get(level)).add(pair);
                        binSizes.set(level, sz);
                        totalToUnion = 1;
                        totalVertexCount = sz;
                        dimension = geom.getDimension();
                    } else if (!geom.isEmpty() && geom.getDimension() == dimension) {
                        GeomPair pair = new GeomPair();
                        pair.init();
                        pair.geom = geom;
                        pair.dim = geom.getDimension();
                        pair.vertex_count = sz = OperatorUnionCursor.getVertexCount_(geom);
                        level = OperatorUnionCursor.getLevel_(sz);
                        resize = Math.max(unionBins.size(), level + 1);
                        if (resize > unionBins.size()) {
                            int grow = resize - unionBins.size();
                            for (int i = 0; i < grow; ++i) {
                                unionBins.add(null);
                            }
                        }
                        binSizes.resize(resize, 0.0);
                        if (unionBins.get(level) == null) {
                            unionBins.set(level, new ArrayList(0));
                        }
                        ((ArrayList)unionBins.get(level)).add(pair);
                        binSizes.write(level, binSizes.read(level) + sz);
                        ++totalToUnion;
                        totalVertexCount += sz;
                    }
                } else {
                    bFinished = true;
                }
            }
            while (true) {
                int sz;
                int i;
                int n;
                if (!bFinished) {
                    int imax = -1;
                    int maxSz = 0;
                    n = unionBins.size();
                    for (i = 0; i < n; ++i) {
                        if (unionBins.get(i) == null || ((ArrayList)unionBins.get(i)).size() <= 1 || binSizes.read(i) <= binVertexThreshold || maxSz >= binSizes.read(i)) continue;
                        maxSz = binSizes.read(i);
                        imax = i;
                    }
                    if (maxSz > 0) {
                        while (((ArrayList)unionBins.get(imax)).size() > 0) {
                            ArrayList bin = (ArrayList)unionBins.get(imax);
                            batchToUnion.add(bin.get(bin.size() - 1));
                            bin.remove(bin.size() - 1);
                            totalVertexCount -= ((GeomPair)batchToUnion.get((int)(batchToUnion.size() - 1))).vertex_count;
                            binSizes.write(imax, binSizes.read(imax) - ((GeomPair)batchToUnion.get((int)(batchToUnion.size() - 1))).vertex_count);
                        }
                    }
                } else if (totalToUnion > 1) {
                    int level = 0;
                    int vertexCount = 0;
                    n = unionBins.size();
                    for (i = 0; i < n && (batchToUnion.size() < 2 || vertexCount < binVertexThreshold); ++i) {
                        if (unionBins.get(i) == null) continue;
                        while (!(((ArrayList)unionBins.get(i)).isEmpty() || batchToUnion.size() >= 2 && vertexCount >= binVertexThreshold)) {
                            ArrayList bin = (ArrayList)unionBins.get(i);
                            batchToUnion.add(bin.get(bin.size() - 1));
                            bin.remove(bin.size() - 1);
                            level = i;
                            totalVertexCount -= ((GeomPair)batchToUnion.get((int)(batchToUnion.size() - 1))).vertex_count;
                            vertexCount += ((GeomPair)batchToUnion.get((int)(batchToUnion.size() - 1))).vertex_count;
                            binSizes.write(i, binSizes.read(i) - ((GeomPair)batchToUnion.get((int)(batchToUnion.size() - 1))).vertex_count);
                        }
                    }
                    if (batchToUnion.size() == 1) {
                        ((ArrayList)unionBins.get(level)).add(batchToUnion.get(batchToUnion.size() - 1));
                        totalVertexCount += ((GeomPair)batchToUnion.get((int)(batchToUnion.size() - 1))).vertex_count;
                        binSizes.write(level, binSizes.read(level) + ((GeomPair)batchToUnion.get((int)(batchToUnion.size() - 1))).vertex_count);
                        batchToUnion.remove(batchToUnion.size() - 1);
                    }
                }
                if (batchToUnion.isEmpty()) break;
                ArrayList<Geometry> geoms = new ArrayList<Geometry>(0);
                geoms.ensureCapacity(batchToUnion.size());
                int n2 = batchToUnion.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    geoms.add(((GeomPair)batchToUnion.get((int)i2)).geom);
                }
                Geometry resGeom = TopologicalOperations.dissolveDirty(geoms, this.m_spatial_reference, this.m_progress_tracker);
                int resDim = resGeom.getDimension();
                dissolved_something = true;
                GeomPair pair = new GeomPair();
                pair.init();
                pair.geom = resGeom;
                pair.dim = resDim;
                pair.vertex_count = sz = OperatorUnionCursor.getVertexCount_(resGeom);
                int level = OperatorUnionCursor.getLevel_(sz);
                int resize = Math.max(unionBins.size() + 1, level);
                if (resize > unionBins.size()) {
                    int grow = resize - unionBins.size();
                    for (int i3 = 0; i3 < grow; ++i3) {
                        unionBins.add(null);
                    }
                }
                binSizes.resize(resize, 0.0);
                if (unionBins.get(level) == null) {
                    unionBins.set(level, new ArrayList(0));
                }
                ((ArrayList)unionBins.get(level)).add(pair);
                binSizes.write(level, binSizes.read(level) + sz);
                totalToUnion -= batchToUnion.size() - 1;
                batchToUnion.clear();
            }
            boolean bl = bCanGo = totalToUnion == 1;
            if (!bFinished) continue;
            bLocalDone = true;
        }
        Geometry resGeom = null;
        for (int i = 0; i < unionBins.size(); ++i) {
            if (unionBins.get(i) == null || ((ArrayList)unionBins.get(i)).size() <= 0) continue;
            resGeom = ((GeomPair)((ArrayList)unionBins.get((int)i)).get((int)0)).geom;
        }
        if (resGeom == null) {
            return resGeom;
        }
        if (dissolved_something) {
            OperatorFactoryLocal engine = OperatorFactoryLocal.getInstance();
            OperatorSimplify simplify = (OperatorSimplify)engine.getOperator(Operator.Type.Simplify);
            resGeom = simplify.execute(resGeom, (SpatialReference)this.m_spatial_reference, false, this.m_progress_tracker);
        }
        if (resGeom.getType().value() == 33) {
            MultiPoint mp = new MultiPoint(resGeom.getDescription());
            if (!resGeom.isEmpty()) {
                mp.add((Point)resGeom);
            }
            resGeom = mp;
        }
        return resGeom;
    }

    private static int getVertexCount_(Geometry geom) {
        int gt = geom.getType().value();
        if (Geometry.isMultiVertex(gt)) {
            return ((MultiVertexGeometry)geom).getPointCount();
        }
        if (gt == 33) {
            return 1;
        }
        if (gt == 197) {
            return 4;
        }
        if (Geometry.isSegment(gt)) {
            return 2;
        }
        throw new GeometryException("internal error");
    }

    private static int getLevel_(int sz) {
        return sz > 0 ? (int)(Math.log(sz) / Math.log(4.0) + 0.5) : 0;
    }

    private static final class GeomPair {
        Geometry geom;
        int vertex_count;
        int dim;

        private GeomPair() {
        }

        void init() {
            this.geom = null;
            this.dim = -1;
            this.vertex_count = -1;
        }
    }
}

