/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorDisjoint;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorProximity2D;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Proximity2DResult;
import com.esri.core.geometry.Proximity2DResultComparator;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIteratorImpl;
import java.util.ArrayList;
import java.util.Collections;

class OperatorProximity2DLocal
extends OperatorProximity2D {
    OperatorProximity2DLocal() {
    }

    @Override
    public Proximity2DResult getNearestCoordinate(Geometry geom, Point inputPoint, boolean bTestPolygonInterior) {
        if (geom.isEmpty()) {
            return new Proximity2DResult();
        }
        Point2D inputPoint2D = inputPoint.getXY();
        Geometry proxmityTestGeom = geom;
        int gt = geom.getType().value();
        if (gt == 197) {
            Polygon polygon = new Polygon();
            polygon.addEnvelope((Envelope)geom, false);
            proxmityTestGeom = polygon;
            gt = 1736;
        }
        switch (gt) {
            case 33: {
                return this.pointGetNearestVertex((Point)proxmityTestGeom, inputPoint2D);
            }
            case 550: {
                return this.multiVertexGetNearestVertex((MultiVertexGeometry)proxmityTestGeom, inputPoint2D);
            }
            case 1607: 
            case 1736: {
                return this.polyPathGetNearestCoordinate((MultiPath)proxmityTestGeom, inputPoint2D, bTestPolygonInterior);
            }
        }
        throw new GeometryException("not implemented");
    }

    @Override
    public Proximity2DResult getNearestVertex(Geometry geom, Point inputPoint) {
        if (geom.isEmpty()) {
            return new Proximity2DResult();
        }
        Point2D inputPoint2D = inputPoint.getXY();
        Geometry proxmityTestGeom = geom;
        int gt = geom.getType().value();
        if (gt == 197) {
            Polygon polygon = new Polygon();
            polygon.addEnvelope((Envelope)geom, false);
            proxmityTestGeom = polygon;
            gt = 1736;
        }
        switch (gt) {
            case 33: {
                return this.pointGetNearestVertex((Point)proxmityTestGeom, inputPoint2D);
            }
            case 550: 
            case 1607: 
            case 1736: {
                return this.multiVertexGetNearestVertex((MultiVertexGeometry)proxmityTestGeom, inputPoint2D);
            }
        }
        throw new GeometryException("not implemented");
    }

    @Override
    public Proximity2DResult[] getNearestVertices(Geometry geom, Point inputPoint, double searchRadius, int maxVertexCountToReturn) {
        if (maxVertexCountToReturn < 0) {
            throw new IllegalArgumentException();
        }
        if (geom.isEmpty()) {
            return new Proximity2DResult[0];
        }
        Point2D inputPoint2D = inputPoint.getXY();
        Geometry proxmityTestGeom = geom;
        int gt = geom.getType().value();
        if (gt == 197) {
            Polygon polygon = new Polygon();
            polygon.addEnvelope((Envelope)geom, false);
            proxmityTestGeom = polygon;
            gt = 1736;
        }
        switch (gt) {
            case 33: {
                return this.pointGetNearestVertices((Point)proxmityTestGeom, inputPoint2D, searchRadius, maxVertexCountToReturn);
            }
            case 550: 
            case 1607: 
            case 1736: {
                return this.multiVertexGetNearestVertices((MultiVertexGeometry)proxmityTestGeom, inputPoint2D, searchRadius, maxVertexCountToReturn);
            }
        }
        throw new GeometryException("not implemented");
    }

    Proximity2DResult polyPathGetNearestCoordinate(MultiPath geom, Point2D inputPoint, boolean bTestPolygonInterior) {
        Proximity2DResult result = new Proximity2DResult();
        if (geom.getType() == Geometry.Type.Polygon && bTestPolygonInterior) {
            OperatorFactoryLocal factory = OperatorFactoryLocal.getInstance();
            OperatorDisjoint operatorDisjoint = (OperatorDisjoint)factory.getOperator(Operator.Type.Disjoint);
            Point point = new Point(geom.getDescription());
            point.setXY(inputPoint.x, inputPoint.y);
            boolean disjoint = operatorDisjoint.execute(geom, point, null, null);
            if (!disjoint) {
                result._setParams(inputPoint.x, inputPoint.y, 0, 0.0);
                return result;
            }
        }
        MultiPathImpl mpImpl = (MultiPathImpl)geom._getImpl();
        SegmentIteratorImpl segIter = mpImpl.querySegmentIterator();
        Point2D closest = null;
        int closestIndex = 0;
        double closestDistanceSq = NumberUtils.doubleMax();
        while (segIter.nextPath()) {
            while (segIter.hasNextSegment()) {
                double t;
                Segment segment = segIter.nextSegment();
                Point2D point = segment.getCoord2D(t = segment.getClosestCoordinate(inputPoint, false));
                double distanceSq = Point2D.sqrDistance(point, inputPoint);
                if (!(distanceSq < closestDistanceSq)) continue;
                closest = point;
                closestIndex = segIter.getStartPointIndex();
                closestDistanceSq = distanceSq;
            }
        }
        result._setParams(closest.x, closest.y, closestIndex, Math.sqrt(closestDistanceSq));
        return result;
    }

    Proximity2DResult pointGetNearestVertex(Point geom, Point2D inputPoint) {
        Proximity2DResult result = new Proximity2DResult();
        Point2D pt = geom.getXY();
        double distance = Point2D.distance(pt, inputPoint);
        result._setParams(pt.x, pt.y, 0, distance);
        return result;
    }

    Proximity2DResult multiVertexGetNearestVertex(MultiVertexGeometry geom, Point2D inputPoint) {
        MultiVertexGeometryImpl mpImpl = (MultiVertexGeometryImpl)geom._getImpl();
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(0);
        int pointCount = geom.getPointCount();
        int closestIndex = 0;
        double closestx = 0.0;
        double closesty = 0.0;
        double closestDistanceSq = NumberUtils.doubleMax();
        for (int i = 0; i < pointCount; ++i) {
            Point2D pt = new Point2D();
            position.read(2 * i, pt);
            double distanceSq = Point2D.sqrDistance(pt, inputPoint);
            if (!(distanceSq < closestDistanceSq)) continue;
            closestx = pt.x;
            closesty = pt.y;
            closestIndex = i;
            closestDistanceSq = distanceSq;
        }
        Proximity2DResult result = new Proximity2DResult();
        result._setParams(closestx, closesty, closestIndex, Math.sqrt(closestDistanceSq));
        return result;
    }

    Proximity2DResult[] pointGetNearestVertices(Point geom, Point2D inputPoint, double searchRadius, int maxVertexCountToReturn) {
        Proximity2DResult[] resultArray;
        if (maxVertexCountToReturn == 0) {
            Proximity2DResult[] resultArray2 = new Proximity2DResult[]{};
            return resultArray2;
        }
        double searchRadiusSq = searchRadius * searchRadius;
        Point2D pt = geom.getXY();
        double distanceSq = Point2D.sqrDistance(pt, inputPoint);
        if (distanceSq <= searchRadiusSq) {
            resultArray = new Proximity2DResult[1];
            Proximity2DResult result = new Proximity2DResult();
            result._setParams(pt.x, pt.y, 0, Math.sqrt(distanceSq));
            resultArray[0] = result;
        } else {
            resultArray = new Proximity2DResult[]{};
        }
        return resultArray;
    }

    Proximity2DResult[] multiVertexGetNearestVertices(MultiVertexGeometry geom, Point2D inputPoint, double searchRadius, int maxVertexCountToReturn) {
        if (maxVertexCountToReturn == 0) {
            Proximity2DResult[] resultArray = new Proximity2DResult[]{};
            return resultArray;
        }
        MultiVertexGeometryImpl mpImpl = (MultiVertexGeometryImpl)geom._getImpl();
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(0);
        int pointCount = geom.getPointCount();
        ArrayList<Proximity2DResult> v = new ArrayList<Proximity2DResult>(maxVertexCountToReturn);
        int count = 0;
        double searchRadiusSq = searchRadius * searchRadius;
        for (int i = 0; i < pointCount; ++i) {
            double y;
            double yDiff;
            double x = position.read(2 * i);
            double xDiff = inputPoint.x - x;
            double distanceSq = xDiff * xDiff + (yDiff = inputPoint.y - (y = position.read(2 * i + 1))) * yDiff;
            if (!(distanceSq <= searchRadiusSq)) continue;
            Proximity2DResult result = new Proximity2DResult();
            result._setParams(x, y, i, Math.sqrt(distanceSq));
            ++count;
            v.add(result);
        }
        int vsize = v.size();
        Collections.sort(v, new Proximity2DResultComparator());
        if (maxVertexCountToReturn >= vsize) {
            return v.toArray(new Proximity2DResult[0]);
        }
        return v.subList(0, maxVertexCountToReturn).toArray(new Proximity2DResult[0]);
    }
}

