/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.Cutter;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.OperatorCutLocal;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.TopologicalOperations;
import java.util.ArrayList;

class OperatorCutCursor
extends GeometryCursor {
    boolean m_bConsiderTouch;
    Geometry m_cuttee;
    Polyline m_cutter;
    double m_tolerance;
    int m_cutIndex;
    ArrayList<MultiPath> m_cuts;

    OperatorCutCursor(boolean bConsiderTouch, Geometry cuttee, Polyline cutter, SpatialReference spatialReference, ProgressTracker progressTracker) {
        if (cuttee == null) {
            throw new GeometryException("invalid argument");
        }
        this.m_bConsiderTouch = bConsiderTouch;
        this.m_cuttee = cuttee;
        this.m_cutter = cutter;
        double d = this.m_tolerance = spatialReference != null ? spatialReference.getTolerance(0) : InternalUtils.calculateToleranceFromGeometry(null, cuttee, false);
        if (this.m_tolerance > 0.001) {
            this.m_tolerance = 0.001;
        }
        this.m_cutIndex = -1;
        this.m_cuts = null;
    }

    @Override
    public int getGeometryID() {
        return 0;
    }

    @Override
    public Geometry next() {
        if (this.m_cuts == null) {
            int type = this.m_cuttee.getType().value();
            switch (type) {
                case 1607: {
                    this.m_cuts = this._cutPolyline();
                    break;
                }
                case 1736: {
                    this.m_cuts = this._cutPolygon();
                }
            }
        }
        if (++this.m_cutIndex < this.m_cuts.size()) {
            return this.m_cuts.get(this.m_cutIndex);
        }
        return null;
    }

    private ArrayList<MultiPath> _cutPolyline() {
        Polyline left = new Polyline();
        Polyline right = new Polyline();
        Polyline uncut = new Polyline();
        ArrayList<MultiPath> cuts = new ArrayList<MultiPath>(2);
        cuts.add(left);
        cuts.add(right);
        ArrayList<OperatorCutLocal.CutPair> cutPairs = new ArrayList<OperatorCutLocal.CutPair>(0);
        Cutter.CutPolyline(this.m_bConsiderTouch, (Polyline)this.m_cuttee, this.m_cutter, this.m_tolerance, cutPairs, null);
        for (int icut = 0; icut < cutPairs.size(); ++icut) {
            OperatorCutLocal.CutPair cutPair = cutPairs.get(icut);
            if (cutPair.m_side == 0) {
                left.add((MultiPath)cutPair.m_geometry, false);
                continue;
            }
            if (cutPair.m_side == 1 || cutPair.m_side == 2) {
                right.add((MultiPath)cutPair.m_geometry, false);
                continue;
            }
            if (cutPair.m_side == 3) {
                cuts.add((MultiPath)cutPair.m_geometry);
                continue;
            }
            uncut.add((MultiPath)cutPair.m_geometry, false);
        }
        if (!(uncut.isEmpty() || left.isEmpty() && right.isEmpty() && cuts.size() < 3)) {
            cuts.add(uncut);
        }
        return cuts;
    }

    ArrayList<MultiPath> _cutPolygon() {
        AttributeStreamOfInt32 cutHandles = new AttributeStreamOfInt32(0);
        EditShape shape = new EditShape();
        int sideIndex = shape.createGeometryUserIndex();
        int cutteeHandle = shape.addGeometry(this.m_cuttee);
        int cutterHandle = shape.addGeometry(this.m_cutter);
        TopologicalOperations topoOp = new TopologicalOperations();
        topoOp.setEditShapeCrackAndCluster(shape, this.m_tolerance, null);
        topoOp.cut(sideIndex, cutteeHandle, cutterHandle, cutHandles);
        Polygon cutteeRemainder = (Polygon)shape.getGeometry(cutteeHandle);
        Polygon left = new Polygon();
        Polygon right = new Polygon();
        ArrayList<MultiPath> cuts = new ArrayList<MultiPath>(2);
        cuts.add(left);
        cuts.add(right);
        for (int icutIndex = 0; icutIndex < cutHandles.size(); ++icutIndex) {
            EditShape shapeIntersect = new EditShape();
            int geometryA = shapeIntersect.addGeometry(cutteeRemainder);
            int geometryB = shapeIntersect.addGeometry(shape.getGeometry(cutHandles.get(icutIndex)));
            topoOp.setEditShape(shapeIntersect);
            int intersectHandle = topoOp.intersection(geometryA, geometryB);
            Geometry cutGeometry = shapeIntersect.getGeometry(intersectHandle);
            if (cutGeometry.isEmpty()) continue;
            int side = shape.getGeometryUserIndex(cutHandles.get(icutIndex), sideIndex);
            if (side == 2) {
                left.add((MultiPath)cutGeometry, false);
            } else if (side == 1) {
                right.add((MultiPath)cutGeometry, false);
            } else {
                cuts.add((MultiPath)cutGeometry);
            }
            EditShape shapeDifference = new EditShape();
            geometryA = shapeDifference.addGeometry(cutteeRemainder);
            geometryB = shapeDifference.addGeometry(shape.getGeometry(cutHandles.get(icutIndex)));
            topoOp.setEditShape(shapeDifference);
            cutteeRemainder = (Polygon)shapeDifference.getGeometry(topoOp.difference(geometryA, geometryB));
        }
        if (!cutteeRemainder.isEmpty() && cutHandles.size() > 0) {
            cuts.add(cutteeRemainder);
        }
        return cuts;
    }
}

