/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.IndexMultiList;

class IndexHashTable {
    int m_random;
    AttributeStreamOfInt32 m_hashBuckets;
    IndexMultiList m_lists;
    HashFunction m_hash;

    public IndexHashTable(int size, HashFunction hashFunction) {
        this.m_hashBuckets = new AttributeStreamOfInt32(size, IndexHashTable.nullNode());
        this.m_lists = new IndexMultiList();
        this.m_hash = hashFunction;
    }

    public void reserveElements(int capacity) {
        this.m_lists.reserveLists(Math.min(this.m_hashBuckets.size(), capacity));
        this.m_lists.reserveNodes(capacity);
    }

    public void addElement(int element) {
        int hash = this.m_hash.getHash(element);
        int bucket = hash % this.m_hashBuckets.size();
        int list = this.m_hashBuckets.get(bucket);
        if (list == IndexMultiList.nullNode()) {
            list = this.m_lists.createList();
            this.m_hashBuckets.set(bucket, list);
        }
        this.m_lists.addElement(list, element);
    }

    public void deleteElement(int element) {
        int hash = this.m_hash.getHash(element);
        int bucket = hash % this.m_hashBuckets.size();
        int list = this.m_hashBuckets.get(bucket);
        if (list == IndexMultiList.nullNode()) {
            throw new IllegalArgumentException();
        }
        int ptr = this.m_lists.getFirst(list);
        int prev = IndexMultiList.nullNode();
        while (ptr != IndexMultiList.nullNode()) {
            int e = this.m_lists.getElement(ptr);
            int nextptr = this.m_lists.getNext(ptr);
            if (e == element) {
                this.m_lists.deleteElement(list, prev, ptr);
                if (this.m_lists.getFirst(list) == IndexMultiList.nullNode()) {
                    this.m_lists.deleteList(list);
                    this.m_hashBuckets.set(bucket, IndexMultiList.nullNode());
                }
            } else {
                prev = ptr;
            }
            ptr = nextptr;
        }
    }

    public int getFirstInBucket(int hashValue) {
        int bucket = hashValue % this.m_hashBuckets.size();
        int list = this.m_hashBuckets.get(bucket);
        if (list == IndexMultiList.nullNode()) {
            return IndexMultiList.nullNode();
        }
        return this.m_lists.getFirst(list);
    }

    public int getNextInBucket(int elementHandle) {
        return this.m_lists.getNext(elementHandle);
    }

    public int findNode(int element) {
        int hash = this.m_hash.getHash(element);
        int bucket = hash % this.m_hashBuckets.size();
        int list = this.m_hashBuckets.get(bucket);
        if (list == IndexMultiList.nullNode()) {
            return IndexMultiList.nullNode();
        }
        int ptr = this.m_lists.getFirst(list);
        while (ptr != IndexMultiList.nullNode()) {
            int e = this.m_lists.getElement(ptr);
            if (this.m_hash.equal(e, element)) {
                return ptr;
            }
            ptr = this.m_lists.getNext(ptr);
        }
        return IndexMultiList.nullNode();
    }

    public int findNode(Object elementDescriptor) {
        int hash = this.m_hash.getHash(elementDescriptor);
        int bucket = hash % this.m_hashBuckets.size();
        int list = this.m_hashBuckets.get(bucket);
        if (list == IndexMultiList.nullNode()) {
            return IndexMultiList.nullNode();
        }
        int ptr = this.m_lists.getFirst(list);
        while (ptr != IndexMultiList.nullNode()) {
            int e = this.m_lists.getElement(ptr);
            if (this.m_hash.equal(elementDescriptor, e)) {
                return ptr;
            }
            ptr = this.m_lists.getNext(ptr);
        }
        return IndexMultiList.nullNode();
    }

    public int getNextNode(int elementHandle) {
        int element = this.m_lists.getElement(elementHandle);
        int ptr = this.m_lists.getNext(elementHandle);
        while (ptr != IndexMultiList.nullNode()) {
            int e = this.m_lists.getElement(ptr);
            if (this.m_hash.equal(e, element)) {
                return ptr;
            }
            ptr = this.m_lists.getNext(ptr);
        }
        return IndexMultiList.nullNode();
    }

    public void deleteNode(int node) {
        int element = this.getElement(node);
        int hash = this.m_hash.getHash(element);
        int bucket = hash % this.m_hashBuckets.size();
        int list = this.m_hashBuckets.get(bucket);
        if (list == IndexMultiList.nullNode()) {
            throw new IllegalArgumentException();
        }
        int ptr = this.m_lists.getFirst(list);
        int prev = IndexMultiList.nullNode();
        while (ptr != IndexMultiList.nullNode()) {
            if (ptr == node) {
                this.m_lists.deleteElement(list, prev, ptr);
                if (this.m_lists.getFirst(list) == IndexMultiList.nullNode()) {
                    this.m_lists.deleteList(list);
                    this.m_hashBuckets.set(bucket, IndexMultiList.nullNode());
                }
                return;
            }
            prev = ptr;
            ptr = this.m_lists.getNext(ptr);
        }
        throw new IllegalArgumentException();
    }

    public int getElement(int elementHandle) {
        return this.m_lists.getElement(elementHandle);
    }

    public int getAnyElement() {
        return this.m_lists.getFirstElement(this.m_lists.getFirstList());
    }

    public int getAnyNode() {
        return this.m_lists.getFirst(this.m_lists.getFirstList());
    }

    public static int nullNode() {
        return IndexMultiList.nullNode();
    }

    public void clear() {
        this.m_hashBuckets = new AttributeStreamOfInt32(this.m_hashBuckets.size(), IndexHashTable.nullNode());
        this.m_lists.clear();
    }

    public int size() {
        return this.m_lists.getNodeCount();
    }

    public static abstract class HashFunction {
        public abstract int getHash(int var1);

        public abstract boolean equal(int var1, int var2);

        public abstract int getHash(Object var1);

        public abstract boolean equal(Object var1, int var2);
    }
}

