/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.EngineLevelExtensionServicesContext;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.TimeLengthBatchViewFactory;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeLengthBatchView
extends ViewSupport
implements StoppableView,
StopCallback,
DataWindowView {
    private static final Logger log = LoggerFactory.getLogger(TimeLengthBatchView.class);
    private final TimeLengthBatchViewFactory timeLengthBatchViewFactory;
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    protected final ExprTimePeriodEvalDeltaConst timeDeltaComputation;
    protected final long numberOfEvents;
    protected final boolean isForceOutput;
    protected final boolean isStartEager;
    protected final ViewUpdatedCollection viewUpdatedCollection;
    protected final long scheduleSlot;
    protected ArrayList<EventBean> lastBatch = null;
    protected ArrayList<EventBean> currentBatch = new ArrayList();
    protected Long callbackScheduledTime;
    protected EPStatementHandleCallback handle;

    public TimeLengthBatchView(TimeLengthBatchViewFactory timeBatchViewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext, ExprTimePeriodEvalDeltaConst timeDeltaComputation, long numberOfEvents, boolean forceOutput, boolean isStartEager, ViewUpdatedCollection viewUpdatedCollection) {
        this.agentInstanceContext = agentInstanceContext;
        this.timeLengthBatchViewFactory = timeBatchViewFactory;
        this.timeDeltaComputation = timeDeltaComputation;
        this.numberOfEvents = numberOfEvents;
        this.isStartEager = isStartEager;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.isForceOutput = forceOutput;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        if (isStartEager) {
            this.scheduleCallback(0L);
        }
        agentInstanceContext.addTerminationCallback(this);
    }

    public ExprTimePeriodEvalDeltaConst getTimeDeltaComputation() {
        return this.timeDeltaComputation;
    }

    public boolean isForceOutput() {
        return this.isForceOutput;
    }

    public long getNumberOfEvents() {
        return this.numberOfEvents;
    }

    public boolean isStartEager() {
        return this.isStartEager;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (oldData != null) {
            for (int i = 0; i < oldData.length; ++i) {
                if (!this.currentBatch.remove(oldData[i])) continue;
                this.internalHandleRemoved(oldData[i]);
            }
        }
        if (newData == null || newData.length == 0) {
            return;
        }
        for (EventBean newEvent : newData) {
            this.currentBatch.add(newEvent);
            this.internalHandleAdded(newEvent);
        }
        if ((long)this.currentBatch.size() < this.numberOfEvents) {
            if (this.callbackScheduledTime == null) {
                this.scheduleCallback(0L);
            }
            return;
        }
        this.sendBatch(false);
    }

    public void internalHandleAdded(EventBean newEvent) {
    }

    public void internalHandleRemoved(EventBean eventBean) {
    }

    protected void sendBatch(boolean isFromSchedule) {
        if (isFromSchedule) {
            this.callbackScheduledTime = null;
        } else if (this.callbackScheduledTime != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
            this.callbackScheduledTime = null;
        }
        if (this.hasViews()) {
            EventBean[] newData = null;
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                newData = this.currentBatch.toArray(new EventBean[this.currentBatch.size()]);
            }
            if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
                oldData = this.lastBatch.toArray(new EventBean[this.lastBatch.size()]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(newData, oldData);
            }
            if (newData != null || oldData != null || this.isForceOutput) {
                this.updateChildren(newData, oldData);
            }
        }
        if (!this.currentBatch.isEmpty() || this.lastBatch != null && !this.lastBatch.isEmpty() || this.isForceOutput) {
            this.scheduleCallback(0L);
        }
        this.lastBatch = this.currentBatch;
        this.currentBatch = new ArrayList();
    }

    public boolean isEmpty() {
        if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
            return false;
        }
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " numberOfEvents=" + this.numberOfEvents;
    }

    protected void scheduleCallback(long delta) {
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(EngineLevelExtensionServicesContext extensionServicesContext) {
                TimeLengthBatchView.this.sendBatch(true);
            }
        };
        this.handle = new EPStatementHandleCallback(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        long currentTime = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        long scheduled = this.timeDeltaComputation.deltaAdd(currentTime) - delta;
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(scheduled, this.handle, this.scheduleSlot);
        this.callbackScheduledTime = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime() + scheduled;
    }

    public void stopView() {
        this.stopSchedule();
        this.agentInstanceContext.removeTerminationCallback(this);
    }

    @Override
    public void stop() {
        this.stopSchedule();
    }

    public void stopSchedule() {
        if (this.handle != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.lastBatch, true, this.timeLengthBatchViewFactory.getViewName(), null);
        viewDataVisitor.visitPrimary(this.currentBatch, true, this.timeLengthBatchViewFactory.getViewName(), null);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.timeLengthBatchViewFactory;
    }
}

