/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowBatchingViewFactory;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewFactoryTimePeriodHelper;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.window.RelativeAccessByEventNIndexGetterImpl;
import com.espertech.esper.view.window.TimeBatchView;
import com.espertech.esper.view.window.TimeBatchViewFactoryParams;
import com.espertech.esper.view.window.TimeBatchViewRStream;
import java.util.List;

public class TimeBatchViewFactory
extends TimeBatchViewFactoryParams
implements DataWindowViewFactory,
DataWindowViewWithPrevious,
DataWindowBatchingViewFactory {
    protected Long optionalReferencePoint;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        if (expressionParameters.size() < 1 || expressionParameters.size() > 3) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        Object[] viewParamValues = new Object[expressionParameters.size()];
        for (int i = 1; i < viewParamValues.length; ++i) {
            viewParamValues[i] = ViewFactorySupport.validateAndEvaluate(this.getViewName(), viewFactoryContext.getStatementContext(), expressionParameters.get(i));
        }
        this.timeDeltaComputationFactory = ViewFactoryTimePeriodHelper.validateAndEvaluateTimeDeltaFactory(this.getViewName(), viewFactoryContext.getStatementContext(), expressionParameters.get(0), this.getViewParamMessage(), 0);
        if (viewParamValues.length == 2 && viewParamValues[1] instanceof String) {
            this.processKeywords(viewParamValues[1], this.getViewParamMessage());
        } else {
            if (viewParamValues.length >= 2) {
                Object paramRef = viewParamValues[1];
                if (!(paramRef instanceof Number) || JavaClassHelper.isFloatingPointNumber((Number)paramRef)) {
                    throw new ViewParameterException(this.getViewName() + " view requires a Long-typed reference point in msec as a second parameter");
                }
                this.optionalReferencePoint = ((Number)paramRef).longValue();
            }
            if (viewParamValues.length == 3) {
                this.processKeywords(viewParamValues[2], this.getViewParamMessage());
            }
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public Object makePreviousGetter() {
        return new RelativeAccessByEventNIndexGetterImpl();
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        ExprTimePeriodEvalDeltaConst timeDeltaComputation = this.timeDeltaComputationFactory.make(this.getViewName(), "view", agentInstanceViewFactoryContext.getAgentInstanceContext(), agentInstanceViewFactoryContext.getTimeAbacus());
        ViewUpdatedCollection viewUpdatedCollection = agentInstanceViewFactoryContext.getStatementContext().getViewServicePreviousFactory().getOptPreviousExprRelativeAccess(agentInstanceViewFactoryContext);
        if (agentInstanceViewFactoryContext.isRemoveStream()) {
            return new TimeBatchViewRStream(this, agentInstanceViewFactoryContext, timeDeltaComputation, this.optionalReferencePoint, this.isForceUpdate, this.isStartEager);
        }
        return new TimeBatchView(this, agentInstanceViewFactoryContext, timeDeltaComputation, this.optionalReferencePoint, this.isForceUpdate, this.isStartEager, viewUpdatedCollection);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view, AgentInstanceContext agentInstanceContext) {
        if (!(view instanceof TimeBatchView)) {
            return false;
        }
        TimeBatchView myView = (TimeBatchView)view;
        ExprTimePeriodEvalDeltaConst timeDeltaComputation = this.timeDeltaComputationFactory.make(this.getViewName(), "view", agentInstanceContext, agentInstanceContext.getTimeAbacus());
        if (!timeDeltaComputation.equalsTimePeriod(myView.getTimeDeltaComputation())) {
            return false;
        }
        if (myView.getInitialReferencePoint() != null && this.optionalReferencePoint != null && !myView.getInitialReferencePoint().equals((long)this.optionalReferencePoint)) {
            return false;
        }
        if (myView.getInitialReferencePoint() == null && this.optionalReferencePoint != null || myView.getInitialReferencePoint() != null && this.optionalReferencePoint == null) {
            return false;
        }
        if (myView.isForceOutput() != this.isForceUpdate) {
            return false;
        }
        if (myView.isStartEager()) {
            return false;
        }
        return myView.isEmpty();
    }

    @Override
    public String getViewName() {
        return "Time-Batch";
    }

    private String getViewParamMessage() {
        return this.getViewName() + " view requires a single numeric or time period parameter, and an optional long-typed reference point in msec, and an optional list of control keywords as a string parameter (please see the documentation)";
    }
}

