/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.EngineLevelExtensionServicesContext;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.TimeAccumViewFactory;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeAccumView
extends ViewSupport
implements DataWindowView,
StoppableView,
StopCallback {
    private final TimeAccumViewFactory factory;
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    protected final ExprTimePeriodEvalDeltaConst timeDeltaComputation;
    protected final ViewUpdatedCollection viewUpdatedCollection;
    protected final long scheduleSlot;
    protected ArrayList<EventBean> currentBatch = new ArrayList();
    protected long callbackScheduledTime;
    protected EPStatementHandleCallback handle;
    private static final Logger log = LoggerFactory.getLogger(TimeAccumView.class);

    public TimeAccumView(TimeAccumViewFactory timeBatchViewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext, ExprTimePeriodEvalDeltaConst timeDeltaComputation, ViewUpdatedCollection viewUpdatedCollection) {
        this.agentInstanceContext = agentInstanceContext;
        this.factory = timeBatchViewFactory;
        this.timeDeltaComputation = timeDeltaComputation;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(EngineLevelExtensionServicesContext extensionServicesContext) {
                TimeAccumView.this.sendRemoveStream();
            }
        };
        this.handle = new EPStatementHandleCallback(agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        agentInstanceContext.addTerminationCallback(this);
    }

    public ExprTimePeriodEvalDeltaConst getTimeDeltaComputation() {
        return this.timeDeltaComputation;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (newData == null || newData.length == 0) {
            return;
        }
        boolean removeSchedule = false;
        boolean addSchedule = false;
        long timestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        if (!this.currentBatch.isEmpty()) {
            long callbackTime = timestamp + this.timeDeltaComputation.deltaAdd(timestamp);
            if (callbackTime != this.callbackScheduledTime) {
                removeSchedule = true;
                addSchedule = true;
            }
        } else {
            addSchedule = true;
        }
        if (removeSchedule) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
        if (addSchedule) {
            long timeIntervalSize = this.timeDeltaComputation.deltaAdd(timestamp);
            this.agentInstanceContext.getStatementContext().getSchedulingService().add(timeIntervalSize, this.handle, this.scheduleSlot);
            this.callbackScheduledTime = timeIntervalSize + timestamp;
        }
        for (EventBean newEvent : newData) {
            this.currentBatch.add(newEvent);
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, null);
        }
        if (this.hasViews()) {
            this.updateChildren(newData, null);
        }
    }

    protected void sendRemoveStream() {
        this.callbackScheduledTime = -1L;
        if (this.hasViews()) {
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                oldData = this.currentBatch.toArray(new EventBean[this.currentBatch.size()]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(null, oldData);
            }
            if (oldData != null) {
                this.updateChildren(null, oldData);
            }
        }
        this.currentBatch.clear();
    }

    public boolean isEmpty() {
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName();
    }

    public void stopView() {
        this.stopSchedule();
        this.agentInstanceContext.removeTerminationCallback(this);
    }

    @Override
    public void stop() {
        this.stopSchedule();
    }

    public void stopSchedule() {
        if (this.handle != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.currentBatch, true, this.factory.getViewName(), null);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.factory;
    }
}

