/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.LengthWindowViewFactory;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class LengthWindowViewRStream
extends ViewSupport
implements DataWindowView {
    protected final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    private final LengthWindowViewFactory lengthWindowViewFactory;
    private final int size;
    protected LinkedHashSet<EventBean> indexedEvents;

    public LengthWindowViewRStream(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext, LengthWindowViewFactory lengthWindowViewFactory, int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Illegal argument for size of length window");
        }
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.lengthWindowViewFactory = lengthWindowViewFactory;
        this.size = size;
        this.indexedEvents = new LinkedHashSet();
    }

    public boolean isEmpty() {
        return this.indexedEvents.isEmpty();
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        int expiredCount;
        EventBean[] expiredArr = null;
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                this.indexedEvents.remove(anOldData);
                this.internalHandleRemoved(anOldData);
            }
            expiredArr = oldData;
        }
        if (newData != null) {
            for (EventBean newEvent : newData) {
                this.indexedEvents.add(newEvent);
                this.internalHandleAdded(newEvent);
            }
        }
        if ((expiredCount = this.indexedEvents.size() - this.size) > 0) {
            expiredArr = new EventBean[expiredCount];
            Iterator it = this.indexedEvents.iterator();
            for (int i = 0; i < expiredCount; ++i) {
                expiredArr[i] = (EventBean)it.next();
            }
            for (EventBean anExpired : expiredArr) {
                this.indexedEvents.remove(anExpired);
                this.internalHandleExpired(anExpired);
            }
        }
        if (this.hasViews()) {
            this.updateChildren(newData, expiredArr);
        }
    }

    public void internalHandleExpired(EventBean oldData) {
    }

    public void internalHandleRemoved(EventBean expiredData) {
    }

    public void internalHandleAdded(EventBean newData) {
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.indexedEvents.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " size=" + this.size;
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.indexedEvents, true, this.lengthWindowViewFactory.getViewName(), null);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.lengthWindowViewFactory;
    }
}

