/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.window.LengthWindowView;
import com.espertech.esper.view.window.LengthWindowViewRStream;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import java.util.List;

public class LengthWindowViewFactory
implements DataWindowViewFactory,
DataWindowViewWithPrevious {
    protected ExprEvaluator sizeEvaluator;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.sizeEvaluator = ViewFactorySupport.validateSizeSingleParam(this.getViewName(), viewFactoryContext, expressionParameters);
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public Object makePreviousGetter() {
        return new RandomAccessByIndexGetter();
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        int size = ViewFactorySupport.evaluateSizeParam(this.getViewName(), this.sizeEvaluator, agentInstanceViewFactoryContext.getAgentInstanceContext());
        ViewUpdatedCollection randomAccess = agentInstanceViewFactoryContext.getStatementContext().getViewServicePreviousFactory().getOptPreviousExprRandomAccess(agentInstanceViewFactoryContext);
        if (agentInstanceViewFactoryContext.isRemoveStream()) {
            return new LengthWindowViewRStream(agentInstanceViewFactoryContext, this, size);
        }
        return new LengthWindowView(agentInstanceViewFactoryContext, this, size, randomAccess);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view, AgentInstanceContext agentInstanceContext) {
        if (!(view instanceof LengthWindowView)) {
            return false;
        }
        LengthWindowView myView = (LengthWindowView)view;
        int size = ViewFactorySupport.evaluateSizeParam(this.getViewName(), this.sizeEvaluator, agentInstanceContext);
        return myView.getSize() == size && myView.isEmpty();
    }

    @Override
    public String getViewName() {
        return "Length";
    }
}

