/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.codegen.ExprNodeCompiler;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConstFactory;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewFactoryTimePeriodHelper;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.window.ExternallyTimedWindowView;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import java.util.List;

public class ExternallyTimedWindowViewFactory
implements DataWindowViewFactory,
DataWindowViewWithPrevious {
    private List<ExprNode> viewParameters;
    private EventType eventType;
    protected ExprNode timestampExpression;
    protected ExprEvaluator timestampExpressionEval;
    protected ExprTimePeriodEvalDeltaConstFactory timeDeltaComputationFactory;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        ExprNode[] validated = ViewFactorySupport.validate(this.getViewName(), parentEventType, statementContext, this.viewParameters, true);
        if (this.viewParameters.size() != 2) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        if (!JavaClassHelper.isNumeric(validated[0].getForge().getEvaluationType())) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        this.timestampExpression = validated[0];
        this.timestampExpressionEval = ExprNodeCompiler.allocateEvaluator(this.timestampExpression.getForge(), statementContext.getEngineImportService(), this.getClass(), false, statementContext.getStatementName());
        ViewFactorySupport.assertReturnsNonConstant(this.getViewName(), validated[0], 0);
        this.timeDeltaComputationFactory = ViewFactoryTimePeriodHelper.validateAndEvaluateTimeDeltaFactory(this.getViewName(), statementContext, this.viewParameters.get(1), this.getViewParamMessage(), 1);
        this.eventType = parentEventType;
    }

    @Override
    public Object makePreviousGetter() {
        return new RandomAccessByIndexGetter();
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        ExprTimePeriodEvalDeltaConst timeDeltaComputation = this.timeDeltaComputationFactory.make(this.getViewName(), "view", agentInstanceViewFactoryContext.getAgentInstanceContext(), agentInstanceViewFactoryContext.getTimeAbacus());
        ViewUpdatedCollection randomAccess = agentInstanceViewFactoryContext.getStatementContext().getViewServicePreviousFactory().getOptPreviousExprRandomAccess(agentInstanceViewFactoryContext);
        return new ExternallyTimedWindowView(this, this.timestampExpression, this.timestampExpressionEval, timeDeltaComputation, randomAccess, agentInstanceViewFactoryContext);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view, AgentInstanceContext agentInstanceContext) {
        if (!(view instanceof ExternallyTimedWindowView)) {
            return false;
        }
        ExternallyTimedWindowView myView = (ExternallyTimedWindowView)view;
        ExprTimePeriodEvalDeltaConst delta = this.timeDeltaComputationFactory.make(this.getViewName(), "view", agentInstanceContext, agentInstanceContext.getTimeAbacus());
        if (!delta.equalsTimePeriod(myView.getTimeDeltaComputation()) || !ExprNodeUtilityCore.deepEquals(myView.getTimestampExpression(), this.timestampExpression, false)) {
            return false;
        }
        return myView.isEmpty();
    }

    @Override
    public String getViewName() {
        return "Externally-timed";
    }

    public ExprEvaluator getTimestampExpressionEval() {
        return this.timestampExpressionEval;
    }

    private String getViewParamMessage() {
        return this.getViewName() + " view requires a timestamp expression and a numeric or time period parameter for window size";
    }
}

