/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.internal.TimeWindow;
import com.espertech.esper.view.window.ExternallyTimedWindowViewFactory;
import java.util.ArrayDeque;
import java.util.Iterator;

public class ExternallyTimedWindowView
extends ViewSupport
implements DataWindowView {
    private final ExternallyTimedWindowViewFactory externallyTimedWindowViewFactory;
    private final ExprNode timestampExpression;
    private final ExprEvaluator timestampExpressionEval;
    private final ExprTimePeriodEvalDeltaConst timeDeltaComputation;
    private final EventBean[] eventsPerStream = new EventBean[1];
    protected final TimeWindow timeWindow;
    private ViewUpdatedCollection viewUpdatedCollection;
    protected AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;

    public ExternallyTimedWindowView(ExternallyTimedWindowViewFactory externallyTimedWindowViewFactory, ExprNode timestampExpression, ExprEvaluator timestampExpressionEval, ExprTimePeriodEvalDeltaConst timeDeltaComputation, ViewUpdatedCollection viewUpdatedCollection, AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        this.externallyTimedWindowViewFactory = externallyTimedWindowViewFactory;
        this.timestampExpression = timestampExpression;
        this.timestampExpressionEval = timestampExpressionEval;
        this.timeDeltaComputation = timeDeltaComputation;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.timeWindow = new TimeWindow(agentInstanceViewFactoryContext.isRemoveStream());
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
    }

    public final ExprNode getTimestampExpression() {
        return this.timestampExpression;
    }

    public ExprTimePeriodEvalDeltaConst getTimeDeltaComputation() {
        return this.timeDeltaComputation;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        long timestamp = -1L;
        if (newData != null) {
            for (int i = 0; i < newData.length; ++i) {
                timestamp = this.getLongValue(newData[i]);
                this.timeWindow.add(timestamp, newData[i]);
            }
        }
        ArrayDeque<EventBean> expired = null;
        if (timestamp != -1L) {
            expired = this.timeWindow.expireEvents(timestamp - this.timeDeltaComputation.deltaSubtract(timestamp) + 1L);
        }
        EventBean[] oldDataUpdate = null;
        if (expired != null && !expired.isEmpty()) {
            oldDataUpdate = expired.toArray(new EventBean[expired.size()]);
        }
        if (oldData != null && this.agentInstanceViewFactoryContext.isRemoveStream()) {
            for (EventBean anOldData : oldData) {
                this.timeWindow.remove(anOldData);
            }
            oldDataUpdate = oldDataUpdate == null ? oldData : CollectionUtil.addArrayWithSetSemantics(oldData, oldDataUpdate);
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, oldDataUpdate);
        }
        if (this.hasViews()) {
            this.updateChildren(newData, oldDataUpdate);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.timeWindow.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " timestampExpression=" + this.timestampExpression;
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        this.timeWindow.visitView(viewDataVisitor, this.externallyTimedWindowViewFactory);
    }

    private long getLongValue(EventBean obj) {
        this.eventsPerStream[0] = obj;
        Number num = (Number)this.timestampExpressionEval.evaluate(this.eventsPerStream, true, this.agentInstanceViewFactoryContext);
        return num.longValue();
    }

    public boolean isEmpty() {
        return this.timeWindow.isEmpty();
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.externallyTimedWindowViewFactory;
    }
}

