/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.EngineLevelExtensionServicesContext;
import com.espertech.esper.epl.agg.service.common.AggregationService;
import com.espertech.esper.epl.agg.service.common.AggregationServiceAggExpressionDesc;
import com.espertech.esper.epl.agg.service.common.AggregationServiceFactoryDesc;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.variable.VariableChangeCallback;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.arr.ObjectArrayEventBean;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.ViewSupport;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class ExpressionViewBase
extends ViewSupport
implements DataWindowView,
StoppableView,
VariableChangeCallback,
StopCallback {
    protected final ViewUpdatedCollection viewUpdatedCollection;
    protected final ExprEvaluator expiryExpression;
    protected final ObjectArrayEventBean builtinEventProps;
    protected final EventBean[] eventsPerStream;
    protected final Set<String> variableNames;
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    protected final long scheduleSlot;
    protected final EPStatementHandleCallback scheduleHandle;
    protected final AggregationService aggregationService;
    protected final List<AggregationServiceAggExpressionDesc> aggregateNodes;

    public abstract void scheduleCallback();

    public abstract String getViewName();

    public ExpressionViewBase(ViewUpdatedCollection viewUpdatedCollection, ExprEvaluator expiryExpression, AggregationServiceFactoryDesc aggregationServiceFactoryDesc, ObjectArrayEventBean builtinEventProps, Set<String> variableNames, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.expiryExpression = expiryExpression;
        this.builtinEventProps = builtinEventProps;
        this.eventsPerStream = new EventBean[]{null, builtinEventProps};
        this.variableNames = variableNames;
        this.agentInstanceContext = agentInstanceContext;
        if (variableNames != null && !variableNames.isEmpty()) {
            Iterator<String> iterator = variableNames.iterator();
            while (iterator.hasNext()) {
                String variable;
                final String variableName = variable = iterator.next();
                final int agentInstanceId = agentInstanceContext.getAgentInstanceId();
                final VariableService variableService = agentInstanceContext.getStatementContext().getVariableService();
                agentInstanceContext.getStatementContext().getVariableService().registerCallback(variable, agentInstanceId, this);
                agentInstanceContext.addTerminationCallback(new StopCallback(){

                    @Override
                    public void stop() {
                        variableService.unregisterCallback(variableName, agentInstanceId, ExpressionViewBase.this);
                    }
                });
            }
            ScheduleHandleCallback callback = new ScheduleHandleCallback(){

                @Override
                public void scheduledTrigger(EngineLevelExtensionServicesContext extensionServicesContext) {
                    ExpressionViewBase.this.scheduleCallback();
                }
            };
            this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
            this.scheduleHandle = new EPStatementHandleCallback(agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
            agentInstanceContext.addTerminationCallback(this);
        } else {
            this.scheduleSlot = -1L;
            this.scheduleHandle = null;
        }
        if (aggregationServiceFactoryDesc != null) {
            this.aggregationService = aggregationServiceFactoryDesc.getAggregationServiceFactory().makeService(agentInstanceContext.getAgentInstanceContext(), agentInstanceContext.getAgentInstanceContext().getStatementContext().getEngineImportService(), false, null);
            this.aggregateNodes = aggregationServiceFactoryDesc.getExpressions();
        } else {
            this.aggregationService = null;
            this.aggregateNodes = Collections.emptyList();
        }
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    public final String toString() {
        return this.getClass().getName();
    }

    public void stopView() {
        this.stopScheduleAndVar();
        this.agentInstanceContext.removeTerminationCallback(this);
    }

    @Override
    public void stop() {
        this.stopScheduleAndVar();
    }

    public void stopScheduleAndVar() {
        if (this.variableNames != null && !this.variableNames.isEmpty()) {
            for (String variable : this.variableNames) {
                this.agentInstanceContext.getStatementContext().getVariableService().unregisterCallback(variable, this.agentInstanceContext.getAgentInstanceId(), this);
            }
            if (this.agentInstanceContext.getStatementContext().getSchedulingService().isScheduled(this.scheduleHandle)) {
                this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
            }
        }
    }

    @Override
    public void update(Object newValue, Object oldValue) {
        if (!this.agentInstanceContext.getStatementContext().getSchedulingService().isScheduled(this.scheduleHandle)) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().add(0L, this.scheduleHandle, this.scheduleSlot);
        }
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    public AggregationService getAggregationService() {
        return this.aggregationService;
    }
}

