/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.OneEventCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.std.UniqueByPropertyViewFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UniqueByPropertyView
extends ViewSupport
implements DataWindowView {
    private final UniqueByPropertyViewFactory viewFactory;
    protected final Map<Object, EventBean> mostRecentEvents = new HashMap<Object, EventBean>();
    private final EventBean[] eventsPerStream = new EventBean[1];
    protected final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;

    public UniqueByPropertyView(UniqueByPropertyViewFactory viewFactory, AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        this.viewFactory = viewFactory;
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
    }

    public final ExprNode[] getCriteriaExpressions() {
        return this.viewFactory.criteriaExpressions;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        EventBean lastValue;
        Object key;
        int i;
        OneEventCollection postOldData = null;
        if (this.hasViews()) {
            postOldData = new OneEventCollection();
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                key = this.getUniqueKey(newData[i]);
                if (!this.hasViews()) {
                    this.mostRecentEvents.put(key, newData[i]);
                    continue;
                }
                lastValue = this.mostRecentEvents.get(key);
                if (lastValue != null) {
                    postOldData.add(lastValue);
                }
                this.mostRecentEvents.put(key, newData[i]);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                key = this.getUniqueKey(oldData[i]);
                lastValue = this.mostRecentEvents.get(key);
                if (lastValue == null || !lastValue.equals(oldData[i])) continue;
                postOldData.add(lastValue);
                this.mostRecentEvents.remove(key);
            }
        }
        if (this.hasViews()) {
            if (postOldData.isEmpty()) {
                this.updateChildren(newData, null);
            } else {
                EventBean[] postOldDataArray = postOldData.toArray();
                this.updateChildren(newData, postOldDataArray);
            }
        }
    }

    public boolean isEmpty() {
        return this.mostRecentEvents.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.mostRecentEvents.values().iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " uniqueFieldNames=" + Arrays.toString(this.viewFactory.criteriaExpressions);
    }

    protected Object getUniqueKey(EventBean theEvent) {
        this.eventsPerStream[0] = theEvent;
        ExprEvaluator[] criteriaExpressionsEvals = this.viewFactory.criteriaExpressionsEvals;
        if (criteriaExpressionsEvals.length == 1) {
            return criteriaExpressionsEvals[0].evaluate(this.eventsPerStream, true, this.agentInstanceViewFactoryContext);
        }
        Object[] values = new Object[criteriaExpressionsEvals.length];
        for (int i = 0; i < criteriaExpressionsEvals.length; ++i) {
            values[i] = criteriaExpressionsEvals[i].evaluate(this.eventsPerStream, true, this.agentInstanceViewFactoryContext);
        }
        return new MultiKeyUntyped(values);
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.mostRecentEvents, true, "Unique-By", this.mostRecentEvents.size(), this.mostRecentEvents.size());
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.viewFactory;
    }
}

