/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EPException;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.view.GroupableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.std.AddPropertyValueOptionalView;
import com.espertech.esper.view.std.GroupByView;
import com.espertech.esper.view.std.MergeView;
import com.espertech.esper.view.std.MergeViewMarker;

public class GroupByViewUtil {
    public static View makeSubView(GroupByView groupView, Object groupByValues, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        if (!groupView.hasViews()) {
            String message = "Unexpected empty list of child nodes for group view";
            throw new EPException(message);
        }
        return GroupByViewUtil.copyChildView(groupView, groupByValues, agentInstanceContext, groupView.getViews()[0]);
    }

    private static View copyChildView(GroupByView groupView, Object groupByValues, AgentInstanceViewFactoryChainContext agentInstanceContext, View originalChildView) {
        if (originalChildView instanceof MergeView) {
            String message = "Unexpected merge view as child of group-by view";
            throw new EPException(message);
        }
        GroupableView cloneableView = (GroupableView)((Object)originalChildView);
        View copyChildView = cloneableView.getViewFactory().makeView(agentInstanceContext);
        copyChildView.setParent(groupView);
        GroupByViewUtil.copySubViews(groupView, groupByValues, originalChildView, copyChildView, agentInstanceContext);
        return copyChildView;
    }

    private static void copySubViews(GroupByView groupByView, Object groupByValues, View originalView, View copyView, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        for (View subView : originalView.getViews()) {
            MergeViewMarker mergeView;
            if (subView instanceof MergeViewMarker && ExprNodeUtilityCore.deepEquals((mergeView = (MergeViewMarker)subView).getGroupFieldNames(), groupByView.getViewFactory().getCriteriaExpressions(), false)) {
                if (mergeView.getEventType() != copyView.getEventType()) {
                    AddPropertyValueOptionalView addPropertyView = new AddPropertyValueOptionalView(agentInstanceContext, groupByView.getViewFactory().getPropertyNames(), groupByValues, mergeView.getEventType());
                    copyView.addView(addPropertyView);
                    addPropertyView.addView(mergeView);
                    mergeView.addParentView(addPropertyView);
                    continue;
                }
                copyView.addView(mergeView);
                mergeView.addParentView(copyView);
                continue;
            }
            GroupableView cloneableView = (GroupableView)((Object)subView);
            View copiedChild = cloneableView.getViewFactory().makeView(agentInstanceContext);
            copyView.addView(copiedChild);
            GroupByViewUtil.copySubViews(groupByView, groupByValues, subView, copiedChild, agentInstanceContext);
        }
    }
}

