/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.GroupableView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewDataVisitorContained;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.std.GroupByView;
import com.espertech.esper.view.std.GroupByViewAgedEntry;
import com.espertech.esper.view.std.GroupByViewFactory;
import com.espertech.esper.view.std.GroupByViewImpl;
import com.espertech.esper.view.std.GroupByViewUtil;
import com.espertech.esper.view.std.MergeView;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByViewReclaimAged
extends ViewSupport
implements GroupByView {
    protected final GroupByViewFactory groupByViewFactory;
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private EventBean[] eventsPerStream = new EventBean[1];
    protected final Map<Object, GroupByViewAgedEntry> subViewPerKey = new HashMap<Object, GroupByViewAgedEntry>();
    private final HashMap<GroupByViewAgedEntry, Pair<Object, Object>> groupedEvents = new HashMap();
    private Long nextSweepTime = null;
    private static final Logger log = LoggerFactory.getLogger(GroupByViewReclaimAged.class);

    public GroupByViewReclaimAged(GroupByViewFactory groupByViewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        this.groupByViewFactory = groupByViewFactory;
        this.agentInstanceContext = agentInstanceContext;
    }

    public ExprNode[] getCriteriaExpressions() {
        return this.groupByViewFactory.getCriteriaExpressions();
    }

    @Override
    public GroupByViewFactory getViewFactory() {
        return this.groupByViewFactory;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        long currentTime = this.agentInstanceContext.getTimeProvider().getTime();
        if (this.nextSweepTime == null || this.nextSweepTime <= currentTime) {
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug("Reclaiming groups older then " + this.groupByViewFactory.getReclaimMaxAge() + " msec and every " + this.groupByViewFactory.getReclaimFrequency() + "msec in frequency");
            }
            this.nextSweepTime = currentTime + this.groupByViewFactory.getReclaimFrequency();
            this.sweep(currentTime);
        }
        if (newData != null && oldData == null && newData.length == 1) {
            EventBean theEvent = newData[0];
            EventBean[] eventBeanArray = new EventBean[]{theEvent};
            Object groupByValuesKey = this.getGroupKey(theEvent);
            GroupByViewAgedEntry subView = this.subViewPerKey.get(groupByValuesKey);
            if (subView == null) {
                View subview = GroupByViewUtil.makeSubView(this, groupByValuesKey, this.agentInstanceContext);
                subView = new GroupByViewAgedEntry(subview, currentTime);
                this.subViewPerKey.put(groupByValuesKey, subView);
            } else {
                subView.setLastUpdateTime(currentTime);
            }
            subView.getSubview().update(newData, null);
        } else {
            if (newData != null) {
                for (EventBean newValue : newData) {
                    this.handleEvent(newValue, true);
                }
            }
            if (oldData != null) {
                for (EventBean oldValue : oldData) {
                    this.handleEvent(oldValue, false);
                }
            }
            for (Map.Entry entry : this.groupedEvents.entrySet()) {
                EventBean[] newEvents = GroupByViewImpl.convertToArray(((Pair)entry.getValue()).getFirst());
                EventBean[] oldEvents = GroupByViewImpl.convertToArray(((Pair)entry.getValue()).getSecond());
                ((GroupByViewAgedEntry)entry.getKey()).getSubview().update(newEvents, oldEvents);
            }
            this.groupedEvents.clear();
        }
    }

    private void handleEvent(EventBean theEvent, boolean isNew) {
        Object groupByValuesKey = this.getGroupKey(theEvent);
        GroupByViewAgedEntry subViews = this.subViewPerKey.get(groupByValuesKey);
        if (subViews == null) {
            View subview = GroupByViewUtil.makeSubView(this, groupByValuesKey, this.agentInstanceContext);
            long currentTime = this.agentInstanceContext.getStatementContext().getTimeProvider().getTime();
            subViews = new GroupByViewAgedEntry(subview, currentTime);
            this.subViewPerKey.put(groupByValuesKey, subViews);
        } else {
            subViews.setLastUpdateTime(this.agentInstanceContext.getStatementContext().getTimeProvider().getTime());
        }
        Pair<Object, Object> pair = this.groupedEvents.get(subViews);
        if (pair == null) {
            pair = new Pair<Object, Object>(null, null);
            this.groupedEvents.put(subViews, pair);
        }
        if (isNew) {
            pair.setFirst(GroupByViewImpl.addUpgradeToDequeIfPopulated(pair.getFirst(), theEvent));
        } else {
            pair.setSecond(GroupByViewImpl.addUpgradeToDequeIfPopulated(pair.getSecond(), theEvent));
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        throw new UnsupportedOperationException("Cannot iterate over group view, this operation is not supported");
    }

    public final String toString() {
        return this.getClass().getName() + " groupFieldNames=" + Arrays.toString(this.groupByViewFactory.getPropertyNames());
    }

    @Override
    public void visitViewContainer(ViewDataVisitorContained viewDataVisitor) {
        viewDataVisitor.visitPrimary("Group-By", this.subViewPerKey.size());
        for (Map.Entry<Object, GroupByViewAgedEntry> entry : this.subViewPerKey.entrySet()) {
            GroupByViewImpl.visitView(viewDataVisitor, entry.getKey(), entry.getValue().getSubview());
        }
    }

    private void sweep(long currentTime) {
        ArrayDeque<Object> removed = new ArrayDeque<Object>();
        for (Map.Entry<Object, GroupByViewAgedEntry> entry : this.subViewPerKey.entrySet()) {
            long age = currentTime - entry.getValue().getLastUpdateTime();
            if (age <= this.groupByViewFactory.getReclaimMaxAge()) continue;
            removed.add(entry.getKey());
        }
        for (Map.Entry<Object, GroupByViewAgedEntry> entry : removed) {
            GroupByViewAgedEntry entry2 = this.subViewPerKey.remove(entry);
            this.removeSubview(entry2.getSubview());
        }
    }

    @Override
    public boolean removeView(View view) {
        boolean removed;
        if (!(view instanceof GroupableView)) {
            super.removeView(view);
        }
        if (!(removed = super.removeView(view))) {
            return false;
        }
        if (!this.hasViews()) {
            this.subViewPerKey.clear();
            return true;
        }
        GroupableView removedView = (GroupableView)((Object)view);
        ArrayDeque<Object> removedKeys = null;
        for (Map.Entry<Object, GroupByViewAgedEntry> entry : this.subViewPerKey.entrySet()) {
            View value = entry.getValue().getSubview();
            GroupableView subview = (GroupableView)((Object)value);
            if (!this.compareViews(subview, removedView)) continue;
            if (removedKeys == null) {
                removedKeys = new ArrayDeque<Object>();
            }
            removedKeys.add(entry.getKey());
        }
        if (removedKeys != null) {
            for (Map.Entry<Object, GroupByViewAgedEntry> entry : removedKeys) {
                this.subViewPerKey.remove(entry);
            }
        }
        return true;
    }

    private boolean compareViews(GroupableView subview, GroupableView removed) {
        return subview.getViewFactory() == removed.getViewFactory();
    }

    private void removeSubview(View view) {
        view.setParent(null);
        this.recursiveMergeViewRemove(view);
        if (view instanceof StoppableView) {
            ((StoppableView)((Object)view)).stop();
        }
    }

    private void recursiveMergeViewRemove(View view) {
        for (View child : view.getViews()) {
            if (child instanceof MergeView) {
                MergeView mergeView = (MergeView)child;
                mergeView.removeParentView(view);
                continue;
            }
            if (child instanceof StoppableView) {
                ((StoppableView)((Object)child)).stop();
            }
            if (child.getViews().length <= 0) continue;
            this.recursiveMergeViewRemove(child);
        }
    }

    private Object getGroupKey(EventBean theEvent) {
        this.eventsPerStream[0] = theEvent;
        ExprEvaluator[] criteriaEvaluators = this.groupByViewFactory.getCriteriaExpressionEvals();
        if (criteriaEvaluators.length == 1) {
            return criteriaEvaluators[0].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        }
        Object[] values = new Object[criteriaEvaluators.length];
        for (int i = 0; i < criteriaEvaluators.length; ++i) {
            values[i] = criteriaEvaluators[i].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        }
        return new MultiKeyUntyped(values);
    }
}

