/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.view.GroupableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewDataVisitorContained;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.std.GroupByView;
import com.espertech.esper.view.std.GroupByViewFactory;
import com.espertech.esper.view.std.GroupByViewUtil;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByViewImpl
extends ViewSupport
implements GroupByView {
    public static final String VIEWNAME = "Group-By";
    private final GroupByViewFactory groupByViewFactory;
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private EventBean[] eventsPerStream = new EventBean[1];
    protected final Map<Object, View> subViewPerKey = new HashMap<Object, View>();
    private final HashMap<View, Pair<Object, Object>> groupedEvents = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(GroupByViewImpl.class);

    public GroupByViewImpl(GroupByViewFactory groupByViewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        this.groupByViewFactory = groupByViewFactory;
        this.agentInstanceContext = agentInstanceContext;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public GroupByViewFactory getViewFactory() {
        return this.groupByViewFactory;
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null && oldData == null && newData.length == 1) {
            EventBean theEvent = newData[0];
            EventBean[] eventBeanArray = new EventBean[]{theEvent};
            Object groupByValuesKey = this.getGroupKey(theEvent);
            View subView = this.subViewPerKey.get(groupByValuesKey);
            if (subView == null) {
                subView = GroupByViewUtil.makeSubView(this, groupByValuesKey, this.agentInstanceContext);
                this.subViewPerKey.put(groupByValuesKey, subView);
            }
            subView.update(eventBeanArray, null);
        } else {
            if (newData != null) {
                for (EventBean newValue : newData) {
                    this.handleEvent(newValue, true);
                }
            }
            if (oldData != null) {
                for (EventBean oldValue : oldData) {
                    this.handleEvent(oldValue, false);
                }
            }
            for (Map.Entry entry : this.groupedEvents.entrySet()) {
                EventBean[] newEvents = GroupByViewImpl.convertToArray(((Pair)entry.getValue()).getFirst());
                EventBean[] oldEvents = GroupByViewImpl.convertToArray(((Pair)entry.getValue()).getSecond());
                ((View)entry.getKey()).update(newEvents, oldEvents);
            }
            this.groupedEvents.clear();
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        throw new UnsupportedOperationException("Cannot iterate over group view, this operation is not supported");
    }

    public final String toString() {
        return this.getClass().getName() + " groupFieldNames=" + Arrays.toString(this.groupByViewFactory.getPropertyNames());
    }

    @Override
    public void visitViewContainer(ViewDataVisitorContained viewDataVisitor) {
        viewDataVisitor.visitPrimary(VIEWNAME, this.subViewPerKey.size());
        for (Map.Entry<Object, View> entry : this.subViewPerKey.entrySet()) {
            GroupByViewImpl.visitView(viewDataVisitor, entry.getKey(), entry.getValue());
        }
    }

    public static void visitView(ViewDataVisitorContained viewDataVisitor, Object groupkey, View view) {
        if (view == null) {
            return;
        }
        viewDataVisitor.visitContained(groupkey, view);
    }

    @Override
    public boolean removeView(View view) {
        boolean removed;
        if (!(view instanceof GroupableView)) {
            super.removeView(view);
        }
        if (!(removed = super.removeView(view))) {
            return false;
        }
        if (!this.hasViews()) {
            this.subViewPerKey.clear();
            return true;
        }
        GroupableView removedView = (GroupableView)((Object)view);
        ArrayDeque<Object> removedKeys = null;
        for (Map.Entry<Object, View> entry : this.subViewPerKey.entrySet()) {
            View value = entry.getValue();
            GroupableView subview = (GroupableView)((Object)value);
            if (!this.compareViews(subview, removedView)) continue;
            if (removedKeys == null) {
                removedKeys = new ArrayDeque<Object>();
            }
            removedKeys.add(entry.getKey());
        }
        if (removedKeys != null) {
            for (Map.Entry<Object, View> entry : removedKeys) {
                this.subViewPerKey.remove(entry);
            }
        }
        return true;
    }

    private boolean compareViews(GroupableView subview, GroupableView removed) {
        return subview.getViewFactory() == removed.getViewFactory();
    }

    private void handleEvent(EventBean theEvent, boolean isNew) {
        Pair<Object, Object> pair;
        Object groupByValuesKey = this.getGroupKey(theEvent);
        View subView = this.subViewPerKey.get(groupByValuesKey);
        if (subView == null) {
            subView = GroupByViewUtil.makeSubView(this, groupByValuesKey, this.agentInstanceContext);
            this.subViewPerKey.put(groupByValuesKey, subView);
        }
        if ((pair = this.groupedEvents.get(subView)) == null) {
            pair = new Pair<Object, Object>(null, null);
            this.groupedEvents.put(subView, pair);
        }
        if (isNew) {
            pair.setFirst(GroupByViewImpl.addUpgradeToDequeIfPopulated(pair.getFirst(), theEvent));
        } else {
            pair.setSecond(GroupByViewImpl.addUpgradeToDequeIfPopulated(pair.getSecond(), theEvent));
        }
    }

    private Object getGroupKey(EventBean theEvent) {
        this.eventsPerStream[0] = theEvent;
        ExprEvaluator[] criteriaEvaluators = this.groupByViewFactory.getCriteriaExpressionEvals();
        if (criteriaEvaluators.length == 1) {
            return criteriaEvaluators[0].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        }
        Object[] values = new Object[criteriaEvaluators.length];
        for (int i = 0; i < criteriaEvaluators.length; ++i) {
            values[i] = criteriaEvaluators[i].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        }
        return new MultiKeyUntyped(values);
    }

    protected static Object addUpgradeToDequeIfPopulated(Object holder, EventBean theEvent) {
        if (holder == null) {
            return theEvent;
        }
        if (holder instanceof Deque) {
            Deque deque = (Deque)holder;
            deque.add(theEvent);
            return deque;
        }
        ArrayDeque<EventBean> deque = new ArrayDeque<EventBean>(4);
        deque.add((EventBean)holder);
        deque.add(theEvent);
        return deque;
    }

    protected static EventBean[] convertToArray(Object eventOrDeque) {
        if (eventOrDeque == null) {
            return null;
        }
        if (eventOrDeque instanceof EventBean) {
            return new EventBean[]{(EventBean)eventOrDeque};
        }
        return EventBeanUtility.toArray((ArrayDeque)eventOrDeque);
    }
}

