/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.std.GroupByViewFactoryMarker;
import com.espertech.esper.view.std.GroupByViewImpl;
import com.espertech.esper.view.std.GroupByViewReclaimAged;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByViewFactory
implements ViewFactory,
GroupByViewFactoryMarker {
    private static final Logger log = LoggerFactory.getLogger(GroupByViewFactory.class);
    protected List<ExprNode> viewParameters;
    protected ExprNode[] criteriaExpressions;
    protected ExprEvaluator[] criteriaExpressionEvals;
    protected String[] propertyNames;
    private EventType eventType;
    protected boolean isReclaimAged;
    protected long reclaimMaxAge;
    protected long reclaimFrequency;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
        TimeAbacus timeAbacus = viewFactoryContext.getStatementContext().getEngineImportService().getTimeAbacus();
        Hint reclaimGroupAged = HintEnum.RECLAIM_GROUP_AGED.getHint(viewFactoryContext.getStatementContext().getAnnotations());
        if (reclaimGroupAged != null) {
            this.isReclaimAged = true;
            String hintValueMaxAge = HintEnum.RECLAIM_GROUP_AGED.getHintAssignedValue(reclaimGroupAged);
            if (hintValueMaxAge == null) {
                throw new ViewParameterException("Required hint value for hint '" + (Object)((Object)HintEnum.RECLAIM_GROUP_AGED) + "' has not been provided");
            }
            try {
                this.reclaimMaxAge = timeAbacus.deltaForSecondsDouble(Double.parseDouble(hintValueMaxAge));
            }
            catch (RuntimeException ex) {
                throw new ViewParameterException("Required hint value for hint '" + (Object)((Object)HintEnum.RECLAIM_GROUP_AGED) + "' value '" + hintValueMaxAge + "' could not be parsed as a double value");
            }
            String hintValueFrequency = HintEnum.RECLAIM_GROUP_FREQ.getHintAssignedValue(reclaimGroupAged);
            if (hintValueFrequency == null) {
                this.reclaimFrequency = this.reclaimMaxAge;
            } else {
                try {
                    this.reclaimFrequency = timeAbacus.deltaForSecondsDouble(Double.parseDouble(hintValueFrequency));
                }
                catch (RuntimeException ex) {
                    throw new ViewParameterException("Required hint value for hint '" + (Object)((Object)HintEnum.RECLAIM_GROUP_FREQ) + "' value '" + hintValueFrequency + "' could not be parsed as a double value");
                }
            }
            if (this.reclaimMaxAge < 1L) {
                log.warn("Reclaim max age parameter is less then 1, are your sure?");
            }
            if (log.isDebugEnabled()) {
                log.debug("Using reclaim-aged strategy for group-window age " + this.reclaimMaxAge + " frequency " + this.reclaimFrequency);
            }
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.criteriaExpressions = ViewFactorySupport.validate(this.getViewName(), parentEventType, statementContext, this.viewParameters, false);
        if (this.criteriaExpressions.length == 0) {
            String errorMessage = this.getViewName() + " view requires a one or more expressions provinding unique values as parameters";
            throw new ViewParameterException(errorMessage);
        }
        this.eventType = parentEventType;
        this.criteriaExpressionEvals = ExprNodeUtilityRich.getEvaluatorsMayCompile(this.criteriaExpressions, statementContext.getEngineImportService(), GroupByViewFactory.class, false, statementContext.getStatementName());
        this.propertyNames = new String[this.criteriaExpressions.length];
        for (int i = 0; i < this.criteriaExpressions.length; ++i) {
            this.propertyNames[i] = ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(this.criteriaExpressions[i]);
        }
    }

    @Override
    public ExprNode[] getCriteriaExpressions() {
        return this.criteriaExpressions;
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        if (this.isReclaimAged) {
            return new GroupByViewReclaimAged(this, agentInstanceViewFactoryContext);
        }
        return new GroupByViewImpl(this, agentInstanceViewFactoryContext);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view, AgentInstanceContext agentInstanceContext) {
        return false;
    }

    @Override
    public boolean isReclaimAged() {
        return this.isReclaimAged;
    }

    public long getReclaimMaxAge() {
        return this.reclaimMaxAge;
    }

    public long getReclaimFrequency() {
        return this.reclaimFrequency;
    }

    @Override
    public String getViewName() {
        return "Group-By";
    }

    public ExprEvaluator[] getCriteriaExpressionEvals() {
        return this.criteriaExpressionEvals;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }
}

