/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stat;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.codegen.ExprNodeCompiler;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.stat.CorrelationView;
import com.espertech.esper.view.stat.RegressionLinestViewFactory;
import com.espertech.esper.view.stat.StatViewAdditionalProps;
import java.util.List;

public class CorrelationViewFactory
implements ViewFactory {
    private List<ExprNode> viewParameters;
    private int streamNumber;
    protected ExprNode expressionX;
    protected ExprEvaluator expressionXEval;
    protected ExprNode expressionY;
    protected ExprEvaluator expressionYEval;
    protected StatViewAdditionalProps additionalProps;
    protected EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
        this.streamNumber = viewFactoryContext.getStreamNum();
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        ExprNode[] validated = ViewFactorySupport.validate(this.getViewName(), parentEventType, statementContext, this.viewParameters, true);
        if (validated.length < 2) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        if (!JavaClassHelper.isNumeric(validated[0].getForge().getEvaluationType()) || !JavaClassHelper.isNumeric(validated[1].getForge().getEvaluationType())) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        this.expressionX = validated[0];
        this.expressionXEval = ExprNodeCompiler.allocateEvaluator(this.expressionX.getForge(), statementContext.getEngineImportService(), RegressionLinestViewFactory.class, false, statementContext.getStatementName());
        this.expressionY = validated[1];
        this.expressionYEval = ExprNodeCompiler.allocateEvaluator(this.expressionY.getForge(), statementContext.getEngineImportService(), RegressionLinestViewFactory.class, false, statementContext.getStatementName());
        this.additionalProps = StatViewAdditionalProps.make(validated, 2, parentEventType, statementContext.getEngineImportService(), statementContext.getStatementName());
        this.eventType = CorrelationView.createEventType(statementContext, this.additionalProps, this.streamNumber);
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        return new CorrelationView(this, agentInstanceViewFactoryContext.getAgentInstanceContext(), this.expressionX, this.expressionXEval, this.expressionY, this.expressionYEval, this.eventType, this.additionalProps);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view, AgentInstanceContext agentInstanceContext) {
        if (!(view instanceof CorrelationView)) {
            return false;
        }
        if (this.additionalProps != null) {
            return false;
        }
        CorrelationView other = (CorrelationView)view;
        return ExprNodeUtilityCore.deepEquals(other.getExpressionX(), this.expressionX, false) && ExprNodeUtilityCore.deepEquals(other.getExpressionY(), this.expressionY, false);
    }

    @Override
    public String getViewName() {
        return "Correlation";
    }

    public StatViewAdditionalProps getAdditionalProps() {
        return this.additionalProps;
    }

    private String getViewParamMessage() {
        return this.getViewName() + " view requires two expressions providing x and y values as properties";
    }
}

