/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.view.AsymetricDataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.internal.IntersectViewFactory;
import com.espertech.esper.view.internal.UnionAsymetricView;
import com.espertech.esper.view.internal.UnionView;
import com.espertech.esper.view.internal.ViewFactoryContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UnionViewFactory
implements ViewFactory,
DataWindowViewFactory,
ViewFactoryContainer {
    protected EventType parentEventType;
    protected List<ViewFactory> viewFactories;

    public void setParentEventType(EventType parentEventType) {
        this.parentEventType = parentEventType;
    }

    public void setViewFactories(List<ViewFactory> viewFactories) {
        this.viewFactories = viewFactories;
    }

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> viewParameters) throws ViewParameterException {
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        boolean hasAsymetric = false;
        ArrayList<View> views = new ArrayList<View>();
        for (ViewFactory viewFactory : this.viewFactories) {
            views.add(viewFactory.makeView(agentInstanceViewFactoryContext));
            hasAsymetric |= viewFactory instanceof AsymetricDataWindowViewFactory;
        }
        if (hasAsymetric) {
            return new UnionAsymetricView(agentInstanceViewFactoryContext, this, this.parentEventType, views);
        }
        return new UnionView(agentInstanceViewFactoryContext, this, this.parentEventType, views);
    }

    @Override
    public EventType getEventType() {
        return this.parentEventType;
    }

    @Override
    public boolean canReuse(View view, AgentInstanceContext agentInstanceContext) {
        return false;
    }

    @Override
    public String getViewName() {
        return IntersectViewFactory.getViewNameUnionIntersect(false, this.viewFactories);
    }

    @Override
    public Collection<ViewFactory> getViewFactoriesContained() {
        return this.viewFactories;
    }
}

