/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPStatementHandle;
import com.espertech.esper.core.service.InternalEventRouter;
import com.espertech.esper.core.start.EPStatementStartMethodOnTriggerItem;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.view.internal.RouteResultViewHandler;

public abstract class RouteResultViewHandlerBase
implements RouteResultViewHandler {
    protected final InternalEventRouter internalEventRouter;
    private final TableStateInstance[] tableStateInstances;
    protected final EPStatementStartMethodOnTriggerItem[] items;
    protected final EPStatementHandle epStatementHandle;
    protected final ResultSetProcessor[] processors;
    protected final ExprEvaluator[] whereClauses;
    protected final EventBean[] eventsPerStream = new EventBean[1];
    protected final AgentInstanceContext agentInstanceContext;
    protected final boolean audit;

    public RouteResultViewHandlerBase(EPStatementHandle epStatementHandle, InternalEventRouter internalEventRouter, TableStateInstance[] tableStateInstances, EPStatementStartMethodOnTriggerItem[] items, ResultSetProcessor[] processors, ExprEvaluator[] whereClauses, AgentInstanceContext agentInstanceContext) {
        this.internalEventRouter = internalEventRouter;
        this.tableStateInstances = tableStateInstances;
        this.items = items;
        this.epStatementHandle = epStatementHandle;
        this.processors = processors;
        this.whereClauses = whereClauses;
        this.agentInstanceContext = agentInstanceContext;
        this.audit = AuditEnum.INSERT.getAudit(agentInstanceContext.getAnnotations()) != null;
    }

    boolean checkWhereClauseCurrentEvent(int index, ExprEvaluatorContext exprEvaluatorContext) {
        Boolean passEvent;
        boolean pass = true;
        if (!(this.whereClauses[index] == null || (passEvent = (Boolean)this.whereClauses[index].evaluate(this.eventsPerStream, true, exprEvaluatorContext)) != null && passEvent.booleanValue())) {
            pass = false;
        }
        return pass;
    }

    boolean mayRouteCurrentEvent(int index, ExprEvaluatorContext exprEvaluatorContext) {
        UniformPair<EventBean[]> result = this.processors[index].processViewResult(this.eventsPerStream, null, false);
        boolean routed = false;
        if (result != null && result.getFirst() != null && result.getFirst().length > 0) {
            this.route(result.getFirst()[0], index, exprEvaluatorContext);
            routed = true;
        }
        return routed;
    }

    private void route(EventBean routed, int index, ExprEvaluatorContext exprEvaluatorContext) {
        TableStateInstance tableStateInstance;
        if (this.audit) {
            AuditPath.auditInsertInto(this.agentInstanceContext.getEngineURI(), this.agentInstanceContext.getStatementName(), routed);
        }
        if ((tableStateInstance = this.tableStateInstances[index]) != null) {
            tableStateInstance.addEventUnadorned(routed);
        } else {
            boolean isNamedWindowInsert = this.items[index].isNamedWindowInsert();
            this.internalEventRouter.route(routed, this.epStatementHandle, this.agentInstanceContext.getStatementContext().getInternalEventEngineRouteDest(), exprEvaluatorContext, isNamedWindowInsert);
        }
    }
}

