/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.ext;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.codegen.ExprNodeCompiler;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConstZero;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ext.IStreamSortRankRandomAccess;
import com.espertech.esper.view.ext.TimeOrderView;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import java.util.List;

public class TimeToLiveViewFactory
implements DataWindowViewFactory,
DataWindowViewWithPrevious {
    private List<ExprNode> viewParameters;
    protected ExprNode timestampExpression;
    protected ExprEvaluator timestampExpressionEvaluator;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        ExprNode[] validated = ViewFactorySupport.validate(this.getViewName(), parentEventType, statementContext, this.viewParameters, true);
        if (this.viewParameters.size() != 1) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        if (JavaClassHelper.getBoxedType(validated[0].getForge().getEvaluationType()) != Long.class) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        this.timestampExpression = validated[0];
        this.eventType = parentEventType;
        this.timestampExpressionEvaluator = ExprNodeCompiler.allocateEvaluator(this.timestampExpression.getForge(), statementContext.getEngineImportService(), TimeToLiveViewFactory.class, false, statementContext.getStatementName());
    }

    @Override
    public Object makePreviousGetter() {
        return new RandomAccessByIndexGetter();
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        IStreamSortRankRandomAccess sortedRandomAccess = agentInstanceViewFactoryContext.getStatementContext().getViewServicePreviousFactory().getOptPreviousExprSortedRankedAccess(agentInstanceViewFactoryContext);
        return new TimeOrderView(agentInstanceViewFactoryContext, this, this.timestampExpression, this.timestampExpressionEvaluator, ExprTimePeriodEvalDeltaConstZero.INSTANCE, sortedRandomAccess);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view, AgentInstanceContext agentInstanceContext) {
        if (!(view instanceof TimeToLiveViewFactory)) {
            return false;
        }
        TimeToLiveViewFactory other = (TimeToLiveViewFactory)((Object)view);
        return ExprNodeUtilityCore.deepEquals(other.getTimestampExpression(), this.timestampExpression, false);
    }

    @Override
    public String getViewName() {
        return "Time-To-Live";
    }

    public ExprNode getTimestampExpression() {
        return this.timestampExpression;
    }

    public ExprEvaluator getTimestampExpressionEvaluator() {
        return this.timestampExpressionEvaluator;
    }

    private String getViewParamMessage() {
        return this.getViewName() + " view requires a single expression supplying long-type timestamp values as a parameter";
    }
}

