/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.EventBeanSummarizer;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.View;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ViewProxy
implements InvocationHandler {
    private static Method target = JavaClassHelper.getMethodByName(View.class, "update");
    private final String engineURI;
    private final String statementName;
    private final String viewName;
    private final View view;

    public static Object newInstance(String engineURI, String statementName, String viewName, View view) {
        return Proxy.newProxyInstance(view.getClass().getClassLoader(), JavaClassHelper.getSuperInterfaces(view.getClass()), (InvocationHandler)new ViewProxy(engineURI, statementName, viewName, view));
    }

    public ViewProxy(String engineURI, String statementName, String viewName, View view) {
        this.engineURI = engineURI;
        this.statementName = statementName;
        this.viewName = viewName;
        this.view = view;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (!m.equals(target)) {
            return m.invoke((Object)this.view, args);
        }
        Object result = m.invoke((Object)this.view, args);
        if (AuditPath.isInfoEnabled()) {
            EventBean[] newData = (EventBean[])args[0];
            EventBean[] oldData = (EventBean[])args[1];
            AuditPath.auditLog(this.engineURI, this.statementName, AuditEnum.VIEW, this.viewName + " insert {" + EventBeanSummarizer.summarize(newData) + "} remove {" + EventBeanSummarizer.summarize(oldData) + "}");
        }
        return result;
    }
}

