/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConstFactory;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConstFactoryMsec;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConstGivenDelta;
import com.espertech.esper.epl.expression.time.ExprTimePeriodUtil;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;

public class ViewFactoryTimePeriodHelper {
    public static ExprTimePeriodEvalDeltaConstFactory validateAndEvaluateTimeDeltaFactory(String viewName, StatementContext statementContext, ExprNode expression, String expectedMessage, int expressionNumber) throws ViewParameterException {
        ExprTimePeriodEvalDeltaConstFactory factory;
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(statementContext.getEngineURI(), false);
        if (expression instanceof ExprTimePeriod) {
            ExprTimePeriod validated = (ExprTimePeriod)ViewFactorySupport.validateExpr(viewName, statementContext, expression, streamTypeService, expressionNumber);
            factory = validated.constEvaluator(new ExprEvaluatorContextStatement(statementContext, false));
        } else {
            ExprNode validated = ViewFactorySupport.validateExpr(viewName, statementContext, expression, streamTypeService, expressionNumber);
            ExprEvaluator secondsEvaluator = validated.getForge().getExprEvaluator();
            Class returnType = JavaClassHelper.getBoxedType(validated.getForge().getEvaluationType());
            if (!JavaClassHelper.isNumeric(returnType)) {
                throw new ViewParameterException(expectedMessage);
            }
            if (validated.isConstantResult()) {
                Number time = (Number)ViewFactorySupport.evaluate(secondsEvaluator, 0, viewName, statementContext);
                if (!ExprTimePeriodUtil.validateTime(time, statementContext.getTimeAbacus())) {
                    throw new ViewParameterException(ExprTimePeriodUtil.getTimeInvalidMsg(viewName, "view", time));
                }
                long msec = statementContext.getTimeAbacus().deltaForSecondsNumber(time);
                factory = new ExprTimePeriodEvalDeltaConstGivenDelta(msec);
            } else {
                factory = new ExprTimePeriodEvalDeltaConstFactoryMsec(secondsEvaluator, statementContext.getTimeAbacus());
            }
        }
        return factory;
    }
}

