/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import com.espertech.esper.util.SimpleTypeCaster;
import com.espertech.esper.util.SimpleTypeCasterAnyType;
import com.espertech.esper.util.TypeWidener;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SimpleTypeCasterFactory {
    public static SimpleTypeCaster getCaster(Class fromType, Class targetType) {
        if (fromType == targetType) {
            return new NullCaster();
        }
        if ((targetType = JavaClassHelper.getBoxedType(targetType)) == Integer.class) {
            return new IntCaster();
        }
        if (targetType == Long.class) {
            return new LongCaster();
        }
        if (targetType == Double.class) {
            return new DoubleCaster();
        }
        if (targetType == Float.class) {
            return new FloatCaster();
        }
        if (targetType == Short.class) {
            return new ShortCaster();
        }
        if (targetType == Byte.class) {
            return new ByteCaster();
        }
        if (targetType == Character.class && fromType == String.class) {
            return new CharacterCaster();
        }
        if (targetType == BigInteger.class) {
            return new BigIntCaster();
        }
        if (targetType == BigDecimal.class) {
            if (JavaClassHelper.isFloatingPointClass(fromType)) {
                return new BigDecDoubleCaster();
            }
            return new BigDecLongCaster();
        }
        return new SimpleTypeCasterAnyType(targetType);
    }

    private static class NullCaster
    implements SimpleTypeCaster {
        private NullCaster() {
        }

        @Override
        public Object cast(Object object) {
            return object;
        }

        @Override
        public boolean isNumericCast() {
            return false;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return input;
        }
    }

    private static class BigDecDoubleCaster
    implements SimpleTypeCaster {
        private BigDecDoubleCaster() {
        }

        @Override
        public Object cast(Object object) {
            double value = ((Number)object).doubleValue();
            return new BigDecimal(value);
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (inputType.isPrimitive() || JavaClassHelper.isSubclassOrImplementsInterface(inputType, Number.class)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerBigDecDouble.codegenBigDec(input, inputType);
            }
            return CodegenExpressionBuilder.staticMethod(BigDecimal.class, "valueOf", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(Number.class, input), "doubleValue", new CodegenExpression[0]));
        }
    }

    private static class BigDecLongCaster
    implements SimpleTypeCaster {
        private BigDecLongCaster() {
        }

        @Override
        public Object cast(Object object) {
            long value = ((Number)object).longValue();
            return new BigDecimal(value);
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (inputType.isPrimitive() || JavaClassHelper.isSubclassOrImplementsInterface(inputType, Number.class)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerBigDecLong.codegenBigDec(input, inputType);
            }
            return CodegenExpressionBuilder.staticMethod(BigDecimal.class, "valueOf", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(Number.class, input), "longValue", new CodegenExpression[0]));
        }
    }

    private static class BigIntCaster
    implements SimpleTypeCaster {
        private BigIntCaster() {
        }

        @Override
        public Object cast(Object object) {
            long value = ((Number)object).longValue();
            return BigInteger.valueOf(value);
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (inputType.isPrimitive() || JavaClassHelper.isSubclassOrImplementsInterface(inputType, Number.class)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerBigInt.codegenBigInt(input, inputType);
            }
            return CodegenExpressionBuilder.staticMethod(BigInteger.class, "valueOf", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(Number.class, input), "longValue", new CodegenExpression[0]));
        }
    }

    public static class CharacterCaster
    implements SimpleTypeCaster,
    TypeWidener {
        @Override
        public Object cast(Object object) {
            String value = object.toString();
            if (value.length() == 0) {
                return null;
            }
            return Character.valueOf(value.charAt(0));
        }

        @Override
        public Object widen(Object input) {
            return this.cast(input);
        }

        @Override
        public boolean isNumericCast() {
            return false;
        }

        @Override
        public CodegenExpression widenCodegen(CodegenExpression expression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return this.codegen(expression, Object.class, codegenMethodScope, codegenClassScope);
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            CodegenMethodNode method = codegenMethodScope.makeChild(Character.class, CharacterCaster.class, codegenClassScope).addParam(Object.class, "object").getBlock().declareVar(String.class, "value", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("object"), "toString", new CodegenExpression[0])).ifCondition(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "length", new CodegenExpression[0]), CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.constantNull()).methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "charAt", CodegenExpressionBuilder.constant(0)));
            return CodegenExpressionBuilder.localMethodBuild(method).pass(input).call();
        }
    }

    private static class ByteCaster
    implements SimpleTypeCaster {
        private ByteCaster() {
        }

        @Override
        public Object cast(Object object) {
            return ((Number)object).byteValue();
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (inputType.isPrimitive() || JavaClassHelper.isSubclassOrImplementsInterface(inputType, Number.class)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerByte.codegenByte(input, inputType);
            }
            return CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(Number.class, input), "byteValue", new CodegenExpression[0]);
        }
    }

    private static class ShortCaster
    implements SimpleTypeCaster {
        private ShortCaster() {
        }

        @Override
        public Object cast(Object object) {
            return ((Number)object).shortValue();
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (inputType.isPrimitive() || JavaClassHelper.isSubclassOrImplementsInterface(inputType, Number.class)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerShort.codegenShort(input, inputType);
            }
            return CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(Number.class, input), "shortValue", new CodegenExpression[0]);
        }
    }

    private static class IntCaster
    implements SimpleTypeCaster {
        private IntCaster() {
        }

        @Override
        public Object cast(Object object) {
            return ((Number)object).intValue();
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (inputType.isPrimitive() || JavaClassHelper.isSubclassOrImplementsInterface(inputType, Number.class)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerInt.codegenInt(input, inputType);
            }
            return CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(Number.class, input), "intValue", new CodegenExpression[0]);
        }
    }

    private static class LongCaster
    implements SimpleTypeCaster {
        private LongCaster() {
        }

        @Override
        public Object cast(Object object) {
            return ((Number)object).longValue();
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (inputType.isPrimitive() || JavaClassHelper.isSubclassOrImplementsInterface(inputType, Number.class)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerLong.codegenLong(input, inputType);
            }
            return CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(Number.class, input), "longValue", new CodegenExpression[0]);
        }
    }

    private static class FloatCaster
    implements SimpleTypeCaster {
        private FloatCaster() {
        }

        @Override
        public Object cast(Object object) {
            return Float.valueOf(((Number)object).floatValue());
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (inputType.isPrimitive() || JavaClassHelper.isSubclassOrImplementsInterface(inputType, Number.class)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerFloat.codegenFloat(input, inputType);
            }
            return CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(Number.class, input), "floatValue", new CodegenExpression[0]);
        }
    }

    private static class DoubleCaster
    implements SimpleTypeCaster {
        private DoubleCaster() {
        }

        @Override
        public Object cast(Object object) {
            return ((Number)object).doubleValue();
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (inputType.isPrimitive() || JavaClassHelper.isSubclassOrImplementsInterface(inputType, Number.class)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDouble(input, inputType);
            }
            return CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(Number.class, input), "doubleValue", new CodegenExpression[0]);
        }
    }
}

