/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.collection.HashableMultiKey;
import java.io.Serializable;
import java.util.Comparator;

public final class HashableMultiKeyComparator
implements Comparator<HashableMultiKey>,
Serializable {
    private final boolean[] isDescendingValues;
    private static final long serialVersionUID = -5990983090238885417L;

    public HashableMultiKeyComparator(boolean[] isDescendingValues) {
        this.isDescendingValues = isDescendingValues;
    }

    @Override
    public final int compare(HashableMultiKey firstValues, HashableMultiKey secondValues) {
        if (firstValues.size() != this.isDescendingValues.length || secondValues.size() != this.isDescendingValues.length) {
            throw new IllegalArgumentException("Incompatible size MultiKey sizes for comparison");
        }
        for (int i = 0; i < firstValues.size(); ++i) {
            boolean isDescending;
            Object valueTwo;
            Object valueOne = firstValues.get(i);
            int comparisonResult = HashableMultiKeyComparator.compareValues(valueOne, valueTwo = secondValues.get(i), isDescending = this.isDescendingValues[i]);
            if (comparisonResult == 0) continue;
            return comparisonResult;
        }
        if (!firstValues.equals(secondValues)) {
            return -1;
        }
        return 0;
    }

    protected static int compareValues(Object valueOne, Object valueTwo, boolean isDescending) {
        if (valueOne == null || valueTwo == null) {
            if (valueOne == null && valueTwo == null) {
                return 0;
            }
            if (valueOne == null) {
                if (isDescending) {
                    return 1;
                }
                return -1;
            }
            if (isDescending) {
                return -1;
            }
            return 1;
        }
        if (!(valueOne instanceof Comparable)) {
            throw new ClassCastException("Cannot sort objects of type " + valueOne.getClass());
        }
        Comparable comparable1 = (Comparable)valueOne;
        if (isDescending) {
            return -1 * comparable1.compareTo(valueTwo);
        }
        return comparable1.compareTo(valueTwo);
    }
}

