/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.util.GraphCircularDependencyException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public class GraphUtil {
    public static Map<String, Object> mergeNestableMap(Map<String, Object> original, Map<String, Object> additional) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(original);
        for (Map.Entry<String, Object> additionalEntry : additional.entrySet()) {
            String name = additionalEntry.getKey();
            Object additionalValue = additionalEntry.getValue();
            Object originalValue = original.get(name);
            if (originalValue instanceof Map && additionalValue instanceof Map) {
                Map innerAdditional = (Map)additionalValue;
                Map innerOriginal = (Map)originalValue;
                Map<String, Object> newValue = GraphUtil.mergeNestableMap(innerOriginal, innerAdditional);
                result.put(name, newValue);
                continue;
            }
            if (original.containsKey(name)) continue;
            result.put(name, additionalValue);
        }
        return result;
    }

    public static Set<String> getTopDownOrder(Map<String, Set<String>> graph) throws GraphCircularDependencyException {
        Stack<String> circularDependency = GraphUtil.getFirstCircularDependency(graph);
        if (circularDependency != null) {
            throw new GraphCircularDependencyException("Circular dependency detected between " + circularDependency);
        }
        HashMap<String, Set<String>> reversedGraph = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : graph.entrySet()) {
            Set<String> set = entry.getValue();
            String child = entry.getKey();
            for (String parent : set) {
                LinkedHashSet<Object> childList = (LinkedHashSet<Object>)reversedGraph.get(parent);
                if (childList == null) {
                    childList = new LinkedHashSet<Object>();
                    reversedGraph.put(parent, childList);
                }
                childList.add(child);
            }
        }
        TreeSet<String> roots = new TreeSet<String>();
        for (Set<String> set : graph.values()) {
            if (set == null) continue;
            for (String parent : set) {
                if (graph.containsKey(parent)) continue;
                roots.add(parent);
            }
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String root : roots) {
            GraphUtil.recusiveAdd(linkedHashSet, root, reversedGraph);
        }
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        HashSet<String> removeList = new HashSet<String>();
        while (!linkedHashSet.isEmpty()) {
            removeList.clear();
            for (String node : linkedHashSet) {
                if (!GraphUtil.recursiveParentsCreated(node, linkedHashSet2, graph)) continue;
                linkedHashSet2.add(node);
                removeList.add(node);
            }
            linkedHashSet.removeAll(removeList);
        }
        return linkedHashSet2;
    }

    private static boolean recursiveParentsCreated(String node, Set<String> created, Map<String, Set<String>> graph) {
        Set<String> parents = graph.get(node);
        if (parents == null) {
            return true;
        }
        for (String parent : parents) {
            if (!created.contains(parent)) {
                return false;
            }
            boolean allParentsCreated = GraphUtil.recursiveParentsCreated(parent, created, graph);
            if (allParentsCreated) continue;
            return false;
        }
        return true;
    }

    private static void recusiveAdd(Set<String> graphFlattened, String root, Map<String, Set<String>> reversedGraph) {
        graphFlattened.add(root);
        Set<String> childNodes = reversedGraph.get(root);
        if (childNodes == null) {
            return;
        }
        for (String child : childNodes) {
            GraphUtil.recusiveAdd(graphFlattened, child, reversedGraph);
        }
    }

    private static Stack<String> getFirstCircularDependency(Map<String, Set<String>> graph) {
        for (String child : graph.keySet()) {
            Stack<String> deepDependencies = new Stack<String>();
            deepDependencies.push(child);
            boolean isCircular = GraphUtil.recursiveDeepDepends(deepDependencies, child, graph);
            if (!isCircular) continue;
            return deepDependencies;
        }
        return null;
    }

    private static boolean recursiveDeepDepends(Stack<String> deepDependencies, String currentChild, Map<String, Set<String>> graph) {
        Set<String> required = graph.get(currentChild);
        if (required == null) {
            return false;
        }
        for (String parent : required) {
            if (deepDependencies.contains(parent)) {
                return true;
            }
            deepDependencies.push(parent);
            boolean isDeep = GraphUtil.recursiveDeepDepends(deepDependencies, parent, graph);
            if (isDeep) {
                return true;
            }
            deepDependencies.pop();
        }
        return false;
    }
}

