/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.client.annotation.AuditEnum;

public class AuditContext {
    private final String engineURI;
    private final String statementName;
    private final AuditEnum category;
    private final String message;

    public AuditContext(String engineURI, String statementName, AuditEnum category, String message) {
        this.engineURI = engineURI;
        this.statementName = statementName;
        this.category = category;
        this.message = message;
    }

    public String getEngineURI() {
        return this.engineURI;
    }

    public String getStatementName() {
        return this.statementName;
    }

    public AuditEnum getCategory() {
        return this.category;
    }

    public String getMessage() {
        return this.message;
    }

    public String format() {
        return AuditContext.defaultFormat(this.statementName, this.category, this.message);
    }

    public static String defaultFormat(String statementName, AuditEnum category, String message) {
        StringBuilder buf = new StringBuilder();
        buf.append("Statement ");
        buf.append(statementName);
        buf.append(" ");
        buf.append(category.getPrettyPrintText());
        buf.append(" ");
        buf.append(message);
        return buf.toString();
    }
}

