/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.spatial.quadtree.prqdrowindex;

import com.espertech.esper.client.EPException;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableUnique;
import com.espertech.esper.spatial.quadtree.core.BoundingBox;
import com.espertech.esper.spatial.quadtree.core.QuadrantEnum;
import com.espertech.esper.spatial.quadtree.pointregion.PointRegionQuadTree;
import com.espertech.esper.spatial.quadtree.pointregion.PointRegionQuadTreeNode;
import com.espertech.esper.spatial.quadtree.pointregion.PointRegionQuadTreeNodeBranch;
import com.espertech.esper.spatial.quadtree.pointregion.PointRegionQuadTreeNodeLeaf;
import com.espertech.esper.spatial.quadtree.prqdrowindex.XYPointMultiType;
import java.util.Collection;
import java.util.LinkedList;

public class PointRegionQuadTreeRowIndexAdd {
    public static boolean add(double x, double y, Object value, PointRegionQuadTree<Object> tree, boolean unique, String indexName) {
        PointRegionQuadTreeNode<Object> root = tree.getRoot();
        if (!root.getBb().containsPoint(x, y)) {
            return false;
        }
        PointRegionQuadTreeNode<Object> replacement = PointRegionQuadTreeRowIndexAdd.addToNode(x, y, value, root, tree, unique, indexName);
        tree.setRoot(replacement);
        return true;
    }

    private static PointRegionQuadTreeNode<Object> addToNode(double x, double y, Object value, PointRegionQuadTreeNode<Object> node, PointRegionQuadTree<Object> tree, boolean unique, String indexName) {
        if (node instanceof PointRegionQuadTreeNodeLeaf) {
            PointRegionQuadTreeNodeLeaf leaf = (PointRegionQuadTreeNodeLeaf)node;
            if (leaf.getCount() < tree.getLeafCapacity() || node.getLevel() >= tree.getMaxTreeHeight()) {
                int numAdded = PointRegionQuadTreeRowIndexAdd.addToLeaf(leaf, x, y, value, unique, indexName);
                leaf.incCount(numAdded);
                if (leaf.getCount() <= tree.getLeafCapacity() || node.getLevel() >= tree.getMaxTreeHeight()) {
                    return leaf;
                }
            }
            node = PointRegionQuadTreeRowIndexAdd.subdivide(leaf, tree, unique, indexName);
        }
        PointRegionQuadTreeNodeBranch branch = (PointRegionQuadTreeNodeBranch)node;
        PointRegionQuadTreeRowIndexAdd.addToBranch(branch, x, y, value, tree, unique, indexName);
        return node;
    }

    private static void addToBranch(PointRegionQuadTreeNodeBranch<Object> branch, double x, double y, Object value, PointRegionQuadTree<Object> tree, boolean unique, String indexName) {
        QuadrantEnum quadrant = branch.getBb().getQuadrant(x, y);
        if (quadrant == QuadrantEnum.NW) {
            branch.setNw(PointRegionQuadTreeRowIndexAdd.addToNode(x, y, value, branch.getNw(), tree, unique, indexName));
        } else if (quadrant == QuadrantEnum.NE) {
            branch.setNe(PointRegionQuadTreeRowIndexAdd.addToNode(x, y, value, branch.getNe(), tree, unique, indexName));
        } else if (quadrant == QuadrantEnum.SW) {
            branch.setSw(PointRegionQuadTreeRowIndexAdd.addToNode(x, y, value, branch.getSw(), tree, unique, indexName));
        } else {
            branch.setSe(PointRegionQuadTreeRowIndexAdd.addToNode(x, y, value, branch.getSe(), tree, unique, indexName));
        }
    }

    private static PointRegionQuadTreeNode<Object> subdivide(PointRegionQuadTreeNodeLeaf<Object> leaf, PointRegionQuadTree<Object> tree, boolean unique, String indexName) {
        double w = (leaf.getBb().getMaxX() - leaf.getBb().getMinX()) / 2.0;
        double h = (leaf.getBb().getMaxY() - leaf.getBb().getMinY()) / 2.0;
        double minx = leaf.getBb().getMinX();
        double miny = leaf.getBb().getMinY();
        BoundingBox bbNW = new BoundingBox(minx, miny, minx + w, miny + h);
        BoundingBox bbNE = new BoundingBox(minx + w, miny, leaf.getBb().getMaxX(), miny + h);
        BoundingBox bbSW = new BoundingBox(minx, miny + h, minx + w, leaf.getBb().getMaxY());
        BoundingBox bbSE = new BoundingBox(minx + w, miny + h, leaf.getBb().getMaxX(), leaf.getBb().getMaxY());
        PointRegionQuadTreeNodeLeaf<Object> nw = new PointRegionQuadTreeNodeLeaf<Object>(bbNW, leaf.getLevel() + 1, null, 0);
        PointRegionQuadTreeNodeLeaf<Object> ne = new PointRegionQuadTreeNodeLeaf<Object>(bbNE, leaf.getLevel() + 1, null, 0);
        PointRegionQuadTreeNodeLeaf<Object> sw = new PointRegionQuadTreeNodeLeaf<Object>(bbSW, leaf.getLevel() + 1, null, 0);
        PointRegionQuadTreeNodeLeaf<Object> se = new PointRegionQuadTreeNodeLeaf<Object>(bbSE, leaf.getLevel() + 1, null, 0);
        PointRegionQuadTreeNodeBranch<Object> branch = new PointRegionQuadTreeNodeBranch<Object>(leaf.getBb(), leaf.getLevel(), nw, ne, sw, se);
        Object points = leaf.getPoints();
        if (points instanceof XYPointMultiType) {
            XYPointMultiType point = (XYPointMultiType)points;
            PointRegionQuadTreeRowIndexAdd.subdividePoint(point, branch, tree, unique, indexName);
        } else {
            Collection collection = (Collection)points;
            for (XYPointMultiType point : collection) {
                PointRegionQuadTreeRowIndexAdd.subdividePoint(point, branch, tree, unique, indexName);
            }
        }
        return branch;
    }

    private static void subdividePoint(XYPointMultiType point, PointRegionQuadTreeNodeBranch<Object> branch, PointRegionQuadTree<Object> tree, boolean unique, String indexName) {
        double x = point.getX();
        double y = point.getY();
        QuadrantEnum quadrant = branch.getBb().getQuadrant(x, y);
        if (quadrant == QuadrantEnum.NW) {
            branch.setNw(PointRegionQuadTreeRowIndexAdd.addToNode(x, y, point, branch.getNw(), tree, unique, indexName));
        } else if (quadrant == QuadrantEnum.NE) {
            branch.setNe(PointRegionQuadTreeRowIndexAdd.addToNode(x, y, point, branch.getNe(), tree, unique, indexName));
        } else if (quadrant == QuadrantEnum.SW) {
            branch.setSw(PointRegionQuadTreeRowIndexAdd.addToNode(x, y, point, branch.getSw(), tree, unique, indexName));
        } else {
            branch.setSe(PointRegionQuadTreeRowIndexAdd.addToNode(x, y, point, branch.getSe(), tree, unique, indexName));
        }
    }

    public static int addToLeaf(PointRegionQuadTreeNodeLeaf<Object> leaf, double x, double y, Object value, boolean unique, String indexName) {
        Object currentValue = leaf.getPoints();
        if (value instanceof XYPointMultiType) {
            XYPointMultiType point = (XYPointMultiType)value;
            if (point.getX() != x && point.getY() != y) {
                throw new IllegalStateException();
            }
            if (currentValue == null) {
                leaf.setPoints(point);
                return point.count();
            }
            if (currentValue instanceof XYPointMultiType) {
                XYPointMultiType other = (XYPointMultiType)currentValue;
                if (other.getX() == x && other.getY() == y) {
                    if (unique) {
                        throw PointRegionQuadTreeRowIndexAdd.handleUniqueViolation(indexName, other.getX(), other.getY());
                    }
                    other.addMultiType(point);
                    return point.count();
                }
                LinkedList<XYPointMultiType> collection = new LinkedList<XYPointMultiType>();
                collection.add(other);
                collection.add(point);
                leaf.setPoints(collection);
                return point.count();
            }
            Collection collection = (Collection)currentValue;
            for (XYPointMultiType other : collection) {
                if (other.getX() != x || other.getY() != y) continue;
                if (unique) {
                    throw PointRegionQuadTreeRowIndexAdd.handleUniqueViolation(indexName, other.getX(), other.getY());
                }
                other.addMultiType(point);
                return point.count();
            }
            collection.add(point);
            return point.count();
        }
        if (currentValue == null) {
            XYPointMultiType point = new XYPointMultiType(x, y, value);
            leaf.setPoints(point);
            return 1;
        }
        if (currentValue instanceof XYPointMultiType) {
            XYPointMultiType other = (XYPointMultiType)currentValue;
            if (other.getX() == x && other.getY() == y) {
                if (unique) {
                    throw PointRegionQuadTreeRowIndexAdd.handleUniqueViolation(indexName, other.getX(), other.getY());
                }
                other.addSingleValue(value);
                return 1;
            }
            LinkedList<XYPointMultiType> collection = new LinkedList<XYPointMultiType>();
            collection.add(other);
            collection.add(new XYPointMultiType(x, y, value));
            leaf.setPoints(collection);
            return 1;
        }
        Collection collection = (Collection)currentValue;
        for (XYPointMultiType other : collection) {
            if (other.getX() != x || other.getY() != y) continue;
            if (unique) {
                throw PointRegionQuadTreeRowIndexAdd.handleUniqueViolation(indexName, other.getX(), other.getY());
            }
            other.addSingleValue(value);
            return 1;
        }
        collection.add(new XYPointMultiType(x, y, value));
        return 1;
    }

    private static EPException handleUniqueViolation(String indexName, double x, double y) {
        return PropertyIndexedEventTableUnique.handleUniqueIndexViolation(indexName, "(" + x + "," + y + ")");
    }
}

