/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.spatial.quadtree.prqdfilterindex;

import com.espertech.esper.spatial.quadtree.core.BoundingBox;
import com.espertech.esper.spatial.quadtree.core.QuadrantEnum;
import com.espertech.esper.spatial.quadtree.pointregion.PointRegionQuadTree;
import com.espertech.esper.spatial.quadtree.pointregion.PointRegionQuadTreeNode;
import com.espertech.esper.spatial.quadtree.pointregion.PointRegionQuadTreeNodeBranch;
import com.espertech.esper.spatial.quadtree.pointregion.PointRegionQuadTreeNodeLeaf;
import com.espertech.esper.spatial.quadtree.prqdfilterindex.PointRegionQuadTreeFilterIndexCheckBB;
import com.espertech.esper.spatial.quadtree.prqdfilterindex.XYPointWValue;
import java.util.Collection;
import java.util.LinkedList;

public class PointRegionQuadTreeFilterIndexSet {
    public static <L> void set(double x, double y, L value, PointRegionQuadTree<Object> tree) {
        PointRegionQuadTreeNode<Object> root = tree.getRoot();
        PointRegionQuadTreeFilterIndexCheckBB.checkBB(root.getBb(), x, y);
        PointRegionQuadTreeNode<Object> replacement = PointRegionQuadTreeFilterIndexSet.setOnNode(x, y, value, root, tree);
        tree.setRoot(replacement);
    }

    private static <L> PointRegionQuadTreeNode<Object> setOnNode(double x, double y, L value, PointRegionQuadTreeNode<Object> node, PointRegionQuadTree<Object> tree) {
        if (node instanceof PointRegionQuadTreeNodeLeaf) {
            PointRegionQuadTreeNodeLeaf leaf = (PointRegionQuadTreeNodeLeaf)node;
            int count = PointRegionQuadTreeFilterIndexSet.setOnLeaf(leaf, x, y, value);
            leaf.incCount(count);
            if (leaf.getCount() <= tree.getLeafCapacity() || node.getLevel() >= tree.getMaxTreeHeight()) {
                return leaf;
            }
            node = PointRegionQuadTreeFilterIndexSet.subdivide(leaf, tree);
        }
        PointRegionQuadTreeNodeBranch branch = (PointRegionQuadTreeNodeBranch)node;
        PointRegionQuadTreeFilterIndexSet.addToBranch(branch, x, y, value, tree);
        return node;
    }

    private static void addToBranch(PointRegionQuadTreeNodeBranch<Object> branch, double x, double y, Object value, PointRegionQuadTree<Object> tree) {
        QuadrantEnum quadrant = branch.getBb().getQuadrant(x, y);
        if (quadrant == QuadrantEnum.NW) {
            branch.setNw(PointRegionQuadTreeFilterIndexSet.setOnNode(x, y, value, branch.getNw(), tree));
        } else if (quadrant == QuadrantEnum.NE) {
            branch.setNe(PointRegionQuadTreeFilterIndexSet.setOnNode(x, y, value, branch.getNe(), tree));
        } else if (quadrant == QuadrantEnum.SW) {
            branch.setSw(PointRegionQuadTreeFilterIndexSet.setOnNode(x, y, value, branch.getSw(), tree));
        } else {
            branch.setSe(PointRegionQuadTreeFilterIndexSet.setOnNode(x, y, value, branch.getSe(), tree));
        }
    }

    private static <L> PointRegionQuadTreeNode<Object> subdivide(PointRegionQuadTreeNodeLeaf<Object> leaf, PointRegionQuadTree<Object> tree) {
        double w = (leaf.getBb().getMaxX() - leaf.getBb().getMinX()) / 2.0;
        double h = (leaf.getBb().getMaxY() - leaf.getBb().getMinY()) / 2.0;
        double minx = leaf.getBb().getMinX();
        double miny = leaf.getBb().getMinY();
        BoundingBox bbNW = new BoundingBox(minx, miny, minx + w, miny + h);
        BoundingBox bbNE = new BoundingBox(minx + w, miny, leaf.getBb().getMaxX(), miny + h);
        BoundingBox bbSW = new BoundingBox(minx, miny + h, minx + w, leaf.getBb().getMaxY());
        BoundingBox bbSE = new BoundingBox(minx + w, miny + h, leaf.getBb().getMaxX(), leaf.getBb().getMaxY());
        PointRegionQuadTreeNodeLeaf<Object> nw = new PointRegionQuadTreeNodeLeaf<Object>(bbNW, leaf.getLevel() + 1, null, 0);
        PointRegionQuadTreeNodeLeaf<Object> ne = new PointRegionQuadTreeNodeLeaf<Object>(bbNE, leaf.getLevel() + 1, null, 0);
        PointRegionQuadTreeNodeLeaf<Object> sw = new PointRegionQuadTreeNodeLeaf<Object>(bbSW, leaf.getLevel() + 1, null, 0);
        PointRegionQuadTreeNodeLeaf<Object> se = new PointRegionQuadTreeNodeLeaf<Object>(bbSE, leaf.getLevel() + 1, null, 0);
        PointRegionQuadTreeNodeBranch<Object> branch = new PointRegionQuadTreeNodeBranch<Object>(leaf.getBb(), leaf.getLevel(), nw, ne, sw, se);
        Object points = leaf.getPoints();
        if (points instanceof XYPointWValue) {
            XYPointWValue point = (XYPointWValue)points;
            PointRegionQuadTreeFilterIndexSet.subdividePoint(point, branch, tree);
        } else {
            Collection collection = (Collection)points;
            for (XYPointWValue point : collection) {
                PointRegionQuadTreeFilterIndexSet.subdividePoint(point, branch, tree);
            }
        }
        return branch;
    }

    private static <L> void subdividePoint(XYPointWValue<L> point, PointRegionQuadTreeNodeBranch<Object> branch, PointRegionQuadTree<Object> tree) {
        double x = point.getX();
        double y = point.getY();
        QuadrantEnum quadrant = branch.getBb().getQuadrant(x, y);
        if (quadrant == QuadrantEnum.NW) {
            branch.setNw(PointRegionQuadTreeFilterIndexSet.setOnNode(x, y, point, branch.getNw(), tree));
        } else if (quadrant == QuadrantEnum.NE) {
            branch.setNe(PointRegionQuadTreeFilterIndexSet.setOnNode(x, y, point, branch.getNe(), tree));
        } else if (quadrant == QuadrantEnum.SW) {
            branch.setSw(PointRegionQuadTreeFilterIndexSet.setOnNode(x, y, point, branch.getSw(), tree));
        } else {
            branch.setSe(PointRegionQuadTreeFilterIndexSet.setOnNode(x, y, point, branch.getSe(), tree));
        }
    }

    private static <L> int setOnLeaf(PointRegionQuadTreeNodeLeaf<Object> leaf, double x, double y, L value) {
        Object currentValue = leaf.getPoints();
        if (value instanceof XYPointWValue) {
            XYPointWValue point = (XYPointWValue)value;
            if (point.getX() != x && point.getY() != y) {
                throw new IllegalStateException();
            }
            if (currentValue == null) {
                leaf.setPoints(point);
                return 1;
            }
            if (currentValue instanceof XYPointWValue) {
                XYPointWValue other = (XYPointWValue)currentValue;
                if (other.getX() == x && other.getY() == y) {
                    other.setValue(value);
                    return 0;
                }
                LinkedList<XYPointWValue> collection = new LinkedList<XYPointWValue>();
                collection.add(other);
                collection.add(point);
                leaf.setPoints(collection);
                return 1;
            }
            Collection collection = (Collection)currentValue;
            for (XYPointWValue other : collection) {
                if (other.getX() != x || other.getY() != y) continue;
                other.setValue(value);
                return 0;
            }
            collection.add(point);
            return 1;
        }
        if (currentValue == null) {
            XYPointWValue<L> point = new XYPointWValue<L>(x, y, value);
            leaf.setPoints(point);
            return 1;
        }
        if (currentValue instanceof XYPointWValue) {
            XYPointWValue other = (XYPointWValue)currentValue;
            if (other.getX() == x && other.getY() == y) {
                other.setValue(value);
                return 0;
            }
            LinkedList<XYPointWValue<L>> collection = new LinkedList<XYPointWValue<L>>();
            collection.add(other);
            collection.add(new XYPointWValue<L>(x, y, value));
            leaf.setPoints(collection);
            return 1;
        }
        Collection collection = (Collection)currentValue;
        for (XYPointWValue other : collection) {
            if (other.getX() != x || other.getY() != y) continue;
            other.setValue(value);
            return 0;
        }
        collection.add(new XYPointWValue<L>(x, y, value));
        return 1;
    }
}

