/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.spatial.quadtree.prqdfilterindex;

import com.espertech.esper.filter.FilterHandleSetNode;
import com.espertech.esper.filter.FilterParamIndexBase;
import com.espertech.esper.spatial.quadtree.pointregion.PointRegionQuadTree;
import com.espertech.esper.spatial.quadtree.pointregion.PointRegionQuadTreeNode;
import com.espertech.esper.spatial.quadtree.pointregion.PointRegionQuadTreeNodeBranch;
import com.espertech.esper.spatial.quadtree.pointregion.PointRegionQuadTreeNodeLeaf;
import com.espertech.esper.spatial.quadtree.prqdfilterindex.XYPointWValue;
import java.util.Collection;

public class PointRegionQuadTreeFilterIndexCount {
    public static int count(PointRegionQuadTree<Object> quadTree) {
        return PointRegionQuadTreeFilterIndexCount.count(quadTree.getRoot());
    }

    private static int count(PointRegionQuadTreeNode<Object> node) {
        if (node instanceof PointRegionQuadTreeNodeLeaf) {
            PointRegionQuadTreeNodeLeaf leaf = (PointRegionQuadTreeNodeLeaf)node;
            return PointRegionQuadTreeFilterIndexCount.countLeaf(leaf);
        }
        PointRegionQuadTreeNodeBranch branch = (PointRegionQuadTreeNodeBranch)node;
        return PointRegionQuadTreeFilterIndexCount.count(branch.getNw()) + PointRegionQuadTreeFilterIndexCount.count(branch.getNe()) + PointRegionQuadTreeFilterIndexCount.count(branch.getSw()) + PointRegionQuadTreeFilterIndexCount.count(branch.getSe());
    }

    private static int countLeaf(PointRegionQuadTreeNodeLeaf<Object> leaf) {
        if (leaf.getPoints() == null) {
            return 0;
        }
        if (leaf.getPoints() instanceof XYPointWValue) {
            return PointRegionQuadTreeFilterIndexCount.countCallbacks(leaf.getPoints());
        }
        Collection coll = (Collection)leaf.getPoints();
        int count = 0;
        for (XYPointWValue p : coll) {
            count += PointRegionQuadTreeFilterIndexCount.countCallbacks(p.getValue());
        }
        return count;
    }

    private static int countCallbacks(Object points) {
        if (points instanceof FilterHandleSetNode) {
            return ((FilterHandleSetNode)points).getFilterCallbackCount();
        }
        if (points instanceof FilterParamIndexBase) {
            return ((FilterParamIndexBase)points).sizeExpensive();
        }
        return 1;
    }
}

