/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.spatial.quadtree.mxciffilterindex;

import com.espertech.esper.spatial.quadtree.core.QuadrantAppliesEnum;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTree;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTreeNode;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTreeNodeBranch;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTreeNodeLeaf;
import com.espertech.esper.spatial.quadtree.mxciffilterindex.XYWHRectangleWValue;
import com.espertech.esper.spatial.quadtree.mxcifrowindex.MXCIFQuadTreeFilterIndexCheckBB;
import java.util.Collection;

public class MXCIFQuadTreeFilterIndexGet {
    public static <L> L get(double x, double y, double width, double height, MXCIFQuadTree<Object> tree) {
        MXCIFQuadTreeFilterIndexCheckBB.checkBB(tree.getRoot().getBb(), x, y, width, height);
        return MXCIFQuadTreeFilterIndexGet.get(x, y, width, height, tree.getRoot());
    }

    private static <L> L get(double x, double y, double width, double height, MXCIFQuadTreeNode<Object> node) {
        if (node instanceof MXCIFQuadTreeNodeLeaf) {
            MXCIFQuadTreeNodeLeaf leaf = (MXCIFQuadTreeNodeLeaf)node;
            return MXCIFQuadTreeFilterIndexGet.getFromData(x, y, width, height, leaf.getData());
        }
        MXCIFQuadTreeNodeBranch branch = (MXCIFQuadTreeNodeBranch)node;
        QuadrantAppliesEnum q = node.getBb().getQuadrantApplies(x, y, width, height);
        if (q == QuadrantAppliesEnum.NW) {
            return MXCIFQuadTreeFilterIndexGet.get(x, y, width, height, branch.getNw());
        }
        if (q == QuadrantAppliesEnum.NE) {
            return MXCIFQuadTreeFilterIndexGet.get(x, y, width, height, branch.getNe());
        }
        if (q == QuadrantAppliesEnum.SW) {
            return MXCIFQuadTreeFilterIndexGet.get(x, y, width, height, branch.getSw());
        }
        if (q == QuadrantAppliesEnum.SE) {
            return MXCIFQuadTreeFilterIndexGet.get(x, y, width, height, branch.getSe());
        }
        if (q == QuadrantAppliesEnum.SOME) {
            return MXCIFQuadTreeFilterIndexGet.getFromData(x, y, width, height, branch.getData());
        }
        throw new IllegalStateException("Not applicable to any quadrant");
    }

    private static <L> L getFromData(double x, double y, double width, double height, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof XYWHRectangleWValue) {
            XYWHRectangleWValue value = (XYWHRectangleWValue)data;
            if (value.coordinateEquals(x, y, width, height)) {
                return value.getValue();
            }
            return null;
        }
        Collection collection = (Collection)data;
        for (XYWHRectangleWValue rectangle : collection) {
            if (!rectangle.coordinateEquals(x, y, width, height)) continue;
            return rectangle.getValue();
        }
        return null;
    }
}

