/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.schedule;

import com.espertech.esper.schedule.ScheduleAdjustmentCallback;
import java.util.HashSet;
import java.util.Set;

public class ScheduleAdjustmentService {
    private Set<ScheduleAdjustmentCallback> callbacks;

    public synchronized void addCallback(ScheduleAdjustmentCallback callback) {
        if (this.callbacks == null) {
            this.callbacks = new HashSet<ScheduleAdjustmentCallback>();
        }
        this.callbacks.add(callback);
    }

    public void adjust(long delta) {
        if (this.callbacks == null) {
            return;
        }
        for (ScheduleAdjustmentCallback callback : this.callbacks) {
            callback.adjust(delta);
        }
    }

    public void removeCallback(ScheduleAdjustmentCallback callback) {
        if (this.callbacks == null) {
            return;
        }
        this.callbacks.remove(callback);
    }
}

