/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.rowregex;

public enum RegexNFATypeEnum {
    SINGLE(false, false, null, ""),
    ZERO_TO_MANY(true, true, true, "*"),
    ONE_TO_MANY(true, false, true, "+"),
    ONE_OPTIONAL(false, true, true, "?"),
    ZERO_TO_MANY_RELUCTANT(true, true, false, "*?"),
    ONE_TO_MANY_RELUCTANT(true, false, false, "+?"),
    ONE_OPTIONAL_RELUCTANT(false, true, false, "??");

    private boolean multipleMatches;
    private boolean optional;
    private Boolean greedy;
    private String text;

    private RegexNFATypeEnum(boolean multipleMatches, boolean optional, Boolean greedy, String text) {
        this.multipleMatches = multipleMatches;
        this.optional = optional;
        this.greedy = greedy;
        this.text = text;
    }

    public boolean isMultipleMatches() {
        return this.multipleMatches;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Boolean isGreedy() {
        return this.greedy;
    }

    public static RegexNFATypeEnum fromString(String code, String reluctantQuestion) {
        boolean reluctant = false;
        if (reluctantQuestion != null) {
            if (!reluctantQuestion.equals("?")) {
                throw new IllegalArgumentException("Invalid code for pattern type: " + code + " reluctant '" + reluctantQuestion + "'");
            }
            reluctant = true;
        }
        if (code == null) {
            return SINGLE;
        }
        if (code.equals("*")) {
            return reluctant ? ZERO_TO_MANY_RELUCTANT : ZERO_TO_MANY;
        }
        if (code.equals("+")) {
            return reluctant ? ONE_TO_MANY_RELUCTANT : ONE_TO_MANY;
        }
        if (code.equals("?")) {
            return reluctant ? ONE_OPTIONAL_RELUCTANT : ONE_OPTIONAL;
        }
        throw new IllegalArgumentException("Invalid code for pattern type: " + code);
    }

    public String getOptionalPostfix() {
        return this.text;
    }
}

