/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalFactoryNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNodeFactoryBase;
import com.espertech.esper.pattern.EvalNodeUtil;
import com.espertech.esper.pattern.EvalRootNode;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.PatternExpressionPrecedenceEnum;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class EvalRootFactoryNode
extends EvalNodeFactoryBase {
    private static final long serialVersionUID = -4478876398666926782L;
    public final int numTreeChildNodes;

    public EvalRootFactoryNode(EvalFactoryNode childNode) {
        this.addChildNode(childNode);
        this.numTreeChildNodes = this.assignFactoryNodeIds();
    }

    @Override
    public EvalNode makeEvalNode(PatternAgentInstanceContext agentInstanceContext, EvalNode parentNode) {
        EvalNode child = EvalNodeUtil.makeEvalNodeSingleChild(this.getChildNodes(), agentInstanceContext, parentNode);
        return new EvalRootNode(agentInstanceContext, this, child);
    }

    public final String toString() {
        return "EvalRootNode children=" + this.getChildNodes().size();
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public boolean isStateful() {
        return this.getChildNodes().get(0).isStateful();
    }

    public int getNumTreeChildNodes() {
        return this.numTreeChildNodes;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (!this.getChildNodes().isEmpty()) {
            this.getChildNodes().get(0).toEPL(writer, this.getPrecedence());
        }
    }

    @Override
    public PatternExpressionPrecedenceEnum getPrecedence() {
        return PatternExpressionPrecedenceEnum.MINIMUM;
    }

    private int assignFactoryNodeIds() {
        short count = 0;
        this.setFactoryNodeId(count);
        List<EvalFactoryNode> factories = EvalRootFactoryNode.collectFactories(this);
        for (EvalFactoryNode factoryNode : factories) {
            count = (short)(count + 1);
            factoryNode.setFactoryNodeId(count);
        }
        return count;
    }

    private static List<EvalFactoryNode> collectFactories(EvalRootFactoryNode rootFactory) {
        ArrayList<EvalFactoryNode> factories = new ArrayList<EvalFactoryNode>(8);
        for (EvalFactoryNode factoryNode : rootFactory.getChildNodes()) {
            EvalRootFactoryNode.collectFactoriesRecursive(factoryNode, factories);
        }
        return factories;
    }

    private static void collectFactoriesRecursive(EvalFactoryNode factoryNode, List<EvalFactoryNode> factories) {
        factories.add(factoryNode);
        for (EvalFactoryNode childNode : factoryNode.getChildNodes()) {
            EvalRootFactoryNode.collectFactoriesRecursive(childNode, factories);
        }
    }
}

